/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.CreateMemberOperation;

public class CreateFieldOperation
extends CreateMemberOperation {
    String fInitializer;

    public CreateFieldOperation(IStructure parentElement, String name, String returnType, String initializer, boolean force) {
        super(parentElement, name, returnType, force);
        this.fInitializer = initializer;
    }

    @Override
    public String getMainTaskName() {
        return CoreModelMessages.getString("operation.createFieldProgress");
    }

    @Override
    protected void initializeDefaultPosition() {
        IStructure parentElement = this.getStructure();
        try {
            ICElement[] elements = parentElement.getFields();
            if (elements != null && elements.length > 0) {
                this.createAfter(elements[elements.length - 1]);
            } else {
                elements = parentElement.getChildren();
                if (elements != null && elements.length > 0) {
                    this.createBefore(elements[0]);
                }
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    @Override
    protected ICElement generateResultHandle() {
        return this.getStructure().getField(this.fName);
    }

    @Override
    protected ICModelStatus verifyNameCollision() {
        return super.verifyNameCollision();
    }

    @Override
    protected String generateElement(ITranslationUnit unit) throws CModelException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fReturnType).append(' ');
        sb.append(this.fName);
        if (this.fInitializer != null && this.fInitializer.length() > 0) {
            sb.append(' ').append('=').append(' ');
            sb.append(this.fInitializer);
        }
        sb.append(';');
        return sb.toString();
    }
}

