/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.preferences;

import java.util.Collection;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.common.ui.util.SWTUtils;
import org.eclipse.datatools.sqltools.common.ui.util.TableLayoutComposite;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.preferences.PreferenceMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SQLEditorPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPreferenceStore _store = this.getPreferenceStore();
    private PreferencePage _preferencePage;
    private Button _syntaxValidation;
    private Label _portabilityCheckLabel;
    private Combo _portabilityCheckCombo;
    private Button _maxLineButton;
    private Text _maxLineText;
    private Button _promptDisableButton;
    private Button _showSyntaxErorrDetail;
    private Button _executeBetweenDelimiter;
    private Combo _terminatorsCombo;
    private Button _executeCurrentLine;
    private Button _executeBetweenBlankLine;
    private Table _typingAidsTable;
    private Text _description;
    private final String[] _typingAidsName = new String[]{PreferenceMessages.SQLEditor_closeSingleQuotes, PreferenceMessages.SQLEditor_closeDoubleQuotes, PreferenceMessages.SQLEditor_closeBrackets, PreferenceMessages.SQLEditor_closeComments, PreferenceMessages.SQLEditor_beginEndStatement};
    private final String[] _typingAidsContext = new String[]{PreferenceMessages.SQLEditor_typingAidsTable_context_all, PreferenceMessages.SQLEditor_typingAidsTable_context_all, PreferenceMessages.SQLEditor_typingAidsTable_context_all, PreferenceMessages.SQLEditor_typingAidsTable_context_all, PreferenceMessages.SQLEditor_typingAidsTable_context_all};
    private final String[] _typingAidsDescription = new String[]{PreferenceMessages.SQLEditor_closeSingleQuotes_description, PreferenceMessages.SQLEditor_closeDoubleQuotes_description, PreferenceMessages.SQLEditor_closeBrackets_description, PreferenceMessages.SQLEditor_closeComments_description, PreferenceMessages.SQLEditor_beginEndStatement_description};
    private final String[] _typingAidsPreview = new String[]{PreferenceMessages.SQLEditor_closeSingleQuotes_preview, PreferenceMessages.SQLEditor_closeDoubleQuotes_preview, PreferenceMessages.SQLEditor_closeBrackets_preview, PreferenceMessages.SQLEditor_closeComments_preview, PreferenceMessages.SQLEditor_beginEndStatement_preview};
    private final String[] _typingAidsPreferences = new String[]{"SQLEditor.closeSingleQuotes", "SQLEditor.closeDoubleQuotes", "SQLEditor.closeBrackets", "SQLEditor.closeComments", "SQLEditor.closeBeginEndStatement"};

    protected Control createContents(Composite parent) {
        this._preferencePage = this;
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), HelpUtil.getContextId((String)"preferences_sql_editor", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, true);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        TabFolder folder = new TabFolder(composite, 0);
        GridLayout gridLayout = new GridLayout();
        folder.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        folder.setLayoutData((Object)gridData);
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferenceMessages.SQLEditor_general_title);
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(PreferenceMessages.SQLEditor_typing_title);
        item.setControl(this.createTypingPage((Composite)folder));
        this.initializeValues();
        this.update();
        this.updateMaxLineText();
        return composite;
    }

    private Control createAppearancePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Group syntaxValidationGroup = SWTUtils.createGroup((Composite)composite, (String)PreferenceMessages.SQLEditor_syntaxValidationGroup, (int)1);
        Composite composite1 = SWTUtils.createComposite((Composite)syntaxValidationGroup, (int)2);
        this._syntaxValidation = SWTUtils.createCheckBox((Composite)composite1, (String)PreferenceMessages.SQLEditor_syntaxValidation, (int)2, (int)0);
        this._syntaxValidation.setToolTipText(PreferenceMessages.SQLEditor_syntaxValidation_tooltip);
        this._syntaxValidation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPage.this.update();
            }
        });
        this.createPortabilityCheckCombo(composite1);
        this._maxLineButton = new Button(composite1, 32);
        this._maxLineButton.setText(PreferenceMessages.SQLEditor_maxLineButton);
        this._maxLineButton.setToolTipText(PreferenceMessages.SQLEditor_maxLineButton_tooltip);
        this._maxLineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPage.this.updateMaxLineText();
            }
        });
        this._maxLineText = SWTUtils.createTextBox((Composite)composite1, (int)1, (int)40);
        this._maxLineText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int maxRow = 0;
                    maxRow = Integer.parseInt(((Text)e.widget).getText().trim());
                    if (maxRow <= 0) {
                        SQLEditorPage.this._preferencePage.setMessage(PreferenceMessages.General_max_row_num, 3);
                        SQLEditorPage.this._preferencePage.setValid(false);
                    } else {
                        SQLEditorPage.this._preferencePage.setMessage(null);
                        SQLEditorPage.this._preferencePage.setValid(true);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    SQLEditorPage.this._preferencePage.setMessage(String.valueOf(((Text)e.widget).getText().trim()) + PreferenceMessages.General_invalid_int, 3);
                    SQLEditorPage.this._preferencePage.setValid(false);
                }
            }
        });
        this._promptDisableButton = SWTUtils.createCheckBox((Composite)syntaxValidationGroup, (String)PreferenceMessages.SQLEditor_showPromptDialog, (int)1, (int)20);
        this._showSyntaxErorrDetail = SWTUtils.createCheckBox((Composite)syntaxValidationGroup, (String)PreferenceMessages.SQLEditor_showSyntaxErorrDetail, (int)2, (int)5);
        this._showSyntaxErorrDetail.setToolTipText(PreferenceMessages.SQLEditor_showSyntaxErorrDetail_tooltip);
        Group executeSelectedSQLGroup = SWTUtils.createGroup((Composite)composite, (String)PreferenceMessages.SQLEditor_executeCurrentSQLGroup, (int)2);
        this._executeBetweenDelimiter = new Button((Composite)executeSelectedSQLGroup, 16);
        this._executeBetweenDelimiter.setText(PreferenceMessages.SQLEditor_executeSQLBetweenDelimiter);
        this._executeBetweenDelimiter.setToolTipText(PreferenceMessages.SQLEditor_executeSQLBetweenDelimiter_tip);
        this._executeBetweenDelimiter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPage.this._terminatorsCombo.setEnabled(SQLEditorPage.this._executeBetweenDelimiter.getSelection());
            }
        });
        this._terminatorsCombo = SWTUtils.createCombo((Composite)executeSelectedSQLGroup, (String[])new String[]{"go", ";", "/"}, (int)1);
        this._executeCurrentLine = new Button((Composite)executeSelectedSQLGroup, 16);
        this._executeCurrentLine.setText(PreferenceMessages.SQLEditor_executeCurrentLine);
        this._executeCurrentLine.setToolTipText(PreferenceMessages.SQLEditor_executeCurrentLine_tip);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this._executeCurrentLine.setLayoutData((Object)data);
        this._executeBetweenBlankLine = new Button((Composite)executeSelectedSQLGroup, 16);
        this._executeBetweenBlankLine.setText(PreferenceMessages.SQLEditor_executeSQLBetweenBlankLine);
        this._executeBetweenBlankLine.setToolTipText(PreferenceMessages.SQLEditor_executeSQLBetweenBlankLine_tip);
        data = new GridData(1808);
        data.horizontalSpan = 2;
        this._executeBetweenBlankLine.setLayoutData((Object)data);
        return composite;
    }

    private void createPortabilityCheckCombo(Composite parent) {
        Collection dbnames = SQLToolsFacade.getSupportedDBDefinitionNames();
        String[] names = dbnames.toArray(new String[dbnames.size()]);
        String[] nameValues = new String[names.length + 1];
        nameValues[0] = PreferenceMessages.GeneralPreferencePage_portable_target;
        int j = 0;
        int i = 0;
        while (i < names.length) {
            SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByDBDefName((String)names[i]);
            SQLParser pp = config.getSQLService().getSQLParser();
            if (pp != null && pp.isComplete()) {
                nameValues[j + 1] = names[i];
                ++j;
            }
            ++i;
        }
        String[] portNameValues = new String[j + 1];
        int i2 = 0;
        while (i2 < j + 1) {
            portNameValues[i2] = nameValues[i2];
            ++i2;
        }
        this._portabilityCheckLabel = new Label(parent, 0);
        this._portabilityCheckLabel.setText(PreferenceMessages.GeneralPreferencePage_portable_check);
        this._portabilityCheckCombo = new Combo(parent, 8);
        this._portabilityCheckCombo.setItems(portNameValues);
    }

    private void update() {
        boolean syntaxValidationEnabled = this._syntaxValidation.getSelection();
        this._portabilityCheckLabel.setEnabled(syntaxValidationEnabled);
        this._portabilityCheckCombo.setEnabled(syntaxValidationEnabled);
        this._maxLineButton.setEnabled(syntaxValidationEnabled);
        this._maxLineText.setEnabled(syntaxValidationEnabled);
        this._promptDisableButton.setEnabled(syntaxValidationEnabled);
        this._showSyntaxErorrDetail.setEnabled(syntaxValidationEnabled);
        this.updateMaxLineText();
    }

    private void updateMaxLineText() {
        if (this._syntaxValidation.getSelection()) {
            this._maxLineText.setEnabled(this._maxLineButton.getSelection());
            this._promptDisableButton.setEnabled(this._maxLineButton.getSelection());
        }
    }

    private void updateTerminatorsCombo() {
        this._terminatorsCombo.setEnabled(this._executeBetweenDelimiter.getSelection());
    }

    private Control createTypingPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Group typingAidsGroup = SWTUtils.createGroup((Composite)composite, (String)PreferenceMessages.SQLEditor_typingAidsGroup_title, (int)2);
        typingAidsGroup.setLayout((Layout)new GridLayout());
        typingAidsGroup.setLayoutData((Object)new GridData(1808));
        TableLayoutComposite layouter = new TableLayoutComposite((Composite)typingAidsGroup, 0);
        this.addColumnLayoutData(layouter);
        this._typingAidsTable = new Table((Composite)layouter, 68388);
        this._typingAidsTable.setHeaderVisible(true);
        this._typingAidsTable.setLinesVisible(true);
        GridData gd = new GridData(768);
        gd.heightHint = SWTUtils.getTableHeightHint((Table)this._typingAidsTable, (int)8);
        layouter.setLayoutData((Object)gd);
        this._typingAidsTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SQLEditorPage.this.handleTypingAidsListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TableColumn nameColumn = new TableColumn(this._typingAidsTable, 0);
        nameColumn.setText(PreferenceMessages.SQLEditor_typingAidsTable_columnName1);
        nameColumn.setResizable(true);
        nameColumn = new TableColumn(this._typingAidsTable, 0);
        nameColumn.setText(PreferenceMessages.SQLEditor_typingAidsTable_columnName2);
        nameColumn.setResizable(true);
        nameColumn.pack();
        nameColumn = new TableColumn(this._typingAidsTable, 0);
        nameColumn.setText(PreferenceMessages.SQLEditor_typingAidsTable_columnName3);
        nameColumn.setResizable(true);
        int i = 0;
        while (i < this._typingAidsName.length) {
            TableItem nameItem = new TableItem(this._typingAidsTable, 0);
            nameItem.setText(0, this._typingAidsName[i]);
            nameItem.setText(1, this._typingAidsContext[i]);
            nameItem.setText(2, this._typingAidsDescription[i]);
            ++i;
        }
        Label previewLabel = new Label((Composite)typingAidsGroup, 16384);
        previewLabel.setText(PreferenceMessages.SQLEditor_typingAids_preview);
        this._description = new Text((Composite)typingAidsGroup, 18506);
        gd = new GridData(768);
        gd.heightHint = 50;
        this._description.setLayoutData((Object)gd);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeValues() {
        this._syntaxValidation.setSelection(this._store.getBoolean("syntax.validation"));
        this._portabilityCheckCombo.setText(this._store.getString("PreferenceConstants.EDITOR_PORTABILITY_CHECK_TARGET"));
        this._maxLineButton.setSelection(this._store.getBoolean("syntax.validation.max.line"));
        this._maxLineText.setText(this._store.getString("syntax.validation.max.line.number"));
        this._promptDisableButton.setSelection(this._store.getBoolean("show.dailog.for.syntax.validation"));
        this._showSyntaxErorrDetail.setSelection(this._store.getBoolean("show.syntax.error.detail"));
        String executePolicy = this._store.getString("SQLEditor.executeSelectedSQL");
        this._executeBetweenDelimiter.setSelection(executePolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.betweenDelimiter"));
        this._executeCurrentLine.setSelection(executePolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.currentLine"));
        this._executeBetweenBlankLine.setSelection(executePolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.betweenBlankLine"));
        String term = this._store.getString("SQLEditor.executeSelectedSQL.betweenDelimiter.delimiterType");
        this.setTerminatorsCombo(term);
        this.updateTerminatorsCombo();
        int i = 0;
        while (i < this._typingAidsName.length) {
            this._typingAidsTable.getItems()[i].setChecked(this._store.getBoolean(this._typingAidsPreferences[i]));
            ++i;
        }
    }

    public boolean performOk() {
        this._store.setValue("syntax.validation", this._syntaxValidation.getSelection());
        this._store.setValue("PreferenceConstants.EDITOR_PORTABILITY_CHECK_TARGET", this._portabilityCheckCombo.getText());
        this._store.setValue("syntax.validation.max.line", this._maxLineButton.getSelection());
        this._store.setValue("syntax.validation.max.line.number", this._maxLineText.getText());
        this._store.setValue("show.dailog.for.syntax.validation", this._promptDisableButton.getSelection());
        this._store.setValue("show.syntax.error.detail", this._showSyntaxErorrDetail.getSelection());
        if (this._executeBetweenDelimiter.getSelection()) {
            this._store.setValue("SQLEditor.executeSelectedSQL", "SQLEditor.executeSelectedSQL.betweenDelimiter");
        } else if (this._executeCurrentLine.getSelection()) {
            this._store.setValue("SQLEditor.executeSelectedSQL", "SQLEditor.executeSelectedSQL.currentLine");
        } else {
            this._store.setValue("SQLEditor.executeSelectedSQL", "SQLEditor.executeSelectedSQL.betweenBlankLine");
        }
        this._store.setValue("SQLEditor.executeSelectedSQL.betweenDelimiter.delimiterType", this._terminatorsCombo.getItem(this._terminatorsCombo.getSelectionIndex()));
        int i = 0;
        while (i < this._typingAidsName.length) {
            this._store.setValue(this._typingAidsPreferences[i], this._typingAidsTable.getItems()[i].getChecked());
            ++i;
        }
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this._syntaxValidation.setSelection(this._store.getDefaultBoolean("syntax.validation"));
        this._portabilityCheckCombo.setText(this._store.getDefaultString("PreferenceConstants.EDITOR_PORTABILITY_CHECK_TARGET"));
        this._maxLineButton.setSelection(this._store.getDefaultBoolean("syntax.validation.max.line"));
        this.updateMaxLineText();
        this._maxLineText.setText(this._store.getDefaultString("syntax.validation.max.line.number"));
        this._promptDisableButton.setSelection(this._store.getDefaultBoolean("show.dailog.for.syntax.validation"));
        this._showSyntaxErorrDetail.setSelection(this._store.getDefaultBoolean("show.syntax.error.detail"));
        String executePolicy = this._store.getDefaultString("SQLEditor.executeSelectedSQL");
        this._executeBetweenDelimiter.setSelection(executePolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.betweenDelimiter"));
        this._executeCurrentLine.setSelection(executePolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.currentLine"));
        this._executeBetweenBlankLine.setSelection(executePolicy.equalsIgnoreCase("SQLEditor.executeSelectedSQL.betweenBlankLine"));
        String term = this._store.getDefaultString("SQLEditor.executeSelectedSQL.betweenDelimiter.delimiterType");
        this.setTerminatorsCombo(term);
        this.updateTerminatorsCombo();
        int i = 0;
        while (i < this._typingAidsName.length) {
            this._typingAidsTable.getItems()[i].setChecked(this._store.getDefaultBoolean(this._typingAidsPreferences[i]));
            ++i;
        }
        this.update();
    }

    private void setTerminatorsCombo(String term) {
        String[] items = this._terminatorsCombo.getItems();
        int match = 0;
        match = 0;
        while (match < items.length) {
            if (term.equalsIgnoreCase(items[match])) break;
            ++match;
        }
        if (match >= items.length) {
            match = 0;
        }
        this._terminatorsCombo.select(match);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return SQLEditorPlugin.getDefault().getPreferenceStore();
    }

    private void handleTypingAidsListSelection() {
        int i = this._typingAidsTable.getSelectionIndex();
        if (i == -1) {
            return;
        }
        this._description.setText(this._typingAidsPreview[i]);
    }

    private void addColumnLayoutData(TableLayoutComposite layouter) {
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(35, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(15, true));
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
    }
}

