/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalWrapper;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;

public class PKAlg<V>
implements IGraphObserver<V> {
    private Map<V, Integer> node2index;
    private Map<Integer, V> index2node;
    private Map<V, Boolean> node2mark;
    private Map<Integer, Integer> index2topsort;
    private Map<Integer, Integer> topsort2index;
    private int index;
    private int lower_bound;
    private int upper_bound;
    private List<V> RF;
    private List<V> RB;
    private IBiDirectionalGraphDataSource<V> gds;

    public PKAlg(IGraphDataSource<V> gds) {
        this.gds = gds instanceof IBiDirectionalGraphDataSource ? (IBiDirectionalGraphDataSource)gds : new IBiDirectionalWrapper<V>(gds);
        this.node2mark = new HashMap<V, Boolean>();
        this.node2index = new HashMap<V, Integer>();
        this.index2node = new HashMap<Integer, V>();
        this.index2topsort = new HashMap<Integer, Integer>();
        this.topsort2index = new HashMap<Integer, Integer>();
        this.index = 0;
        gds.attachObserver(this);
    }

    @Override
    public void edgeInserted(V source, V target) {
        this.RF = new ArrayList<V>();
        this.RB = new ArrayList<V>();
        this.lower_bound = this.index2topsort.get(this.node2index.get(target));
        this.upper_bound = this.index2topsort.get(this.node2index.get(source));
        if (this.lower_bound < this.upper_bound) {
            this.dfsForward(target);
            this.dfsBackward(source);
            this.reorder();
        }
    }

    private List<Integer> getIndicies(List<V> list) {
        ArrayList<Integer> indicies = new ArrayList<Integer>();
        for (V n : list) {
            indicies.add(this.index2topsort.get(this.node2index.get(n)));
        }
        return indicies;
    }

    private void reorder() {
        Collections.reverse(this.RB);
        List<Integer> L = this.getIndicies(this.RF);
        L.addAll(this.getIndicies(this.RB));
        Collections.sort(L);
        int i = 0;
        while (i < this.RB.size()) {
            this.index2topsort.put(this.node2index.get(this.RB.get(i)), L.get(i));
            this.topsort2index.put(L.get(i), this.node2index.get(this.RB.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.RF.size()) {
            this.index2topsort.put(this.node2index.get(this.RF.get(i)), L.get(i + this.RB.size()));
            this.topsort2index.put(L.get(i + this.RB.size()), this.node2index.get(this.RF.get(i)));
            ++i;
        }
    }

    private List<V> getTopSort() {
        ArrayList<V> topsort = new ArrayList<V>();
        for (int i : this.topsort2index.values()) {
            topsort.add(this.index2node.get(i));
        }
        return topsort;
    }

    private void dfsBackward(V node) {
        this.node2mark.put((Boolean)node, true);
        this.RB.add(node);
        for (Object sn : this.gds.getSourceNodes(node).distinctValues()) {
            int top_id = this.index2topsort.get(this.node2index.get(sn));
            if (this.node2mark.get(sn).booleanValue() || this.lower_bound >= top_id) continue;
            this.dfsBackward(sn);
        }
    }

    private void dfsForward(V node) {
        this.node2mark.put((Boolean)node, true);
        this.RF.add(node);
        for (Object tn : this.gds.getTargetNodes(node).distinctValues()) {
            int top_id = this.index2topsort.get(this.node2index.get(tn));
            if (top_id == this.upper_bound) {
                System.out.println("!!!Cycle detected!!!");
                continue;
            }
            if (this.node2mark.get(tn).booleanValue() || top_id >= this.upper_bound) continue;
            this.dfsForward(tn);
        }
    }

    @Override
    public void edgeDeleted(V source, V target) {
    }

    @Override
    public void nodeInserted(V n) {
        this.node2mark.put((Boolean)n, false);
        this.node2index.put((Integer)n, this.index);
        this.index2node.put(this.index, n);
        this.index2topsort.put(this.index, this.index);
        this.topsort2index.put(this.index, this.index);
        ++this.index;
    }

    @Override
    public void nodeDeleted(V n) {
        this.node2mark.remove(n);
        int node_id = this.node2index.remove(n);
        this.index2node.remove(node_id);
        int top_id = this.index2topsort.remove(node_id);
        this.topsort2index.remove(top_id);
    }
}

