/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ui.utils.PreferenceUtil;
import org.eclipse.datatools.sqltools.result.internal.ui.view.MultipleTabsGridSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.MultipleTabsTextSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowGridSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.SingleWindowTextSection;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;

public class ResultSectionFactory {
    private static final int MULTI_GRID = 1;
    private static final int MULTI_TEXT = 2;
    private static final int SINGLE_GRID = 3;
    private static final int SINGLE_TEXT = 4;

    public static ResultSection createResultSection(Composite comp, ResultsViewControl resultsViewControl) {
        int mode = ResultSectionFactory.getDisplayMode(resultsViewControl);
        ResultSection resultSection = null;
        switch (mode) {
            case 1: {
                resultSection = new MultipleTabsGridSection(comp, resultsViewControl);
                break;
            }
            case 2: {
                resultSection = new MultipleTabsTextSection(comp, resultsViewControl);
                break;
            }
            case 3: {
                resultSection = new SingleWindowGridSection(comp, resultsViewControl);
                break;
            }
            case 4: {
                resultSection = new SingleWindowTextSection(comp, resultsViewControl);
                break;
            }
        }
        return resultSection;
    }

    private static int getDisplayMode(ResultsViewControl resultsViewControl) {
        IPreferenceStore store = ResultsViewUIPlugin.getDefault().getPreferenceStore();
        int windows = PreferenceUtil.getInt(store, PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_WINDOW, resultsViewControl.getUsePreferences());
        int mode = PreferenceUtil.getInt(store, PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE, resultsViewControl.getUsePreferences());
        if (windows == 1 && mode == 1) {
            return 4;
        }
        if (windows == 1 && mode == 2) {
            return 3;
        }
        if (windows == 2 && mode == 1) {
            return 2;
        }
        if (windows == 2 && mode == 2) {
            return 1;
        }
        return 1;
    }
}

