/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Locale;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;

class HeapObjectsTracker {
    long actual;
    int totalWork;
    int workPrev;
    int workDone;
    int j;
    long t;
    int k;
    int n;
    long est;

    public HeapObjectsTracker(IHeapObjectArgument objects) {
        if (objects.getLabel().toUpperCase(Locale.ENGLISH).contains("SELECT ")) {
            this.totalWork = 1000000;
            this.actual = -1L;
        } else {
            long total = 0L;
            for (int[] objectIds : objects) {
                total += (long)(objectIds.length + 1);
            }
            this.actual = total;
            this.totalWork = total < 1000000L ? (int)total : 1000000;
        }
    }

    public int totalWork() {
        return this.totalWork;
    }

    public void beginBlock(int[] objectIds, boolean last) {
        this.t += (long)this.n;
        this.n = objectIds.length + 1;
        ++this.j;
        this.k = 0;
        this.workPrev = this.workDone;
        this.est = this.actual >= 0L ? this.actual - this.t : (last ? (long)this.n : (this.t + (long)this.n) * (long)(this.j + 2) / (long)this.j);
    }

    public int work() {
        ++this.k;
        int work = (int)((long)this.k * (long)(this.totalWork - this.workPrev) / this.est) + this.workPrev;
        int delta = work - this.workDone;
        this.workDone = work;
        return delta;
    }

    public int endBlock() {
        int delta;
        if (this.k < this.n) {
            int work = (int)((long)this.n * (long)(this.totalWork - this.workPrev) / this.est) + this.workPrev;
            delta = work - this.workDone;
            this.workDone = work;
        } else {
            delta = 0;
        }
        this.t += (long)this.n;
        this.n = 0;
        return delta;
    }
}

