/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.wizards;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;

public class NewVqlFileWizardContainerConfigurationPage
extends NewTypeWizardPage {
    private Text fileText;
    private static final String TITLE = "VIATRA Query Definition Wizard";
    private static final String THE_GIVEN_FILE_ALREADY_EXISTS = "The given file already exists!";
    private static final String defaultEiqFileName = "";
    private static final String SOURCE_FOLDER_ERROR = "You must specify a valid source folder!";
    private static final String FILE_NAME_ERROR = "File name must be specified!";
    private static final String FILE_NAME_NOT_VALID = "File name must be valid!";
    private static final String FILE_EXTENSION_ERROR = "File extension must be \"vql\"!";
    private static final String DEFAULT_PACKAGE_ERROR = "A non-empty Java package must be specified!";
    private static final String PACKAGE_NAME_WARNING = "Only lower case Java package names supported.";

    public NewVqlFileWizardContainerConfigurationPage() {
        super(false, "vql");
        this.setTitle(TITLE);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jElement = this.getInitialJavaElement(selection);
        this.initContainerPage(jElement);
        if (jElement != null) {
            IPackageFragment pack = (IPackageFragment)jElement.getAncestor(4);
            this.setPackageFragment(pack, true);
        }
        this.packageChanged();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        Label label = new Label(composite, 0);
        label.setText("&File name:");
        this.fileText = new Text(composite, 2052);
        this.fileText.setText(defaultEiqFileName);
        GridData gd_1 = new GridData(768);
        gd_1.horizontalSpan = 3;
        this.fileText.setLayoutData((Object)gd_1);
        this.fileText.addModifyListener(e -> this.validatePage());
        this.setControl((Control)composite);
        this.validatePage();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.validatePage();
    }

    private void validatePage() {
        IStatus packageStatus = this.validatePackageName(this.getPackageText());
        StatusInfo si = new StatusInfo(packageStatus.getSeverity(), packageStatus.getMessage());
        String containerPath = this.getPackageFragmentRootText();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource containerResource = root.findMember((IPath)new Path(containerPath));
        if (containerPath.matches(defaultEiqFileName) || containerResource == null) {
            si.setError(SOURCE_FOLDER_ERROR);
        }
        if (this.fileText != null) {
            String fileName = this.fileText.getText();
            String packageName = this.getPackageText().replaceAll("\\.", "/");
            if (root.findMember((IPath)new Path(containerPath + "/" + packageName + "/" + this.fileText.getText())) != null) {
                si.setError(THE_GIVEN_FILE_ALREADY_EXISTS);
            }
            if (fileName.length() == 0) {
                si.setError(FILE_NAME_ERROR);
            }
            if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
                si.setError(FILE_NAME_NOT_VALID);
            }
            boolean wrongExtension = false;
            if (!fileName.contains(".")) {
                wrongExtension = true;
            } else {
                int dotLoc = fileName.lastIndexOf(46);
                String ext = fileName.substring(dotLoc + 1);
                wrongExtension = !ext.equalsIgnoreCase("vql");
                String name = fileName.substring(0, dotLoc);
                IStatus nameValidatorStatus = JavaConventions.validateTypeVariableName((String)name, (String)"1.7", (String)"1.7");
                if (nameValidatorStatus.getSeverity() == 4) {
                    si.setError(String.format("Filename %s is not a valid Java type name.", name));
                }
            }
            if (wrongExtension) {
                si.setError(FILE_EXTENSION_ERROR);
            }
        }
        if (si.getSeverity() == 0) {
            si.setInfo(defaultEiqFileName);
        }
        if (si.isError()) {
            this.setErrorMessage(si.getMessage());
        }
        this.updateStatus((IStatus)si);
    }

    private IStatus validatePackageName(String text) {
        if (text == null || text.isEmpty()) {
            return new Status(4, "org.eclipse.viatra.query.patternlanguage.emf.ui", DEFAULT_PACKAGE_ERROR);
        }
        IJavaProject project = this.getJavaProject();
        if (project == null || !project.exists()) {
            return JavaConventions.validatePackageName((String)text, (String)"1.7", (String)"1.7");
        }
        IStatus status = JavaConventionsUtil.validatePackageName((String)text, (IJavaElement)project);
        if (!Objects.equals(text, text.toLowerCase())) {
            return new Status(4, "org.eclipse.viatra.query.patternlanguage.emf.ui", PACKAGE_NAME_WARNING);
        }
        return status;
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getContainerName() {
        return this.getPackageFragmentRootText();
    }

    public String getPackageName() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        IPackageFragment fragment = root.getPackageFragment(this.getPackageText());
        if (!fragment.exists()) {
            try {
                root.createPackageFragment(this.getPackageText(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                EMFPatternLanguageUIPlugin.getInstance().logException("Cannot load packages " + e.getMessage(), e);
            }
        }
        return this.getPackageText();
    }

    public IProject getProject() {
        return this.getPackageFragmentRoot().getJavaProject().getProject();
    }
}

