/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Stack;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AssociationNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.OppositePropertyNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.RefImmediateCompositeNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;

public class PropertyCallExpTracer
extends AbstractTracer<PropertyCallExp> {
    public PropertyCallExpTracer(PropertyCallExp expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        super(expression, tuplePartNames, oclFactory);
    }

    @Override
    public NavigationStep traceback(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        NavigationStep result;
        EStructuralFeature refProp = (EStructuralFeature)((PropertyCallExp)this.getExpression()).getReferredProperty();
        if (refProp instanceof EReference) {
            result = this.handleAssociationCall(context, pathCache, operationBodyToCallMapper);
        } else if (refProp instanceof EAttribute) {
            result = this.handleAttributeCall(context, pathCache, operationBodyToCallMapper);
        } else {
            throw new RuntimeException("Unhandled subclass of EStructuralFeature. Revisit PropertyCallExpTracer to implement specific behaviour.");
        }
        this.applyScopesOnNavigationStep(result, operationBodyToCallMapper);
        return result;
    }

    private NavigationStep handleAssociationCall(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        OCLExpression sourceExp = (OCLExpression)((PropertyCallExp)this.getExpression()).getSource();
        EClassifier sourceType = (EClassifier)sourceExp.getType();
        if (sourceType instanceof TupleType) {
            return this.getNavigationStepForTuplePartAccess(context, pathCache, operationBodyToCallMapper, sourceExp);
        }
        NavigationStep sourceStep = (NavigationStep)pathCache.getOrCreateNavigationPath(sourceExp, context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
        EReference forwardRef = (EReference)((PropertyCallExp)this.getExpression()).getReferredProperty();
        AbstractNavigationStep reverseTraversal = forwardRef.getEOpposite() != null ? new AssociationNavigationStep(this.getInnermostElementType((EClassifier)((PropertyCallExp)this.getExpression()).getType()), this.getInnermostElementType(sourceType), forwardRef.getEOpposite(), (OCLExpression)this.getExpression()) : (forwardRef.isContainment() ? new RefImmediateCompositeNavigationStep(this.getInnermostElementType((EClassifier)((PropertyCallExp)this.getExpression()).getType()), this.getInnermostElementType(sourceType), (OCLExpression)this.getExpression()) : new OppositePropertyNavigationStep(forwardRef.getEReferenceType(), (EClass)((PropertyCallExp)this.getExpression()).getSource().getType(), (EStructuralFeature)forwardRef, (OCLExpression)this.getExpression(), pathCache.getOppositeEndFinder()));
        return pathCache.navigationStepFromSequence((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), reverseTraversal, sourceStep);
    }

    private NavigationStep getNavigationStepForTuplePartAccess(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper, OCLExpression sourceExp) {
        String referredAttributeName = ((EStructuralFeature)((PropertyCallExp)this.getExpression()).getReferredProperty()).getName();
        return (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((PropertyCallExp)this.getExpression()).getSource(), context, operationBodyToCallMapper, this.getExtendedListOfTuplePartNames(referredAttributeName), this.oclFactory);
    }

    private NavigationStep handleAttributeCall(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        OCLExpression sourceExp = (OCLExpression)((PropertyCallExp)this.getExpression()).getSource();
        EClassifier sourceType = (EClassifier)sourceExp.getType();
        if (sourceType instanceof TupleType) {
            return this.getNavigationStepForTuplePartAccess(context, pathCache, operationBodyToCallMapper, sourceExp);
        }
        return pathCache.navigationStepFromSequence((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), new RefImmediateCompositeNavigationStep((EClass)((PropertyCallExp)this.getExpression()).getType(), (EClass)sourceType, (OCLExpression)this.getExpression()), (NavigationStep)pathCache.getOrCreateNavigationPath(sourceExp, context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory));
    }
}

