/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.iterators;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroupIterator;

public abstract class AbstractStepGroupIterator
extends ExecutableExtension
implements IStepGroupIterator {
    private int iteration = -1;
    private int iterations = -1;

    @Override
    public void initialize(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        this.iteration = 0;
    }

    @Override
    public final boolean hasNext(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        return this.iteration < this.iterations;
    }

    protected final void setIterations(int iterations) throws CoreException {
        if (this.iteration > 0) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "cannot change iterations during run"));
        }
        this.iterations = iterations;
    }

    protected final int getIteration() {
        return this.iteration;
    }

    @Override
    public final void next(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        if (this.iterations < 0 || this.iteration < 0) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "iterator not initialized"));
        }
        if (this.iteration >= this.iterations) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "no more iterations"));
        }
        this.internalNext(context, data, fullQualifiedId, monitor);
        ++this.iteration;
    }

    public abstract void internalNext(IStepContext var1, IPropertiesContainer var2, IFullQualifiedId var3, IProgressMonitor var4) throws CoreException;

    protected void setActiveContext(Object activeContext, IPropertiesContainer data, IFullQualifiedId fullQualifiedId) {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        StepperAttributeUtil.setProperty("org.eclipse.tcf.te.runtime.stepper.active_context", fullQualifiedId, data, activeContext);
    }

    protected Object getActiveContext(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId) {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Object activeContext = StepperAttributeUtil.getProperty("org.eclipse.tcf.te.runtime.stepper.active_context", fullQualifiedId, data);
        if (activeContext == null) {
            activeContext = context.getContextObject();
        }
        return activeContext;
    }
}

