/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteColorProvider;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.palette.DesignerContainer;
import org.eclipse.wb.core.controls.palette.DesignerEntry;
import org.eclipse.wb.core.controls.palette.DesignerPaletteViewerPreferences;
import org.eclipse.wb.core.controls.palette.DesignerRoot;
import org.eclipse.wb.core.controls.palette.DesignerSubPalette;
import org.eclipse.wb.core.controls.palette.ICategory;
import org.eclipse.wb.core.controls.palette.IEntry;
import org.eclipse.wb.core.controls.palette.PaletteComposite;
import org.eclipse.wb.core.editor.palette.PaletteEventListener;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.IPaletteSite;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ToolEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.tools.SelectionTool;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.palette.DesignerColorProvider;
import org.eclipse.wb.internal.core.editor.palette.DesignerPaletteEditDomain;
import org.eclipse.wb.internal.core.editor.palette.DesignerPaletteEditPartFactory;
import org.eclipse.wb.internal.core.editor.palette.DesignerPalettePopupActions;
import org.eclipse.wb.internal.core.editor.palette.ISubPaletteInfo;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.PluginPalettePreferences;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryMoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryRemoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.EntryMoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.EntryRemoveCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.AbstractPaletteElementDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.CategoryAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.CategoryEditDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ComponentAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ComponentEditDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ImportArchiveDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.PaletteManagerDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.PalettePreferencesDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoriesAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoryAddDialog;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoryEditDialog;
import org.eclipse.wb.internal.core.editor.palette.model.entry.IDefaultEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.InstanceFactoryEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.model.entry.StaticFactoryEntryInfo;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;

public class DesignerPalette {
    public static final String FLAG_NO_PALETTE = "FLAG_NO_PALETTE";
    private final String ENTRYINFO_CATEGORY = "org.eclipse.wb.swing.layouts";
    private final boolean m_isMainPalette;
    private final PluginPalettePreferences m_preferences;
    private final PaletteComposite m_legacyPaletteComposite;
    private final DesignerPaletteOperations m_operations;
    private final PaletteViewer m_paletteViewer;
    private final FigureCanvas m_paletteComposite;
    private final DesignerPaletteEditDomain m_paletteDomain;
    private IEditPartViewer m_editPartViewer;
    private JavaInfo m_rootJavaInfo;
    private PaletteManager m_manager;
    private PaletteEntry m_defaultEntry;
    private DesignerRoot m_paletteRoot;
    private Font m_categoryFont = null;
    private Font m_entryFont = null;
    private final IPaletteSite m_paletteSite = new IPaletteSite(){

        @Override
        public Shell getShell() {
            return DesignerPalette.this.getOperations().getShell();
        }

        @Override
        public PaletteInfo getPalette() {
            return DesignerPalette.this.m_manager.getPalette();
        }

        @Override
        public void addCommand(Command command) {
            DesignerPalette.this.commands_addWrite(command);
        }

        @Override
        public void editPalette() {
            DesignerPalette.this.getOperations().editPalette();
        }
    };
    private final Map<CategoryInfo, DesignerContainer> m_categoryInfoToVisual = new HashMap<CategoryInfo, DesignerContainer>();
    private final Map<DesignerContainer, CategoryInfo> m_visualToCategoryInfo = new HashMap<DesignerContainer, CategoryInfo>();
    private final Map<String, Boolean> m_openCategories = new HashMap<String, Boolean>();
    private final Set<EntryInfo> m_knownEntryInfos = new HashSet<EntryInfo>();
    private final Set<EntryInfo> m_goodEntryInfos = new HashSet<EntryInfo>();
    private final Map<EntryInfo, PaletteEntry> m_entryInfoToVisual = new HashMap<EntryInfo, PaletteEntry>();
    private final Map<PaletteEntry, EntryInfo> m_visualToEntryInfo = new HashMap<PaletteEntry, EntryInfo>();

    public DesignerPalette(Composite parent, int style, boolean isMainPalette) {
        this.m_isMainPalette = isMainPalette;
        this.m_operations = new DesignerPaletteOperations();
        this.m_preferences = new PluginPalettePreferences();
        if (EnvironmentUtils.isGefPalette()) {
            this.m_legacyPaletteComposite = null;
            this.m_paletteDomain = new DesignerPaletteEditDomain();
            this.m_paletteViewer = new PaletteViewer();
            this.m_paletteViewer.enableVerticalScrollbar(true);
            this.m_paletteViewer.setEditDomain((EditDomain)this.m_paletteDomain);
            this.m_paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)this.m_preferences);
            this.m_paletteViewer.setContextMenu((MenuManager)new PaletteContextMenuProvider(this.m_paletteViewer));
            this.m_paletteViewer.setColorProvider((PaletteColorProvider)new DesignerColorProvider());
            this.m_paletteViewer.setEditPartFactory((EditPartFactory)new DesignerPaletteEditPartFactory());
            this.m_paletteComposite = (FigureCanvas)this.m_paletteViewer.createControl(parent);
            this.m_paletteComposite.setScrollbarsMode(0);
            this.m_paletteComposite.addDisposeListener(event -> {
                if (this.m_categoryFont != null) {
                    this.m_categoryFont.dispose();
                }
                if (this.m_entryFont != null) {
                    this.m_entryFont.dispose();
                }
            });
            this.m_preferences.addPropertyChangeListener(event -> {
                String key = event.getPropertyName();
                if (this.m_preferences.isCategoryPropertyKey(key) || this.m_preferences.isEntryPropertyKey(key)) {
                    this.updateFonts(event.getPropertyName());
                    this.m_paletteViewer.getRootEditPart().refresh();
                }
            });
        } else {
            this.m_legacyPaletteComposite = new PaletteComposite(parent, 0);
            this.m_paletteDomain = null;
            this.m_paletteViewer = null;
            this.m_paletteComposite = null;
        }
    }

    public Control getControl() {
        return this.m_legacyPaletteComposite != null ? this.m_legacyPaletteComposite : this.m_paletteComposite;
    }

    public void setInput(IEditPartViewer editPartViewer, final JavaInfo rootJavaInfo, String toolkitId) {
        this.m_editPartViewer = editPartViewer;
        this.m_rootJavaInfo = rootJavaInfo;
        if (this.m_legacyPaletteComposite == null) {
            editPartViewer.getEditDomain().setPaletteViewer(this.m_paletteViewer);
        }
        if (this.m_rootJavaInfo != null) {
            IJobManager manager = Job.getJobManager();
            manager.cancel((Object)"palette pre-load");
            try {
                manager.join((Object)"palette pre-load", null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_manager = new PaletteManager(this.m_rootJavaInfo, toolkitId);
            this.reloadPalette();
            this.m_preferences.setPrefix(toolkitId);
            if (this.m_legacyPaletteComposite == null) {
                Display display = this.m_paletteComposite.getDisplay();
                if (this.m_categoryFont != null) {
                    this.m_categoryFont.dispose();
                }
                if (this.m_entryFont != null) {
                    this.m_entryFont.dispose();
                }
                this.m_categoryFont = this.m_preferences.getCategoryFontDescriptor().createFont((Device)display);
                this.m_entryFont = this.m_preferences.getEntryFontDescriptor().createFont((Device)display);
                this.updateFonts((String)null);
            } else {
                this.m_legacyPaletteComposite.setPreferences((DesignerPaletteViewerPreferences)this.m_preferences);
            }
            IPaletteSite.Helper.setSite(this.m_rootJavaInfo, this.m_paletteSite);
            rootJavaInfo.addBroadcastListener(new ObjectEventListener(){

                public void refreshed() throws Exception {
                    if (DesignerPalette.this.m_legacyPaletteComposite != null && DesignerPalette.this.m_legacyPaletteComposite.isDisposed()) {
                        rootJavaInfo.removeBroadcastListener((Object)this);
                        return;
                    }
                    if (DesignerPalette.this.m_paletteComposite != null && DesignerPalette.this.m_paletteComposite.isDisposed()) {
                        rootJavaInfo.removeBroadcastListener((Object)this);
                        return;
                    }
                    DesignerPalette.this.refreshVisualPalette();
                }
            });
        }
    }

    private PaletteEventListener getBroadcastPalette() {
        return (PaletteEventListener)this.m_rootJavaInfo.getBroadcast(PaletteEventListener.class);
    }

    private void reloadPalette() {
        this.m_manager.reloadPalette();
        this.showPalette();
    }

    private void commands_addWrite(Command command) {
        this.commands_addWrite(List.of(command));
    }

    private void commands_addWrite(List<Command> commands) {
        for (Command command : commands) {
            this.m_manager.commands_add(command);
        }
        this.m_manager.commands_write();
        this.refreshVisualPalette();
    }

    private void clearEntryCaches() {
        this.m_categoryInfoToVisual.clear();
        this.m_visualToCategoryInfo.clear();
        this.m_knownEntryInfos.clear();
        this.m_goodEntryInfos.clear();
        this.m_entryInfoToVisual.clear();
        this.m_visualToEntryInfo.clear();
        this.m_defaultEntry = null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private PaletteEntry getVisualEntry(final EntryInfo entryInfo) {
        block4: {
            entry /* !! */  = this.m_entryInfoToVisual.get(entryInfo);
            if (entry /* !! */  != null || this.m_knownEntryInfos.contains(entryInfo)) break block4;
            this.m_knownEntryInfos.add(entryInfo);
            if (!entryInfo.initialize(this.m_editPartViewer, this.m_rootJavaInfo)) break block4;
            if (!(entryInfo instanceof ISubPaletteInfo)) ** GOTO lbl-1000
            stackInfo = (ISubPaletteInfo)entryInfo;
            if (EnvironmentUtils.isGefPalette()) {
                entry /* !! */  = new DesignerSubPalette(entryInfo.getName(), entryInfo.getDescription(), entryInfo.getIcon());
                ((PaletteDrawer)entry /* !! */ ).setInitialState(1);
                for (CategoryInfo categoryInfo : stackInfo.getSubCategories()) {
                    ((PaletteDrawer)entry /* !! */ ).add((PaletteEntry)this.getVisualCategory(categoryInfo));
                }
            } else lbl-1000:
            // 2 sources

            {
                entry /* !! */  = new DesignerEntry(entryInfo.getName(), entryInfo.getDescription(), entryInfo.getIcon()){

                    public boolean isEnabled() {
                        return entryInfo.isEnabled();
                    }

                    public boolean activate(boolean reload) {
                        return entryInfo.createTool(reload) != null;
                    }

                    public org.eclipse.wb.gef.core.tools.Tool createTool() {
                        if (DesignerPalette.this.m_paletteDomain == null) {
                            return entryInfo.createTool(false);
                        }
                        return entryInfo.createTool(DesignerPalette.this.m_paletteDomain.isReload());
                    }
                };
            }
            this.m_goodEntryInfos.add(entryInfo);
            this.m_entryInfoToVisual.put(entryInfo, entry /* !! */ );
            this.m_visualToEntryInfo.put(entry /* !! */ , entryInfo);
            if (this.m_defaultEntry == null && entryInfo instanceof IDefaultEntryInfo) {
                this.m_defaultEntry = entry /* !! */ ;
            }
        }
        return entry /* !! */ ;
    }

    private DesignerContainer getVisualCategory(final CategoryInfo categoryInfo) {
        DesignerContainer category = this.m_categoryInfoToVisual.get(categoryInfo);
        if (category == null) {
            final String categoryId = categoryInfo.getId();
            category = new DesignerContainer(categoryInfo.getName(), categoryInfo.getDescription()){
                private boolean m_open;

                public List<PaletteEntry> getChildren() {
                    ArrayList<EntryInfo> entryInfoList = new ArrayList<EntryInfo>(categoryInfo.getEntries());
                    ExecutionUtils.runIgnore(() -> DesignerPalette.this.getBroadcastPalette().entries(categoryInfo, entryInfoList));
                    ArrayList<PaletteEntry> entries = new ArrayList<PaletteEntry>();
                    for (EntryInfo entryInfo : entryInfoList) {
                        PaletteEntry entry;
                        if (!entryInfo.isVisible()) continue;
                        if (categoryId.equals("org.eclipse.wb.swing.layouts")) {
                            if (!InstanceScope.INSTANCE.getNode("layout.available").getBoolean(entryInfo.getId().substring(entryInfo.getId().indexOf(32) + 1), true) || (entry = DesignerPalette.this.getVisualEntry(entryInfo)) == null) continue;
                            entries.add(entry);
                            continue;
                        }
                        entry = DesignerPalette.this.getVisualEntry(entryInfo);
                        if (entry == null) continue;
                        entries.add(entry);
                    }
                    return entries;
                }

                public boolean isOpen() {
                    return this.m_open;
                }

                public void setOpen(boolean open) {
                    this.m_open = open;
                    DesignerPalette.this.m_openCategories.put(categoryId, open);
                }
            };
            this.m_categoryInfoToVisual.put(categoryInfo, category);
            this.m_visualToCategoryInfo.put(category, categoryInfo);
            if (this.m_openCategories.containsKey(categoryId)) {
                category.setOpen(this.m_openCategories.get(categoryId).booleanValue());
            } else {
                category.setOpen(categoryInfo.isOpen());
            }
        }
        return category;
    }

    private void showPalette() {
        this.clearEntryCaches();
        this.m_paletteRoot = new DesignerRoot(){

            public void addPopupActions(IMenuManager menuManager, Object target, int iconsType) {
                new DesignerPalettePopupActions(DesignerPalette.this.getOperations()).addPopupActions(menuManager, target, iconsType);
            }

            public void selectDefault() {
                DesignerPalette.this.m_editPartViewer.getEditDomain().loadDefaultTool();
            }

            public void moveCategory(ICategory _category, ICategory _nextCategory) {
                CategoryInfo category = DesignerPalette.this.m_visualToCategoryInfo.get(_category);
                CategoryInfo nextCategory = DesignerPalette.this.m_visualToCategoryInfo.get(_nextCategory);
                DesignerPalette.this.commands_addWrite(new CategoryMoveCommand(category, nextCategory));
            }

            public void moveEntry(IEntry _entry, ICategory _targetCategory, IEntry _nextEntry) {
                EntryInfo entry = DesignerPalette.this.m_visualToEntryInfo.get(_entry);
                CategoryInfo category = DesignerPalette.this.m_visualToCategoryInfo.get(_targetCategory);
                EntryInfo nextEntry = DesignerPalette.this.m_visualToEntryInfo.get(_nextEntry);
                DesignerPalette.this.commands_addWrite(new EntryMoveCommand(entry, category, nextEntry));
            }
        };
        if (System.getProperty(FLAG_NO_PALETTE) == null) {
            List<CategoryInfo> pristineCategories = this.m_manager.getPalette().getCategories();
            ArrayList<CategoryInfo> categoryInfoList = new ArrayList<CategoryInfo>(pristineCategories);
            ExecutionUtils.runLog(() -> {
                this.getBroadcastPalette().categories(categoryInfoList);
                this.getBroadcastPalette().categories2(categoryInfoList);
            });
            for (CategoryInfo categoryInfo : categoryInfoList) {
                if (!this.shouldBeDisplayed(categoryInfo)) continue;
                DesignerContainer category = this.getVisualCategory(categoryInfo);
                this.m_paletteRoot.add((PaletteEntry)category);
            }
        }
        if (this.m_legacyPaletteComposite != null) {
            this.m_legacyPaletteComposite.setPalette(this.m_paletteRoot);
        } else {
            this.m_paletteViewer.setPaletteRoot((PaletteRoot)this.m_paletteRoot);
        }
        this.configure_EditDomain_DefaultTool();
    }

    private DesignerPaletteOperations getOperations() {
        return this.m_operations;
    }

    private boolean shouldBeDisplayed(CategoryInfo category) {
        if (!category.isVisible()) {
            return false;
        }
        if (category.isOptional()) {
            return !this.getVisualCategory(category).getEntries().isEmpty();
        }
        return true;
    }

    private void configure_EditDomain_DefaultTool() {
        if (this.m_isMainPalette) {
            org.eclipse.wb.internal.gef.core.EditDomain editDomain = this.m_editPartViewer.getEditDomain();
            editDomain.setDefaultToolProvider(() -> {
                PaletteEntry paletteEntry = this.m_defaultEntry;
                if (paletteEntry instanceof DesignerEntry) {
                    DesignerEntry defaultEntry = (DesignerEntry)paletteEntry;
                    if (this.m_legacyPaletteComposite != null) {
                        this.m_legacyPaletteComposite.selectEntry(defaultEntry, false);
                    } else {
                        this.m_paletteViewer.setActiveTool((ToolEntry)defaultEntry);
                    }
                } else {
                    editDomain.setActiveTool((Tool)new SelectionTool());
                }
            });
            editDomain.loadDefaultTool();
        }
    }

    private void refreshVisualPalette() {
        if (this.m_legacyPaletteComposite != null) {
            this.m_legacyPaletteComposite.refreshPalette();
        }
    }

    private void updateFonts(String propertyName) {
        Display display = this.m_paletteComposite.getDisplay();
        if (this.m_preferences.isCategoryPropertyKey(propertyName)) {
            if (this.m_categoryFont != null) {
                this.m_categoryFont.dispose();
            }
            this.m_categoryFont = this.m_preferences.getCategoryFontDescriptor().createFont((Device)display);
        } else if (this.m_preferences.isEntryPropertyKey(propertyName)) {
            if (this.m_entryFont != null) {
                this.m_entryFont.dispose();
            }
            this.m_entryFont = this.m_preferences.getEntryFontDescriptor().createFont((Device)display);
        }
        this.updateFonts((PaletteEditPart)this.m_paletteViewer.getEditPartForModel((Object)this.m_paletteRoot));
        this.m_paletteComposite.getViewport().invalidateTree();
        this.m_paletteComposite.getViewport().revalidate();
        this.m_paletteComposite.redraw();
        this.m_paletteViewer.getRootEditPart().refresh();
    }

    private void updateFonts(PaletteEditPart editPart) {
        if (editPart.getModel() instanceof ToolEntry) {
            editPart.getFigure().setFont(this.m_entryFont);
        } else if (editPart.getModel() instanceof PaletteDrawer) {
            editPart.getFigure().setFont(this.m_categoryFont);
        }
        for (PaletteEditPart childEditPart : editPart.getChildren()) {
            this.updateFonts(childEditPart);
        }
    }

    final class DesignerPaletteOperations {
        DesignerPaletteOperations() {
        }

        public boolean canEditPalette() {
            boolean[] canEdit = new boolean[]{true};
            DesignerPalette.this.getBroadcastPalette().canEdit(canEdit);
            return canEdit[0];
        }

        public void editPalette() {
            PaletteManagerDialog dialog = new PaletteManagerDialog(DesignerPalette.this.m_rootJavaInfo.getEditor(), DesignerPalette.this.m_manager.getPalette(), DesignerPalette.this.m_goodEntryInfos);
            DesignerPalette.this.reloadPalette();
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommands());
            }
        }

        public void defaultPalette() {
            DesignerPalette.this.m_manager.commands_clear();
            DesignerPalette.this.m_manager.commands_write();
            DesignerPalette.this.m_openCategories.clear();
            DesignerPalette.this.reloadPalette();
        }

        public void editPreferences() {
            PalettePreferencesDialog dialog = new PalettePreferencesDialog(this.getShell(), DesignerPalette.this.m_preferences);
            if (dialog.open() == 0) {
                dialog.commit();
                if (DesignerPalette.this.m_legacyPaletteComposite != null) {
                    DesignerPalette.this.m_legacyPaletteComposite.setPreferences((DesignerPaletteViewerPreferences)DesignerPalette.this.m_preferences);
                }
            }
        }

        public void setIconsType(int iconsType) {
            DesignerPalette.this.m_preferences.setLayoutSetting(iconsType);
            if (DesignerPalette.this.m_legacyPaletteComposite != null) {
                DesignerPalette.this.m_legacyPaletteComposite.setLayoutType(iconsType);
                DesignerPalette.this.m_legacyPaletteComposite.setPreferences((DesignerPaletteViewerPreferences)DesignerPalette.this.m_preferences);
                DesignerPalette.this.m_legacyPaletteComposite.refreshComposite();
            }
        }

        public EntryInfo getEntry(Object target) {
            return DesignerPalette.this.m_visualToEntryInfo.get(target);
        }

        public CategoryInfo getCategory(Object target) {
            return DesignerPalette.this.m_visualToCategoryInfo.get(target);
        }

        public void addComponent(CategoryInfo category) {
            ComponentAddDialog dialog = new ComponentAddDialog(this.getShell(), DesignerPalette.this.m_rootJavaInfo.getEditor(), DesignerPalette.this.m_manager.getPalette(), category);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void addFactory(CategoryInfo category, boolean forStatic) {
            FactoryAddDialog dialog = new FactoryAddDialog(this.getShell(), DesignerPalette.this.m_rootJavaInfo.getEditor(), forStatic, DesignerPalette.this.m_manager.getPalette(), category);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void addFactories(CategoryInfo category, boolean forStatic) {
            FactoriesAddDialog dialog = new FactoriesAddDialog(this.getShell(), DesignerPalette.this.m_rootJavaInfo.getEditor(), DesignerPalette.this.m_manager.getPalette(), category, forStatic);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommands());
            }
        }

        public void editEntry(ToolEntryInfo targetEntry) {
            AbstractPaletteElementDialog dialog = null;
            AstEditor editor = DesignerPalette.this.m_rootJavaInfo.getEditor();
            if (targetEntry instanceof ComponentEntryInfo) {
                ComponentEntryInfo entryInfo = (ComponentEntryInfo)targetEntry;
                dialog = new ComponentEditDialog(this.getShell(), editor, entryInfo);
            } else if (targetEntry instanceof StaticFactoryEntryInfo) {
                StaticFactoryEntryInfo entryInfo = (StaticFactoryEntryInfo)targetEntry;
                dialog = new FactoryEditDialog(this.getShell(), editor, true, entryInfo);
            } else if (targetEntry instanceof InstanceFactoryEntryInfo) {
                InstanceFactoryEntryInfo entryInfo = (InstanceFactoryEntryInfo)targetEntry;
                dialog = new FactoryEditDialog(this.getShell(), editor, false, entryInfo);
            }
            if (dialog != null && dialog.open() == 0) {
                DesignerPalette.this.m_entryInfoToVisual.remove(targetEntry);
                DesignerPalette.this.m_knownEntryInfos.remove(targetEntry);
                DesignerPalette.this.m_goodEntryInfos.remove(targetEntry);
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void removeEntry(EntryInfo targetEntry) {
            DesignerPalette.this.commands_addWrite(new EntryRemoveCommand(targetEntry));
        }

        public void addCategory(CategoryInfo nextCategory) {
            CategoryAddDialog dialog = new CategoryAddDialog(this.getShell(), DesignerPalette.this.m_manager.getPalette(), nextCategory);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void editCategory(CategoryInfo targetCategory) {
            CategoryEditDialog dialog = new CategoryEditDialog(this.getShell(), targetCategory);
            if (dialog.open() == 0) {
                DesignerPalette.this.commands_addWrite(dialog.getCommand());
            }
        }

        public void removeCategory(CategoryInfo targetCategory) {
            DesignerPalette.this.commands_addWrite(new CategoryRemoveCommand(targetCategory));
        }

        public void importJar(CategoryInfo nextCategory) {
            ImportArchiveDialog dialog = new ImportArchiveDialog(this.getShell(), DesignerPalette.this.m_manager.getPalette(), nextCategory);
            if (dialog.open() == 0) {
                for (Command command : dialog.getCommands()) {
                    DesignerPalette.this.commands_addWrite(command);
                }
            }
        }

        public void importPalette(String path) throws Exception {
            DesignerPalette.this.m_manager.importFrom(path);
            DesignerPalette.this.reloadPalette();
        }

        public void exportPalette(String path) throws Exception {
            DesignerPalette.this.m_manager.exportTo(path);
        }

        public String getToolkitId() {
            return DesignerPalette.this.m_manager.getToolkitId();
        }

        public Shell getShell() {
            if (EnvironmentUtils.isGefPalette()) {
                return DesignerPalette.this.m_paletteComposite.getShell();
            }
            return DesignerPalette.this.m_legacyPaletteComposite.getShell();
        }
    }
}

