/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.php.formatter.core.profiles.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.ModifyDialogTabPage;
import org.eclipse.php.formatter.ui.preferences.PHPPreview;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class OffOnTagsTabPage
extends ModifyDialogTabPage {
    private boolean isInitialized = false;
    private ModifyDialogTabPage.StringPreference enableTagPref;
    private ModifyDialogTabPage.StringPreference disableTagPref;
    private ModifyDialogTabPage.CheckboxPreference enablePref;

    public OffOnTagsTabPage(ModifyDialog modifyDialog, CodeFormatterPreferences codeFormatterPreferences) {
        super(modifyDialog, codeFormatterPreferences);
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        OffOnTagsTabPage.createLabel(numColumns, composite, FormatterMessages.OffOnTagsTabPage_description);
        Label separator = new Label(composite, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, numColumns, 1);
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.enablePref = this.createCheckboxPref(composite, numColumns, FormatterMessages.OffOnTagsTabPage_enableOffOnTags);
        this.enablePref.setIsChecked(this.codeFormatterPreferences.use_tags);
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String input) {
                if (input.length() == 0) {
                    return null;
                }
                if (Character.isWhitespace(input.charAt(0))) {
                    return FormatterMessages.OffOnTagsTabPage_error_startsWithWhitespace;
                }
                if (Character.isWhitespace(input.charAt(input.length() - 1))) {
                    return FormatterMessages.OffOnTagsTabPage_error_endsWithWhitespace;
                }
                return null;
            }
        };
        Composite tagComposite = new Composite(composite, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = indent;
        tagComposite.setLayout((Layout)layout);
        this.disableTagPref = this.createStringPref(tagComposite, numColumns, FormatterMessages.OffOnTagsTabPage_disableTag, "org.eclipse.php.formatter.core.formatter.disabling_tag", inputValidator);
        if (this.codeFormatterPreferences.disabling_tag != null) {
            this.disableTagPref.setValue(new String(this.codeFormatterPreferences.disabling_tag));
        }
        this.enableTagPref = this.createStringPref(tagComposite, numColumns, FormatterMessages.OffOnTagsTabPage_enableTag, "org.eclipse.php.formatter.core.formatter.enabling_tag", inputValidator);
        if (this.codeFormatterPreferences.enabling_tag != null) {
            this.enableTagPref.setValue(new String(this.codeFormatterPreferences.enabling_tag));
        }
        this.enablePref.getControl().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean enabled = OffOnTagsTabPage.this.enablePref.isChecked();
                OffOnTagsTabPage.this.enableTagPref.setEnabled(enabled);
                OffOnTagsTabPage.this.disableTagPref.setEnabled(enabled);
            }
        });
        boolean enabled = this.enablePref.isChecked();
        this.enableTagPref.setEnabled(enabled);
        this.disableTagPref.setEnabled(enabled);
        this.isInitialized = true;
    }

    @Override
    public final Composite createContents(Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData());
        int numColumns = 2;
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        this.doCreatePreferences(composite, 2);
        return composite;
    }

    @Override
    protected void initializePage() {
    }

    @Override
    protected void doUpdatePreview() {
    }

    @Override
    protected PHPPreview doCreatePHPPreview(Composite parent) {
        return null;
    }

    @Override
    protected void updatePreferences() {
        if (this.isInitialized) {
            this.codeFormatterPreferences.use_tags = this.enablePref.isChecked();
            String disableTagOption = this.disableTagPref.getValue();
            if (disableTagOption != null) {
                int idx = disableTagOption.indexOf(10);
                if (idx == 0) {
                    this.codeFormatterPreferences.disabling_tag = null;
                } else {
                    String tag;
                    String string = tag = idx < 0 ? disableTagOption.trim() : disableTagOption.substring(0, idx).trim();
                    this.codeFormatterPreferences.disabling_tag = (char[])(tag.length() == 0 ? null : tag.toCharArray());
                }
            } else {
                this.codeFormatterPreferences.disabling_tag = null;
            }
            String enableTagOption = this.enableTagPref.getValue();
            if (enableTagOption != null) {
                int idx = enableTagOption.indexOf(10);
                if (idx == 0) {
                    this.codeFormatterPreferences.enabling_tag = null;
                } else {
                    String tag;
                    String string = tag = idx < 0 ? enableTagOption.trim() : enableTagOption.substring(0, idx).trim();
                    this.codeFormatterPreferences.enabling_tag = (char[])(tag.length() == 0 ? null : tag.toCharArray());
                }
            } else {
                this.codeFormatterPreferences.enabling_tag = null;
            }
        }
    }
}

