/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.ui.editor.selectionactions.StructureSelectUtil;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.ui.internal.handlers.StructuredSelectNextXMLHandler;

public class StructureSelectNextHandler
extends StructuredSelectNextXMLHandler {
    private ISourceModule sourceModule = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.sourceModule = StructureSelectUtil.getSourceModule(event);
        super.execute(event);
        this.sourceModule = null;
        return null;
    }

    protected Region getNewSelectionRegion(IndexedRegion indexedRegion, ITextSelection textSelection) {
        if (this.sourceModule != null && StructureSelectUtil.isPHP(indexedRegion)) {
            Selection selection = Selection.createFromStartLength((int)textSelection.getOffset(), (int)textSelection.getLength());
            SelectionAnalyzer selAnalyzer = new SelectionAnalyzer(selection, true);
            try {
                ASTNode previousNode;
                Program ast = StructureSelectUtil.getAST(this.sourceModule);
                ast.accept((Visitor)selAnalyzer);
                Region oldSourceRange = new Region(textSelection.getOffset(), textSelection.getLength());
                if (textSelection.getLength() == 0 && selAnalyzer.getLastCoveringNode() != null && (previousNode = NextNodeAnalyzer.perform(oldSourceRange.getOffset(), selAnalyzer.getLastCoveringNode())) != null) {
                    return StructureSelectUtil.getSelectedNodeSourceRange((ISourceReference)this.sourceModule, previousNode);
                }
                ASTNode first = selAnalyzer.getFirstSelectedNode();
                if (first == null) {
                    return StructureSelectUtil.getLastCoveringNodeRange(oldSourceRange, (ISourceReference)this.sourceModule, selAnalyzer);
                }
                ASTNode parent = first.getParent();
                if (parent == null) {
                    return StructureSelectUtil.getLastCoveringNodeRange(oldSourceRange, (ISourceReference)this.sourceModule, selAnalyzer);
                }
                ASTNode lastSelectedNode = selAnalyzer.getSelectedNodes()[selAnalyzer.getSelectedNodes().length - 1];
                ASTNode nextNode = this.getNextNode(parent, lastSelectedNode);
                if (nextNode == parent) {
                    return StructureSelectUtil.getSelectedNodeSourceRange((ISourceReference)this.sourceModule, first.getParent());
                }
                int offset = oldSourceRange.getOffset();
                int end = Math.min(this.sourceModule.getSourceRange().getLength(), nextNode.getStart() + nextNode.getLength() - 1);
                return StructureSelectUtil.createSourceRange(offset, end);
            }
            catch (ModelException modelException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getNewSelectionRegion(indexedRegion, textSelection);
    }

    private ASTNode getNextNode(ASTNode parent, ASTNode node) {
        Object[] siblingNodes = StructureSelectUtil.getSiblingNodes(node);
        if (siblingNodes == null || siblingNodes.length == 0) {
            return parent;
        }
        if (node == siblingNodes[siblingNodes.length - 1]) {
            return parent;
        }
        return siblingNodes[StructureSelectUtil.findIndex(siblingNodes, node) + 1];
    }

    private static class NextNodeAnalyzer
    extends ApplyAll {
        private final int fOffset;
        private ASTNode fNextNode;

        private NextNodeAnalyzer(int offset) {
            this.fOffset = offset;
        }

        public static ASTNode perform(int offset, ASTNode lastCoveringNode) {
            NextNodeAnalyzer analyzer = new NextNodeAnalyzer(offset);
            lastCoveringNode.accept((Visitor)analyzer);
            return analyzer.fNextNode;
        }

        protected boolean apply(ASTNode node) {
            int start = node.getStart();
            int end = start + node.getLength();
            if (start == this.fOffset) {
                this.fNextNode = node;
                return true;
            }
            return start < this.fOffset && this.fOffset < end;
        }
    }
}

