/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;

public abstract class RhinoPacket
implements Packet {
    private final String type;

    protected RhinoPacket(String type) {
        if (type == null) {
            throw new IllegalArgumentException("The type for a packet cannot be null");
        }
        this.type = type.intern();
    }

    protected RhinoPacket(Map json) {
        if (json == null) {
            throw new IllegalArgumentException("The JSON map for a packet cannot be null");
        }
        String packetType = (String)json.get("type");
        this.type = packetType.intern();
    }

    public String getType() {
        return this.type;
    }

    public Map toJSON() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("type", this.type);
        return json;
    }

    public static String getType(Map json) {
        if (json == null) {
            throw new IllegalArgumentException("A null JSON map is not allowed when trying to get the packet type");
        }
        return (String)json.get("type");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RhinoPacket: ").append(JSONUtil.write(this.toJSON()));
        return buffer.toString();
    }
}

