/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.ObjectKind;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Property;
import com.google.javascript.jscomp.newtypes.RawNominalType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public final class NominalType {
    private final ImmutableMap<String, JSType> typeMap;
    private final RawNominalType rawType;
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");

    NominalType(ImmutableMap<String, JSType> typeMap, RawNominalType rawType) {
        Preconditions.checkState((typeMap.isEmpty() || typeMap.keySet().containsAll(rawType.getTypeParameters()) && rawType.getTypeParameters().containsAll((Collection)typeMap.keySet()) ? 1 : 0) != 0);
        this.typeMap = typeMap;
        this.rawType = rawType;
    }

    public RawNominalType getRawNominalType() {
        Preconditions.checkState((!this.rawType.isFinalized() ? 1 : 0) != 0);
        return this.rawType;
    }

    public JSType getInstanceAsJSType() {
        return this.rawType.isGeneric() && !this.typeMap.isEmpty() ? JSType.fromObjectType(ObjectType.fromNominalType(this)) : this.rawType.getInstanceAsJSType();
    }

    ObjectKind getObjectKind() {
        return this.rawType.getObjectKind();
    }

    Map<String, JSType> getTypeMap() {
        return this.typeMap;
    }

    JSType getIndexType() {
        if (this.isIObject()) {
            return (JSType)this.typeMap.get(this.rawType.getTypeParameters().get(0));
        }
        JSType result = JSType.BOTTOM;
        for (NominalType interf : this.getInstantiatedInterfaces()) {
            JSType tmp = interf.getIndexType();
            if (tmp == null) continue;
            result = JSType.join(result, tmp);
        }
        return result.isBottom() ? null : result;
    }

    JSType getIndexedType() {
        if (this.isIObject()) {
            return (JSType)this.typeMap.get(this.rawType.getTypeParameters().get(1));
        }
        JSType result = JSType.TOP;
        boolean foundIObject = false;
        for (NominalType interf : this.getInstantiatedInterfaces()) {
            JSType tmp = interf.getIndexedType();
            if (tmp == null) continue;
            foundIObject = true;
            result = JSType.meet(result, tmp);
        }
        return foundIObject ? result : null;
    }

    boolean isClassy() {
        return !this.isFunction() && !this.isBuiltinObject();
    }

    boolean isFunction() {
        return this.rawType.isBuiltinWithName("Function");
    }

    public boolean isBuiltinObject() {
        return this.rawType.isBuiltinWithName("Object");
    }

    private boolean isIObject() {
        return this.rawType.isBuiltinWithName("IObject");
    }

    public boolean isStruct() {
        return this.rawType.isStruct();
    }

    public boolean isDict() {
        return this.rawType.isDict();
    }

    public boolean isGeneric() {
        return this.rawType.isGeneric();
    }

    public boolean isUninstantiatedGenericType() {
        return this.rawType.isGeneric() && this.typeMap.isEmpty();
    }

    NominalType instantiateGenerics(List<JSType> types) {
        ImmutableList<String> typeParams = this.rawType.getTypeParameters();
        Preconditions.checkState((types.size() == typeParams.size() ? 1 : 0) != 0);
        LinkedHashMap<String, JSType> typeMap = new LinkedHashMap<String, JSType>();
        for (int i = 0; i < typeParams.size(); ++i) {
            typeMap.put((String)typeParams.get(i), types.get(i));
        }
        return this.instantiateGenerics(typeMap);
    }

    NominalType instantiateGenerics(Map<String, JSType> newTypeMap) {
        ImmutableMap resultMap;
        if (newTypeMap.isEmpty()) {
            return this;
        }
        if (!this.rawType.isGeneric()) {
            return this.rawType.getAsNominalType();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!this.typeMap.isEmpty()) {
            for (String oldKey : this.typeMap.keySet()) {
                builder.put((Object)oldKey, (Object)((JSType)this.typeMap.get((Object)oldKey)).substituteGenerics(newTypeMap));
            }
            resultMap = builder.build();
        } else {
            ImmutableList<String> typeParams = this.rawType.getTypeParameters();
            for (String newKey : typeParams) {
                if (!newTypeMap.containsKey(newKey)) continue;
                builder.put((Object)newKey, (Object)newTypeMap.get(newKey));
            }
            resultMap = builder.build();
            if (resultMap.isEmpty()) {
                return this;
            }
            if (resultMap.size() < typeParams.size()) {
                return this;
            }
        }
        return new NominalType((ImmutableMap<String, JSType>)resultMap, this.rawType);
    }

    public String getName() {
        return this.rawType.name;
    }

    public RawNominalType getId() {
        return this.rawType;
    }

    public boolean isClass() {
        return this.rawType.isClass();
    }

    public boolean isInterface() {
        return this.rawType.isInterface();
    }

    boolean isStructuralInterface() {
        return this.rawType.isStructuralInterface();
    }

    public boolean isFinalized() {
        return this.rawType.isFinalized();
    }

    boolean hasAncestorClass(RawNominalType ancestor) {
        return this.rawType.hasAncestorClass(ancestor);
    }

    boolean hasAncestorInterface(RawNominalType ancestor) {
        return this.rawType.hasAncestorInterface(ancestor);
    }

    public ImmutableSet<String> getAllPropsOfInterface() {
        return this.rawType.getAllPropsOfInterface();
    }

    public ImmutableSet<String> getAllPropsOfClass() {
        return this.rawType.getAllPropsOfClass();
    }

    public NominalType getInstantiatedSuperclass() {
        Preconditions.checkState((boolean)this.rawType.isFinalized());
        if (this.rawType.getSuperClass() == null) {
            return null;
        }
        return this.rawType.getSuperClass().instantiateGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPrototype() {
        Preconditions.checkState((boolean)this.rawType.isFinalized());
        return this.rawType.getCtorPropDeclaredType("prototype").substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public ImmutableSet<NominalType> getInstantiatedInterfaces() {
        Preconditions.checkState((boolean)this.rawType.isFinalized());
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (NominalType interf : this.rawType.getInterfaces()) {
            result.add((Object)interf.instantiateGenerics((Map<String, JSType>)this.typeMap));
        }
        return result.build();
    }

    Property getProp(String pname) {
        if (this.rawType.name.equals("Array") && NUMERIC_PATTERN.matcher(pname).matches()) {
            if (this.typeMap.isEmpty()) {
                return Property.make(JSType.UNKNOWN, null);
            }
            Preconditions.checkState((this.typeMap.size() == 1 ? 1 : 0) != 0);
            JSType elmType = (JSType)Iterables.getOnlyElement((Iterable)this.typeMap.values());
            return Property.make(elmType, null);
        }
        Property p = this.rawType.getProp(pname);
        return p == null ? null : p.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public JSType getPropDeclaredType(String pname) {
        JSType type = this.rawType.getInstancePropDeclaredType(pname);
        if (type == null) {
            return null;
        }
        return type.substituteGenerics((Map<String, JSType>)this.typeMap);
    }

    public boolean hasConstantProp(String pname) {
        Property p = this.rawType.getProp(pname);
        return p != null && p.isConstant();
    }

    boolean isSubtypeOf(NominalType other, SubtypeCache subSuperMap) {
        return this.isNominalSubtypeOf(other) || other.isStructuralInterface() && this.isStructuralSubtypeOf(other, subSuperMap);
    }

    private boolean isStructuralSubtypeOf(NominalType other, SubtypeCache subSuperMap) {
        Preconditions.checkArgument((boolean)other.isStructuralInterface());
        for (String pname : other.getAllPropsOfInterface()) {
            Property prop2 = other.getProp(pname);
            Property prop1 = this.getProp(pname);
            if (!(prop2.isOptional() ? prop1 != null && !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap) : prop1 == null || prop1.isOptional() || !prop1.getType().isSubtypeOf(prop2.getType(), subSuperMap))) continue;
            return false;
        }
        return true;
    }

    boolean isNominalSubtypeOf(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this.areTypeMapsCompatible(other);
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                if (!i.instantiateGenerics((Map<String, JSType>)this.typeMap).isNominalSubtypeOf(other)) continue;
                return true;
            }
        }
        return this.isClass() && thisRaw.getSuperClass() != null && thisRaw.getSuperClass().instantiateGenerics((Map<String, JSType>)this.typeMap).isNominalSubtypeOf(other);
    }

    private boolean areTypeMapsCompatible(NominalType other) {
        Preconditions.checkState((boolean)this.rawType.equals(other.rawType));
        if (this.typeMap.isEmpty()) {
            return other.instantiationIsUnknownOrIdentity();
        }
        if (other.typeMap.isEmpty()) {
            return this.instantiationIsUnknownOrIdentity();
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            JSType otherType;
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
            Preconditions.checkState((boolean)other.typeMap.containsKey((Object)typeVar), (String)"Other (%s) doesn't contain mapping (%s->%s) from this (%s)", (Object[])new Object[]{other, typeVar, this.typeMap.get((Object)typeVar), this});
            JSType thisType = (JSType)this.typeMap.get((Object)typeVar);
            if (thisType.isSubtypeOf(otherType = (JSType)other.typeMap.get((Object)typeVar))) continue;
            return false;
        }
        return true;
    }

    static NominalType unifyUnknowns(NominalType nt1, NominalType nt2) {
        if (!nt1.rawType.equals(nt2.rawType)) {
            return null;
        }
        ImmutableMap<String, JSType> m1 = nt1.typeMap;
        ImmutableMap<String, JSType> m2 = nt2.typeMap;
        if (m1.isEmpty() && m2.isEmpty()) {
            return nt1;
        }
        if (m1.isEmpty() || m2.isEmpty()) {
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : m1.entrySet()) {
            String typeVar = (String)entry.getKey();
            JSType t1 = (JSType)entry.getValue();
            JSType t2 = (JSType)m2.get(typeVar);
            if (t1.isUnknown()) {
                builder.put((Object)typeVar, (Object)t2);
                continue;
            }
            if (t2.isUnknown()) {
                builder.put((Object)typeVar, (Object)t1);
                continue;
            }
            JSType newType = JSType.unifyUnknowns(t1, t2);
            if (newType == null) {
                return null;
            }
            builder.put((Object)typeVar, (Object)newType);
        }
        return new NominalType((ImmutableMap<String, JSType>)builder.build(), nt1.rawType);
    }

    private boolean instantiationIsUnknownOrIdentity() {
        if (this.typeMap.isEmpty()) {
            return true;
        }
        for (String typeVar : this.rawType.getTypeParameters()) {
            Preconditions.checkState((boolean)this.typeMap.containsKey((Object)typeVar), (String)"Type variable %s not in the domain: %s", (Object[])new Object[]{typeVar, this.typeMap.keySet()});
            JSType t = (JSType)this.typeMap.get((Object)typeVar);
            if (t.isUnknown() || t.equals(JSType.fromTypeVar(typeVar))) continue;
            return false;
        }
        return true;
    }

    static NominalType pickSuperclass(NominalType c1, NominalType c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        if (c1.isNominalSubtypeOf(c2)) {
            return c2;
        }
        return c2.isNominalSubtypeOf(c1) ? c1 : null;
    }

    static NominalType pickSubclass(NominalType c1, NominalType c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (c1.isNominalSubtypeOf(c2)) {
            return c1;
        }
        return c2.isNominalSubtypeOf(c1) ? c2 : null;
    }

    boolean unifyWithSubtype(NominalType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        if ((other = other.findMatchingAncestorWith(this)) == null) {
            return false;
        }
        if (!this.isGeneric()) {
            return true;
        }
        Preconditions.checkState((!this.typeMap.isEmpty() ? 1 : 0) != 0);
        if (other.typeMap.isEmpty()) {
            return true;
        }
        boolean hasUnified = true;
        for (String typeParam : this.rawType.getTypeParameters()) {
            JSType fromOtherMap = (JSType)other.typeMap.get((Object)typeParam);
            Preconditions.checkNotNull((Object)fromOtherMap, (String)"Type variable %s not found in map %s", (Object[])new Object[]{typeParam, other.typeMap});
            hasUnified = hasUnified && ((JSType)this.typeMap.get((Object)typeParam)).unifyWithSubtype(fromOtherMap, typeParameters, typeMultimap, subSuperMap);
        }
        return hasUnified;
    }

    private NominalType findMatchingAncestorWith(NominalType other) {
        RawNominalType thisRaw = this.rawType;
        if (thisRaw == other.rawType) {
            return this;
        }
        if (other.isInterface()) {
            for (NominalType i : thisRaw.getInterfaces()) {
                NominalType nt = i.instantiateGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
                if (nt == null) continue;
                return nt;
            }
        }
        if (this.isClass() && thisRaw.getSuperClass() != null) {
            return thisRaw.getSuperClass().instantiateGenerics((Map<String, JSType>)this.typeMap).findMatchingAncestorWith(other);
        }
        return null;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    StringBuilder appendTo(StringBuilder builder) {
        if (this.typeMap.isEmpty()) {
            return this.rawType.appendTo(builder);
        }
        builder.append(this.rawType.name);
        ImmutableList<String> typeParams = this.rawType.getTypeParameters();
        Preconditions.checkState((boolean)this.typeMap.keySet().containsAll(typeParams));
        boolean firstIteration = true;
        builder.append('<');
        for (String typeParam : typeParams) {
            if (firstIteration) {
                firstIteration = false;
            } else {
                builder.append(',');
            }
            JSType concrete = (JSType)this.typeMap.get((Object)typeParam);
            ((JSType)Preconditions.checkNotNull((Object)concrete)).appendTo(builder);
        }
        builder.append('>');
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.typeMap, this.rawType);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        Preconditions.checkState((boolean)(other instanceof NominalType));
        NominalType o = (NominalType)other;
        return Objects.equals(this.typeMap, o.typeMap) && this.rawType.equals(o.rawType);
    }
}

