/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.param;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.codan.core.param.AbstractProblemPreference;
import org.eclipse.cdt.codan.core.param.IProblemPreferenceDescriptor;
import org.eclipse.cdt.codan.core.param.Messages;
import org.eclipse.cdt.codan.internal.core.CharOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileScopeProblemPreference
extends AbstractProblemPreference {
    public static final String KEY = "fileScope";
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    private IResource resource;
    private IPath[] inclusion = new IPath[0];
    private IPath[] exclusion = new IPath[0];

    public FileScopeProblemPreference() {
        this.setKey(KEY);
        this.setLabel(Messages.FileScopeProblemPreference_Label);
    }

    @Override
    public IProblemPreferenceDescriptor.PreferenceType getType() {
        return IProblemPreferenceDescriptor.PreferenceType.TYPE_CUSTOM;
    }

    public IPath[] getAttribute(String key) {
        if (key == EXCLUSION) {
            return this.exclusion;
        }
        if (key == INCLUSION) {
            return this.inclusion;
        }
        return null;
    }

    public void setAttribute(String key, IPath[] value) {
        if (key == EXCLUSION) {
            this.exclusion = (IPath[])value.clone();
        }
        if (key == INCLUSION) {
            this.inclusion = (IPath[])value.clone();
        }
    }

    public IProject getProject() {
        if (this.resource != null) {
            return this.resource.getProject();
        }
        return null;
    }

    public IPath getPath() {
        if (this.resource != null) {
            return this.resource.getFullPath();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        return root.getFullPath();
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    @Override
    public boolean isDefault() {
        return this.inclusion.length == 0 && this.exclusion.length == 0;
    }

    @Override
    public String exportValue() {
        return this.exportPathList(INCLUSION, this.inclusion) + "," + this.exportPathList(EXCLUSION, this.exclusion);
    }

    protected String exportPathList(String key, IPath[] arr) {
        String res = key + "=>(";
        int i = 0;
        while (i < arr.length) {
            if (i != 0) {
                res = res + ",";
            }
            res = res + this.escape(arr[i].toPortableString());
            ++i;
        }
        return res + ")";
    }

    @Override
    public void importValue(StreamTokenizer tokenizer) throws IOException {
        List<IPath> inc = this.importPathList(tokenizer, INCLUSION);
        this.inclusion = inc.toArray(new IPath[inc.size()]);
        this.checkChar(tokenizer, ',');
        List<IPath> exc = this.importPathList(tokenizer, EXCLUSION);
        this.exclusion = exc.toArray(new IPath[exc.size()]);
    }

    private void checkChar(StreamTokenizer tokenizer, char c) throws IOException {
        tokenizer.nextToken();
        if (tokenizer.ttype != c) {
            throw new IllegalArgumentException("Expected " + c);
        }
    }

    private void checkKeyword(StreamTokenizer tokenizer, String keyword) throws IOException {
        tokenizer.nextToken();
        if (tokenizer.sval == null || !tokenizer.sval.equals(keyword)) {
            throw new IllegalArgumentException("Expected " + keyword);
        }
    }

    protected List<IPath> importPathList(StreamTokenizer tokenizer, String keyword) throws IOException {
        this.checkKeyword(tokenizer, keyword);
        this.checkChar(tokenizer, '=');
        this.checkChar(tokenizer, '>');
        ArrayList<IPath> list = new ArrayList<IPath>();
        try {
            this.checkChar(tokenizer, '(');
            int token = tokenizer.nextToken();
            if (token == 41) {
                return Collections.emptyList();
            }
            tokenizer.pushBack();
            while (true) {
                token = tokenizer.nextToken();
                if (tokenizer.sval == null) {
                    throw new IllegalArgumentException();
                }
                list.add((IPath)new Path(tokenizer.sval));
                token = tokenizer.nextToken();
                if (token != 41) {
                    tokenizer.pushBack();
                    this.checkChar(tokenizer, ',');
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return list;
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    public void setValue(Object value) {
        if (this == value) {
            return;
        }
        FileScopeProblemPreference scope = (FileScopeProblemPreference)value;
        this.setAttribute(INCLUSION, scope.getAttribute(INCLUSION));
        this.setAttribute(EXCLUSION, scope.getAttribute(EXCLUSION));
        this.resource = scope.getResource();
    }

    @Override
    public Object clone() {
        FileScopeProblemPreference scope = (FileScopeProblemPreference)super.clone();
        scope.setValue(this);
        return scope;
    }

    public boolean isInScope(IPath path) {
        if (this.inclusion.length > 0 && !this.matchesFilter(path, this.inclusion)) {
            return false;
        }
        return this.exclusion.length <= 0 || !this.matchesFilter(path, this.exclusion);
    }

    public boolean matchesFilter(IPath resourcePath, IPath[] paths) {
        String path = resourcePath.makeRelative().toString();
        int i = 0;
        int length = paths.length;
        while (i < length) {
            String pattern = paths[i].toString();
            if (CharOperation.pathMatch(pattern, path, true, '/')) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

