/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.basequery;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.BaseQuery;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

public class AtomicQuery
extends BaseQuery {
    private String m_queryText;

    public AtomicQuery(String queryText) {
        this.setQueryText(queryText);
    }

    public void setQueryText(String queryText) {
        this.m_queryText = queryText;
    }

    public String getQueryText() {
        return this.m_queryText;
    }

    public boolean hasQueryText() {
        return this.getQueryText() != null && !this.getQueryText().trim().isEmpty();
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
        if (!this.hasQueryText()) {
            throw ValidatorUtil.newBaseQueryException(Messages.querySpec_MISSING_ATOMIC_QUERY_TEXT, this);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(AtomicQuery.class.getSimpleName());
        buffer.append("  { query text: ");
        buffer.append(this.m_queryText);
        buffer.append(" }");
        return buffer.toString();
    }
}

