/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.FederatedParameterImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class LUWCatalogFederatedParameter
extends FederatedParameterImpl
implements ICatalogObject {
    boolean remoteParamIsReturnValue = false;
    int remoteRemoteParamLength = 0;
    int remoteRemoteParamScale = 0;
    String remoteParamTypeName = "";
    String remoteParamTypeSchema = "";

    public void refresh() {
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getRoutine().getSchema().getDatabase();
    }

    public static void loadParameterOptions(Connection connection, LUWCatalogFederatedParameter parameter, int routineID, int ordinal) {
        String query = "SELECT ORDINAL, OPTION, SETTING FROM SYSIBM.SYSROUTINEPARMOPTIONS WHERE ROUTINEID=" + routineID + " AND ORDINAL=" + ordinal;
        try {
            Statement s = connection.createStatement();
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String option = r.getString("OPTION");
                String setting = r.getString("SETTING");
                if (option.equals("REMOTE_PARM_NAME")) {
                    parameter.setName(setting);
                    continue;
                }
                if (option.equals("REMOTE_PARM_TYPESCHEMA")) {
                    parameter.setRemoteParamTypeSchema(setting);
                    continue;
                }
                if (option.equals("REMOTE_PARM_TYPENAME")) {
                    parameter.setRemoteParamTypeName(setting);
                    continue;
                }
                if (option.equals("REMOTE_PARM_SCALE")) {
                    parameter.setRemoteRemoteParamScale(Integer.decode(setting));
                    continue;
                }
                if (option.equals("REMOTE_PARM_LENGTH")) {
                    parameter.setRemoteRemoteParamLength(Integer.decode(setting));
                    continue;
                }
                if (option.equals("REMOTE_CODEPAGE")) {
                    parameter.setRemoteCodePage(Integer.decode(setting));
                    continue;
                }
                if (option.equals("REMOTE_PARM_IS_RETURN_VALUE")) {
                    parameter.setRemoteParamIsReturnValue(setting);
                    continue;
                }
                if (!option.equals("REMOTE_PARM_TYPE_ID")) continue;
                parameter.setRemoteParamTypeID(Integer.decode(setting));
            }
        }
        catch (Exception exception) {}
    }

    private void setRemoteParamTypeName(String setting) {
        this.remoteParamTypeName = setting;
    }

    private void setRemoteParamIsReturnValue(String setting) {
        if (setting.equals("Y")) {
            this.setRemoteParamIsReturnValue(true);
        }
    }

    private void setRemoteParamIsReturnValue(boolean setting) {
        this.remoteParamIsReturnValue = setting;
    }

    private void setRemoteRemoteParamLength(int setting) {
        this.remoteRemoteParamLength = setting;
    }

    private void setRemoteRemoteParamScale(int setting) {
        this.remoteRemoteParamScale = setting;
    }

    private void setRemoteParamTypeSchema(String setting) {
        this.remoteParamTypeSchema = setting;
    }

    public String getRemoteParamTypeName() {
        return this.remoteParamTypeName;
    }

    public boolean getRemoteParamIsReturnValue() {
        return this.remoteParamIsReturnValue;
    }

    public int getRemoteRemoteParamLength() {
        return this.remoteRemoteParamLength;
    }

    public int getRemoteRemoteParamScale() {
        return this.remoteRemoteParamScale;
    }

    public String getRemoteParamTypeSchema() {
        return this.remoteParamTypeSchema;
    }
}

