/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ibm.catalog.IDatabaseObject;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogSchema;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogTable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWDdlParser;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.LUWUtil;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWViewImpl;
import org.eclipse.datatools.enablement.ibm.db2.model.DB2Package;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.expressions.SQLExpressionsPackage;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Dependency;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.CheckType;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogView
extends LUWViewImpl
implements ICatalogObject,
IDatabaseObject {
    private static final String PROP_VIEW_VIEWINFO = "PROP_VIEW_VIEWINFO";
    private boolean columnsLoaded = false;
    private boolean viewLoaded = false;
    private boolean triggerLoaded = false;
    private boolean dependencyLoaded = false;
    private boolean privilegeLoaded = false;
    private boolean updatable;
    private boolean impactsLoaded = false;
    private Collection impacts = new ArrayList();

    public void refresh() {
        this.columnsLoaded = false;
        this.triggerLoaded = false;
        this.viewLoaded = false;
        if (this.dependencyLoaded) {
            this.dependencies.clear();
            this.dependencyLoaded = false;
        }
        this.privilegeLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    public void refresh(int refreshType) {
        if (!false) {
            this.impacts.clear();
            this.impactsLoaded = false;
        }
    }

    public EList getColumns() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getColumns();
        }
        if (!this.columnsLoaded) {
            this.loadColumns();
        }
        return this.columns;
    }

    public QueryExpression getQueryExpression() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.queryExpression;
    }

    public CheckType getCheckType() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.checkType;
    }

    public boolean isUpdatable() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.updatable;
    }

    public boolean isInsertable() {
        if (!this.viewLoaded) {
            this.loadView();
        }
        return this.updatable;
    }

    public EList getTriggers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getTriggers();
        }
        if (!this.triggerLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    public EList getDependencies() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getDependencies();
        }
        if (!this.dependencyLoaded) {
            this.loadDependencies();
        }
        return this.dependencies;
    }

    public EList getPrivileges() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getPrivileges();
        }
        if (!this.privilegeLoaded) {
            this.loadPrivileges();
        }
        return this.privileges;
    }

    public ICatalogObject[] getImpacted() {
        if (!this.impactsLoaded) {
            this.impacts = this.getImpactedObjects();
            this.impactsLoaded = true;
        }
        ICatalogObject[] objs = new ICatalogObject[this.impacts.size()];
        this.impacts.toArray(objs);
        return objs;
    }

    public Collection getStatistics() {
        return new ArrayList();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        } else if (id == 19) {
            this.getCheckType();
        } else if (id == 18) {
            this.getQueryExpression();
        } else if (id == 13) {
            this.getTriggers();
        } else if (id == 2) {
            this.getDependencies();
        } else if (id == 17) {
            this.isUpdatable();
        } else if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumns() {
        if (this.columnsLoaded) {
            return;
        }
        this.columnsLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadColumns(this.getConnection(), super.getColumns(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadTriggers() {
        if (this.triggerLoaded) {
            return;
        }
        this.triggerLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadTriggers(this.getConnection(), super.getTriggers(), (Table)this, ((LUWCatalogDatabase)this.getCatalogDatabase()).getLoadOptions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadView() {
        if (this.viewLoaded) {
            return;
        }
        this.viewLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        this.getCatalogDatabase();
        String cfr_ignored_0 = String.valueOf(this.getSchema().getName()) + "." + this.getName();
        try {
            Connection connection = this.getConnection();
            Statement s = connection.createStatement();
            String query = "SELECT VIEWCHECK, READONLY,VALID, TEXT, VIEWSCHEMA, VIEWNAME FROM SYSCAT.VIEWS";
            query = String.valueOf(query) + " WHERE VIEWSCHEMA='" + LUWUtil.getIdentifier(this.getSchema().getName()) + "' AND VIEWNAME='" + LUWUtil.getIdentifier(this.getName()) + "'";
            query = String.valueOf(query) + " ORDER BY";
            query = String.valueOf(query) + " SEQNO";
            ResultSet r = s.executeQuery(query);
            ViewInfo info = null;
            while (r.next()) {
                String text;
                String sname = r.getString("VIEWSCHEMA").trim();
                String vname = r.getString("VIEWNAME").trim();
                if (info == null || sname != info.viewSchemaName || vname != info.viewSchemaName) {
                    info = new ViewInfo();
                    info.viewSchemaName = sname;
                    info.viewName = vname;
                    info.VIEWCHECK = r.getString(1);
                    info.READONLY = r.getString(2);
                    info.VALID = r.getString("VALID");
                    info.TEXT = new StringBuilder();
                }
                if ((text = r.getString("TEXT")) == null) continue;
                info.TEXT.append(text.trim());
            }
            r.close();
            s.close();
            if (info != null) {
                info.setViewInfo(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadDependencies() {
        if (this.dependencyLoaded) {
            return;
        }
        this.dependencyLoaded = true;
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogView.loadDependencies(this.getConnection(), super.getDependencies(), (Table)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    private synchronized void loadPrivileges() {
        if (this.privilegeLoaded) {
            return;
        }
        this.privilegeLoaded = true;
        EList privileges = super.getPrivileges();
        for (Privilege privilege : privileges) {
            privilege.setGrantor(null);
            privilege.setGrantee(null);
        }
        privileges.clear();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    public static Schema getSchema(Table table, String schemaName) {
        return LUWCatalogTable.getSchema(table, schemaName);
    }

    public static Table getTable(Table t, String schemaName, String tableName) {
        Schema schema = LUWCatalogView.getSchema(t, schemaName);
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getTable(schemaName, tableName);
        }
        for (Table table : schema.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public static Routine getRountine(Table table, String schemaName, String specificName) {
        Schema schema = LUWCatalogView.getSchema(table, schemaName);
        for (Routine routine : schema.getRoutines()) {
            if (!specificName.equals(routine.getSpecificName())) continue;
            return routine;
        }
        return null;
    }

    public static Index getIndex(Table table, String schemaName, String indexName) {
        Schema schema = LUWCatalogView.getSchema(table, schemaName);
        for (Index index : schema.getIndices()) {
            if (!index.getName().equals(indexName)) continue;
            return index;
        }
        return null;
    }

    public static UserDefinedType getUserDefinedType(Table table, String schemaName, String userDefinedTypeName) {
        Schema schema = LUWCatalogView.getSchema(table, schemaName);
        for (UserDefinedType userDefinedType : schema.getUserDefinedTypes()) {
            if (!userDefinedType.getName().equals(userDefinedTypeName)) continue;
            return userDefinedType;
        }
        return null;
    }

    public static TableConstraint getTableConstraint(Table table, String schemaName, String tableName, String constName) {
        Table t = LUWCatalogView.getTable(table, schemaName, tableName);
        if (!(t instanceof BaseTable)) {
            return null;
        }
        for (TableConstraint constraint : ((BaseTable)t).getConstraints()) {
            if (!constraint.getName().equals(constName)) continue;
            return constraint;
        }
        return null;
    }

    public static Trigger getTrigger(Table table, String schemaName, String tableName, String triggerName) {
        Table t = LUWCatalogView.getTable(table, schemaName, tableName);
        for (Trigger r : t.getTriggers()) {
            if (!r.getName().equals(triggerName)) continue;
            return r;
        }
        return null;
    }

    public static DB2Package getDb2Package(Table table, String schemaName, String pkgName, String pkgUniqueID) {
        Schema schema = LUWCatalogView.getSchema(table, schemaName);
        if (schema instanceof LUWCatalogSchema) {
            return ((LUWCatalogSchema)schema).getDB2Package(pkgName, pkgUniqueID);
        }
        return null;
    }

    public static void loadDependencies(Connection connection, EList dependencyList, Table table) throws SQLException {
        Database database = table.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery("SELECT BSCHEMA, BNAME, BTYPE FROM SYSCAT.TABDEP WHERE TABSCHEMA='" + LUWUtil.getIdentifier(table.getSchema().getName()) + "' AND TABNAME='" + LUWUtil.getIdentifier(table.getName()) + "'");
        try {
            while (r.next()) {
                String bschema = r.getString(1).trim();
                String bname = r.getString(2);
                String btype = r.getString(3);
                Table obj = null;
                if (btype.equals("A")) {
                    obj = LUWCatalogView.getTable(table, bschema, bname);
                } else if (btype.equals("F")) {
                    obj = LUWCatalogView.getRountine(table, bschema, bname);
                } else if (btype.equals("N")) {
                    obj = LUWCatalogView.getTable(table, bschema, bname);
                } else {
                    if (btype.equals("O")) continue;
                    if (btype.equals("I")) {
                        obj = LUWCatalogView.getIndex(table, bschema, bname);
                    } else if (btype.equals("R")) {
                        obj = LUWCatalogView.getUserDefinedType(table, bschema, bname);
                    } else if (btype.equals("S")) {
                        obj = LUWCatalogView.getTable(table, bschema, bname);
                    } else if (btype.equals("T")) {
                        obj = LUWCatalogView.getTable(table, bschema, bname);
                    } else if (btype.equals("U")) {
                        obj = LUWCatalogView.getTable(table, bschema, bname);
                    } else if (btype.equals("V")) {
                        obj = LUWCatalogView.getTable(table, bschema, bname);
                    } else {
                        if (!btype.equals("W")) continue;
                        obj = LUWCatalogView.getTable(table, bschema, bname);
                    }
                }
                if (obj == null) continue;
                Dependency dep = (Dependency)factory.create(SQLSchemaPackage.eINSTANCE.getDependency());
                dep.setTargetEnd((EObject)obj);
                dependencyList.add((Object)dep);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        r.close();
        s.close();
    }

    private Collection getImpactedObjects() {
        ArrayList impacts = new ArrayList();
        Connection connection = this.getConnection();
        impacts.addAll(LUWCatalogTable.getImpactedAlias(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTables(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedRoutines(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedTriggers(connection, (Table)this));
        impacts.addAll(LUWCatalogTable.getImpactedPackages(connection, (Table)this));
        return impacts;
    }

    protected void getPrivilegesWithFilter(String granteeFilter) throws SQLException {
        if (this.privilegeLoaded) {
            return;
        }
        EList privileges = super.getPrivileges();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogTable.loadPrivileges(this.getConnection(), privileges, (Table)this, granteeFilter);
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private static class ViewInfo {
        String viewSchemaName;
        String viewName;
        String VIEWCHECK;
        String READONLY;
        String VALID;
        StringBuilder TEXT;

        private ViewInfo() {
        }

        public String getKey() {
            return String.valueOf(this.viewSchemaName) + "." + this.viewName;
        }

        public void setViewInfo(LUWCatalogView view) {
            if ("N".equals(this.VIEWCHECK)) {
                view.setCheckType(CheckType.NONE_LITERAL);
            } else if ("L".equals(this.VIEWCHECK)) {
                view.setCheckType(CheckType.LOCAL_LITERAL);
            } else if ("C".equals(this.VIEWCHECK)) {
                view.setCheckType(CheckType.CASCADED_LITERAL);
            }
            view.updatable = "N".equals(this.READONLY);
            view.operative = "X".equalsIgnoreCase(this.VALID);
            String text = this.TEXT.toString().replaceAll("[\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u000b\f\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f]", " ");
            DatabaseDefinitionRegistry dbregistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
            DatabaseDefinition dbdef = dbregistry.getDefinition(view.getCatalogDatabase());
            if (view.queryExpression == null) {
                DataModelElementFactory factory = dbdef.getDataModelElementFactory();
                view.setQueryExpression((QueryExpression)factory.create(SQLExpressionsPackage.eINSTANCE.getQueryExpressionDefault()));
            }
            LUWDdlParser ddlParser = new LUWDdlParser(dbdef);
            ddlParser.parseView((ViewTable)view, text);
        }
    }
}

