/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.base.diagnostic.RequirementsCoverageExplained;
import org.eclipse.passage.lic.base.restrictions.CertificateIsRestrictive;
import org.eclipse.passage.lic.base.restrictions.CertificateWorthAttention;
import org.eclipse.passage.lic.cli.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.cli.DecoratedPrompt;
import org.eclipse.passage.lic.cli.LicenseCoverageCheckOption;
import org.eclipse.passage.lic.cli.Option;
import org.eclipse.passage.lic.cli.OptionDefinitions;
import org.eclipse.passage.lic.cli.Options;
import org.eclipse.passage.lic.cli.TheOtherSide;
import org.eclipse.passage.lic.equinox.EquinoxPassageLicenseCoverage;

public final class LicenseCoverageCheck {
    private final String name;
    private final TheOtherSide communication;
    private final OptionDefinitions opts;

    public LicenseCoverageCheck(String name, TheOtherSide communication, OptionDefinitions opts) {
        this.name = name;
        this.communication = communication;
        this.opts = opts;
    }

    public Result run() {
        CoverageCheckOptionDecision intention = CoverageCheckOptionDecision.reassess;
        while (CoverageCheckOptionDecision.reassess.equals((Object)intention)) {
            ServiceInvocationResult assessment = new EquinoxPassageLicenseCoverage().assess();
            this.reportAssessment(assessment.data());
            Options<LicenseCoverageCheckOption, CoverageCheckOptionDecision> options = this.options((ServiceInvocationResult<ExaminationCertificate>)assessment);
            this.communication.withContext((ServiceInvocationResult<ExaminationCertificate>)assessment, this.keys(options.options()));
            intention = options.promptAndPick().run();
        }
        return CoverageCheckOptionDecision.proceed.equals((Object)intention) ? Result.proceed : Result.exit;
    }

    private Options<LicenseCoverageCheckOption, CoverageCheckOptionDecision> options(ServiceInvocationResult<ExaminationCertificate> assessment) {
        ArrayList options = new ArrayList();
        if (new CertificateIsRestrictive().test(assessment.data())) {
            options.add(this.opts.licenseImport());
            options.add(this.opts.licenseRequest());
            this.agreements(assessment).map(this.opts::accept).ifPresent(options::add);
            options.add(this.opts.diagnostic(assessment.diagnostic()));
            options.add(this.opts.quit());
        } else {
            options.add(this.opts.licenseImport());
            options.add(this.opts.licenseRequest());
            options.add(this.opts.diagnostic(assessment.diagnostic()));
            options.add(this.opts.proceed(this.name));
            options.add(this.opts.quit());
        }
        return new Options<LicenseCoverageCheckOption, CoverageCheckOptionDecision>(options, this.communication);
    }

    private Optional<Collection<AgreementToAccept>> agreements(ServiceInvocationResult<ExaminationCertificate> assessment) {
        if (!assessment.data().isPresent()) {
            return Optional.empty();
        }
        Collection agreements = ((ExaminationCertificate)assessment.data().get()).agreements();
        if (agreements.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(agreements);
    }

    private void reportAssessment(Optional<ExaminationCertificate> certificate) {
        new DecoratedPrompt(this.communication).head(this.name + " license coverage assessment");
        if (certificate.isPresent()) {
            if (new CertificateIsRestrictive().test(certificate)) {
                this.communication.prompt("License coverage for the product or its features is not sufficient");
            } else if (new CertificateWorthAttention().test(certificate)) {
                this.communication.prompt("License coverage for the product or its features worth your attention");
            } else {
                this.communication.prompt("License coverage for the product and all its features is sufficient");
            }
            this.communication.prompt(String.format("\n%s", new RequirementsCoverageExplained(certificate.get()).get()));
        } else {
            this.communication.prompt(this.name + " license status assessment failed");
        }
    }

    private List<? extends Option.Key> keys(List<Option<LicenseCoverageCheckOption, CoverageCheckOptionDecision>> options) {
        return options.stream().map(Option::key).toList();
    }

    public static enum Result {
        proceed,
        exit;

    }
}

