/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.PHPCoreOptionsConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.ValuedCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPVersionConfigurationBlock
extends PHPCoreOptionsConfigurationBlock {
    private static final Key PREF_PHP_VERSION = PHPVersionConfigurationBlock.getPHPCoreKey("phpVersion");
    private static final Key PREF_ASP_TAGS = PHPVersionConfigurationBlock.getPHPCoreKey("use_asp_tags_as_php");
    private static final Key PREF_SHORT_TAGS = PHPVersionConfigurationBlock.getPHPCoreKey("useShortTags");
    private static HashMap<String, String> phpVersionNames;
    private IStatus fTaskTagsStatus;
    protected ValuedCombo versionCombo;
    protected Button useShortTagsButton;
    protected Button isSupportingASPTagsButton;
    protected Label nameLabel;
    protected PHPVersion minimumVersion = null;
    private boolean hideTagButtons;
    private SelectionListener versionComboListener;

    public PHPVersionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, PHPVersionConfigurationBlock.getKeys(), container);
    }

    public PHPVersionConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, boolean hideTagButtons) {
        this(context, project, container);
        this.hideTagButtons = hideTagButtons;
    }

    public void setMinimumVersion(PHPVersion version) {
        this.minimumVersion = version;
    }

    public void setEnabled(boolean isEnabled) {
        this.versionCombo.setEnabled(isEnabled);
        if (!this.hideTagButtons) {
            this.useShortTagsButton.setEnabled(isEnabled);
            this.isSupportingASPTagsButton.setEnabled(isEnabled);
        }
        this.nameLabel.setEnabled(isEnabled);
    }

    private static Key[] getKeys() {
        return new Key[]{PREF_PHP_VERSION, PREF_ASP_TAGS, PREF_SHORT_TAGS};
    }

    @Override
    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createVersionContent(composite);
        this.unpackPHPVersion();
        if (!this.hideTagButtons) {
            this.createUseShortTagsContent(composite);
            this.unpackUseShortTags();
            this.createIsSupportingASPTagsContent(composite);
            this.unpackIsSupportingASPTags();
        }
        this.validateSettings(null, null, null);
        return composite;
    }

    private void createUseShortTagsContent(Composite composite) {
        this.useShortTagsButton = new Button(composite, 131104);
        this.useShortTagsButton.setText(PHPUIMessages.Preferences_php_editor_useShortTagsAsPhp_label);
        this.useShortTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PHPVersionConfigurationBlock.this.setUseShortTagsValue(Boolean.toString(PHPVersionConfigurationBlock.this.useShortTagsButton.getSelection()));
            }
        });
    }

    private void createIsSupportingASPTagsContent(Composite composite) {
        this.isSupportingASPTagsButton = new Button(composite, 131104);
        this.isSupportingASPTagsButton.setText(PHPUIMessages.Preferences_php_editor_useAspTagsAsPhp_label);
        this.isSupportingASPTagsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PHPVersionConfigurationBlock.this.setIsSupportingASPTagsValue(Boolean.toString(PHPVersionConfigurationBlock.this.isSupportingASPTagsButton.getSelection()));
            }
        });
        this.versionComboListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPVersion version = PHPVersion.byAlias((String)PHPVersionConfigurationBlock.this.versionCombo.getSelectionValue());
                if (version != null && version.isGreaterThan(PHPVersion.PHP5_6)) {
                    PHPVersionConfigurationBlock.this.isSupportingASPTagsButton.setSelection(false);
                    PHPVersionConfigurationBlock.this.isSupportingASPTagsButton.setEnabled(false);
                } else {
                    PHPVersionConfigurationBlock.this.isSupportingASPTagsButton.setEnabled(true);
                }
            }
        };
        this.versionCombo.addSelectionListener(this.versionComboListener);
    }

    private Composite createVersionContent(Composite parent) {
        Composite composite = new Composite(parent, 16);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.nameLabel = new Label(composite, 0);
        this.nameLabel.setText(PHPUIMessages.PHPVersionComboName);
        GC gc = new GC((Drawable)this.nameLabel);
        gc.setFont(this.nameLabel.getFont());
        gc.dispose();
        List<ValuedCombo.Entry> entryList = this.prepareVersionEntryList();
        this.versionCombo = new ValuedCombo(composite, 8, entryList);
        this.versionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = PHPVersionConfigurationBlock.this.versionCombo.getSelectionValue();
                PHPVersionConfigurationBlock.this.setPHPVersionValue(selectedValue);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateSettings(Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        if (changedKey != null) {
            if (PREF_PHP_VERSION.equals(changedKey)) {
                this.fTaskTagsStatus = this.validatePHPVersion();
            } else if (PREF_SHORT_TAGS.equals(changedKey)) {
                this.fTaskTagsStatus = this.validatePHPVersion();
            } else {
                if (!PREF_ASP_TAGS.equals(changedKey)) return;
                this.fTaskTagsStatus = this.validatePHPVersion();
            }
        } else {
            this.fTaskTagsStatus = this.validatePHPVersion();
        }
        this.fContext.statusChanged(this.fTaskTagsStatus);
    }

    private IStatus validatePHPVersion() {
        return new StatusInfo();
    }

    private List<ValuedCombo.Entry> prepareVersionEntryList() {
        ArrayList<ValuedCombo.Entry> entryList = new ArrayList<ValuedCombo.Entry>();
        PHPVersionConfigurationBlock.initPHPVersionNames();
        PHPVersion[] pHPVersionArray = PHPVersion.supportedVersions();
        int n = pHPVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPVersion version = pHPVersionArray[n2];
            if (this.minimumVersion == null || !version.isLessThan(this.minimumVersion)) {
                String description = version.getAlias();
                if (phpVersionNames.containsKey(version.getAlias())) {
                    description = phpVersionNames.get(version.getAlias());
                }
                ValuedCombo.Entry entry = new ValuedCombo.Entry(version.getAlias(), description);
                entryList.add(entry);
            }
            ++n2;
        }
        return entryList;
    }

    private static void initPHPVersionNames() {
        if (phpVersionNames == null) {
            IConfigurationElement[] configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.ui.phpVersionInfo");
            phpVersionNames = new HashMap();
            IConfigurationElement[] iConfigurationElementArray = configurationElementsFor;
            int n = configurationElementsFor.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] list;
                PHPVersion version;
                IConfigurationElement verInfo = iConfigurationElementArray[n2];
                StringBuilder sb = new StringBuilder(verInfo.getAttribute("name"));
                String alias = verInfo.getAttribute("version");
                PHPVersion pHPVersion = version = alias != null ? PHPVersion.byAlias((String)alias) : null;
                if (version != null && version.isExperimentalSupport()) {
                    sb.append(" [EXPERIMENTAL]");
                }
                if ((list = verInfo.getChildren("feature")).length > 0) {
                    sb.append(" (");
                    int length = 0;
                    int f = 0;
                    while (list.length > f) {
                        if (length > 30) break;
                        if (f > 0) {
                            sb.append(", ");
                            length += 2;
                        }
                        String feature = list[f].getAttribute("name");
                        sb.append(feature);
                        length += feature.length();
                        ++f;
                    }
                    sb.append(",...)");
                }
                phpVersionNames.put(verInfo.getAttribute("version"), sb.toString());
                ++n2;
            }
        }
    }

    private void setPHPVersionValue(String value) {
        PHPVersion[] pHPVersionArray = PHPVersion.supportedVersions();
        int n = pHPVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPVersion version = pHPVersionArray[n2];
            if (version.getAlias().equals(value)) {
                this.setValue(PREF_PHP_VERSION, version.getAlias());
                this.validateSettings(PREF_PHP_VERSION, null, null);
                this.versionCombo.selectValue(value);
                return;
            }
            ++n2;
        }
    }

    private void setUseShortTagsValue(String value) {
        this.setValue(PREF_SHORT_TAGS, value);
        this.validateSettings(PREF_SHORT_TAGS, null, null);
    }

    private void setIsSupportingASPTagsValue(String value) {
        this.setValue(PREF_ASP_TAGS, value);
        this.validateSettings(PREF_ASP_TAGS, null, null);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PHPUIMessages.PHPVersionConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? PHPUIMessages.PHPVersionConfigurationBlock_needsfullbuild_message : PHPUIMessages.PHPVersionConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    @Override
    protected void updateControls() {
        this.unpackPHPVersion();
        if (!this.hideTagButtons) {
            this.unpackUseShortTags();
            this.unpackIsSupportingASPTags();
        }
    }

    private void unpackPHPVersion() {
        String currTags = this.getValue(PREF_PHP_VERSION);
        boolean wasValueSelected = this.versionCombo.selectValue(currTags);
        if (!wasValueSelected && !this.versionCombo.getEntryList().isEmpty()) {
            this.setPHPVersionValue(this.versionCombo.getEntryList().get(0).getValue());
        }
    }

    private void unpackUseShortTags() {
        String value = this.getValue(PREF_SHORT_TAGS);
        this.useShortTagsButton.setSelection(Boolean.valueOf(value).booleanValue());
    }

    private void unpackIsSupportingASPTags() {
        String value = this.getValue(PREF_ASP_TAGS);
        this.isSupportingASPTagsButton.setSelection(Boolean.valueOf(value).booleanValue());
        this.versionComboListener.widgetSelected(null);
    }

    public PHPVersion getPHPVersionValue() {
        return PHPVersion.byAlias((String)this.getValue(PREF_PHP_VERSION));
    }

    public boolean getUseShortTagsValue() {
        return this.getBooleanValue(PREF_SHORT_TAGS);
    }

    public boolean getUseAspTagsValue() {
        return this.getBooleanValue(PREF_ASP_TAGS);
    }
}

