/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.encoding;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.json.core.contenttype.ContentTypeIdForJSON;
import org.eclipse.wst.json.core.internal.encoding.JSONDocumentCharsetDetector;
import org.eclipse.wst.json.core.internal.parser.JSONSourceParser;
import org.eclipse.wst.json.core.internal.text.JSONStructuredDocumentReParser;
import org.eclipse.wst.json.core.internal.text.StructuredTextPartitionerForJSON;
import org.eclipse.wst.sse.core.internal.document.AbstractDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredTextReParser;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;

public class JSONDocumentLoader
extends AbstractDocumentLoader {
    private static final String JSON_ID = ContentTypeIdForJSON.ContentTypeID_JSON;
    private IDocumentCharsetDetector documentEncodingDetector;

    protected String getSpecDefaultEncoding() {
        return null;
    }

    protected IEncodedDocument newEncodedDocument() {
        IStructuredDocument structuredDocument = StructuredDocumentFactory.getNewStructuredDocumentInstance((RegionParser)this.getParser());
        if (structuredDocument instanceof BasicStructuredDocument) {
            ((BasicStructuredDocument)structuredDocument).setReParser((IStructuredTextReParser)new JSONStructuredDocumentReParser());
        }
        return structuredDocument;
    }

    public RegionParser getParser() {
        return new JSONSourceParser();
    }

    protected String getPreferredNewLineDelimiter(IFile file) {
        String delimiter = ContentTypeEncodingPreferences.getPreferredNewLineDelimiter((String)JSON_ID);
        if (delimiter == null) {
            delimiter = super.getPreferredNewLineDelimiter(file);
        }
        return delimiter;
    }

    public IDocumentCharsetDetector getDocumentEncodingDetector() {
        if (this.documentEncodingDetector == null) {
            this.documentEncodingDetector = new JSONDocumentCharsetDetector();
        }
        return this.documentEncodingDetector;
    }

    public IDocumentPartitioner getDefaultDocumentPartitioner() {
        return new StructuredTextPartitionerForJSON();
    }

    public IDocumentLoader newInstance() {
        return new JSONDocumentLoader();
    }
}

