/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jem.internal.proxy.initParser.ArrayArguments;
import org.eclipse.jem.internal.proxy.initParser.Expression;

public class MessageArgument
extends Expression {
    protected boolean isComplete = false;
    Expression fExpression;
    ArrayList fExpressionStack = new ArrayList();

    public MessageArgument(Expression anExpression) {
        this.fExpression = anExpression;
    }

    @Override
    public Object evaluate() throws Exception {
        return this.fExpression.evaluate();
    }

    @Override
    public Class getTypeClass() throws Exception {
        return this.fExpression.getTypeClass();
    }

    @Override
    protected String getTypeClassName() {
        return this.fExpression.getTypeClassName();
    }

    @Override
    public boolean isComplete() {
        return this.isComplete || this.fExpression.isComplete();
    }

    @Override
    public Expression push(char[] token, char delimiter) {
        Expression result = this.fExpression.push(token, delimiter);
        if (result != this.fExpression) {
            this.pushExpressionStack(result);
        } else if (result.isComplete()) {
            if (delimiter == ')') {
                this.isComplete = true;
                this.popExpressionStack();
            } else if (delimiter == ',' || delimiter == '\"') {
                this.popExpressionStack();
            } else if (delimiter == '}') {
                this.popExpressionStack();
                if (this.fExpression instanceof ArrayArguments) {
                    this.isComplete = true;
                }
            }
        }
        return this;
    }

    @Override
    protected void popExpressionStack() {
        if (this.fExpressionStack.size() > 0) {
            Expression lastExpression = (Expression)this.fExpressionStack.get(this.fExpressionStack.size() - 1);
            if (!lastExpression.isComplete()) {
                this.fExpression = (Expression)this.fExpressionStack.remove(this.fExpressionStack.size() - 1);
            } else {
                this.isComplete = true;
            }
        } else {
            this.isComplete = true;
        }
    }

    @Override
    protected void pushExpressionStack(Expression anExpression) {
        this.fExpressionStack.add(this.fExpression);
        this.fExpression = anExpression;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Arg(");
        if (this.fExpression != null) {
            writer.write(this.fExpression.toString());
        }
        writer.write(")");
        return writer.toString();
    }

    public void contributeArgumentNumber(List argumentNumberList) {
        if (this.fExpression instanceof ArrayArguments) {
            ((ArrayArguments)this.fExpression).contributeArgumentNumber(argumentNumberList);
        }
    }
}

