/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.progress.UIJob;

public class OpenPropertyPageResolution
implements IMarkerResolution2 {
    private String fPageName = null;
    String fPageId = null;
    IAdaptable fElement = null;

    public OpenPropertyPageResolution(String pagename, String pageid, IAdaptable element) {
        Assert.isNotNull((Object)pagename, (String)MarkerMessages.OpenPropertyPageResolution_the_page_name_cannot_be_null);
        this.fPageName = pagename;
        Assert.isNotNull((Object)pageid, (String)MarkerMessages.OpenPropertyPageResolution_page_id_cannot_be_null);
        this.fPageId = pageid;
        Assert.isNotNull((Object)element, (String)MarkerMessages.OpenPropertyPageResolution_element_cannot_be_null);
        this.fElement = element;
    }

    public String getDescription() {
        return NLS.bind((String)MarkerMessages.OpenPropertyPageResolution_opens_the_property_page, (Object)this.fPageName);
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_OPEN_PAGE");
    }

    public String getLabel() {
        return NLS.bind((String)MarkerMessages.OpenPropertyPageResolution_open_the_property_page, (Object)this.fPageName);
    }

    public void run(IMarker marker) {
        UIJob job = UIJob.create((String)MarkerMessages.OpenPropertyPageResolution_opening_property_page_job_name, monitor -> {
            Shell shell = ApiUIPlugin.getShell();
            SWTFactory.showPropertiesDialog(shell, this.fPageId, this.fElement, null);
        });
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }
}

