/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc000.tc1001;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.tests.reqif10.serialization.uc000.tc1001.TC0001001FullModelModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC0001001FullModelTests
extends AbstractTestCase {
    static final String TEST_CASE_ID = "TC0001001";
    static final String REFERENCE_DATA_FILENAME = TC0001001FullModelTests.getWorkingFileName(TC0001001FullModelTests.getReferenceDataFileName("TC0001001", false));
    static final String EXPORT_DATA_FILENAME = TC0001001FullModelTests.getWorkingFileName(TC0001001FullModelTests.getFirstExportFileName("TC0001001", false));
    static ReqIF originalReqIF = null;
    static ReqIF loadedReqIF = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        originalReqIF = new TC0001001FullModelModelBuilder().getReqIF();
        TC0001001FullModelTests.saveReqIFFile((EObject)originalReqIF, REFERENCE_DATA_FILENAME);
        loadedReqIF = TC0001001FullModelTests.loadReqIFFile(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testReqIFNotNull() {
        Assert.assertNotNull((String)"The loaded ReqIF model shall not be Null", (Object)loadedReqIF);
    }

    @Test
    public void testNoProxies() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedReqIF);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedReqIF);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testResave() throws IOException {
        try {
            TC0001001FullModelTests.saveReqIFFile(EcoreUtil.copy((EObject)loadedReqIF), EXPORT_DATA_FILENAME);
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertFalse((String)("We shall be able to save without exception. However the following exception occurred: " + ioe.toString()), (boolean)true);
        }
    }

    @Test
    public void testReqIF() {
        Assert.assertTrue((boolean)loadedReqIF.isSetCoreContent());
        Assert.assertTrue((boolean)loadedReqIF.isSetLang());
        Assert.assertTrue((boolean)loadedReqIF.isSetTheHeader());
        Assert.assertTrue((boolean)loadedReqIF.isSetToolExtensions());
        Assert.assertNotNull((Object)loadedReqIF.getCoreContent());
        Assert.assertEquals((Object)originalReqIF.getLang(), (Object)loadedReqIF.getLang());
        Assert.assertNotNull((Object)loadedReqIF.getTheHeader());
        Assert.assertEquals((long)originalReqIF.getToolExtensions().size(), (long)loadedReqIF.getToolExtensions().size());
    }

    @Test
    public void testReqIFHeader() {
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetComment());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetCreationTime());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetIdentifier());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetRepositoryId());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetReqIFToolId());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetReqIFVersion());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetSourceToolId());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetTitle());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getComment(), (Object)loadedReqIF.getTheHeader().getComment());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getCreationTime(), (Object)loadedReqIF.getTheHeader().getCreationTime());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getIdentifier(), (Object)loadedReqIF.getTheHeader().getIdentifier());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getRepositoryId(), (Object)loadedReqIF.getTheHeader().getRepositoryId());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getReqIFToolId(), (Object)loadedReqIF.getTheHeader().getReqIFToolId());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getReqIFVersion(), (Object)loadedReqIF.getTheHeader().getReqIFVersion());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getSourceToolId(), (Object)loadedReqIF.getTheHeader().getSourceToolId());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getTitle(), (Object)loadedReqIF.getTheHeader().getTitle());
    }

    @Test
    public void testReqIFContent() {
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetDatatypes());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecifications());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecObjects());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecTypes());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecRelationGroups());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecRelations());
        Assert.assertEquals((long)originalReqIF.getCoreContent().getDatatypes().size(), (long)loadedReqIF.getCoreContent().getDatatypes().size());
        Assert.assertEquals((long)originalReqIF.getCoreContent().getSpecifications().size(), (long)loadedReqIF.getCoreContent().getSpecifications().size());
        Assert.assertEquals((long)originalReqIF.getCoreContent().getSpecObjects().size(), (long)loadedReqIF.getCoreContent().getSpecObjects().size());
        Assert.assertEquals((long)originalReqIF.getCoreContent().getSpecTypes().size(), (long)loadedReqIF.getCoreContent().getSpecTypes().size());
        Assert.assertEquals((long)originalReqIF.getCoreContent().getSpecRelationGroups().size(), (long)loadedReqIF.getCoreContent().getSpecRelationGroups().size());
        Assert.assertEquals((long)originalReqIF.getCoreContent().getSpecRelations().size(), (long)loadedReqIF.getCoreContent().getSpecRelations().size());
    }

    @Test
    public void testReqIFToolExtensions() {
        Assert.assertTrue((boolean)loadedReqIF.isSetToolExtensions());
    }

    @Test
    public void testSpecObjectType() {
        ReqIFContent loadedReqIFContent = loadedReqIF.getCoreContent();
        Assert.assertTrue((boolean)loadedReqIFContent.isSetSpecTypes());
        SpecObjectType loadedSpecObjectType = null;
        for (SpecType specType : loadedReqIFContent.getSpecTypes()) {
            if (!(specType instanceof SpecObjectType)) continue;
            loadedSpecObjectType = (SpecObjectType)specType;
            break;
        }
        Assert.assertNotNull((String)"SpecObjectType must be available", loadedSpecObjectType);
        ReqIFContent originalReqIFContent = loadedReqIF.getCoreContent();
        SpecObjectType originalSpecObjectType = null;
        for (SpecType specType : originalReqIFContent.getSpecTypes()) {
            if (!(specType instanceof SpecObjectType)) continue;
            originalSpecObjectType = (SpecObjectType)specType;
            break;
        }
        Assert.assertTrue((boolean)loadedSpecObjectType.isSetDesc());
        Assert.assertTrue((boolean)loadedSpecObjectType.isSetIdentifier());
        Assert.assertTrue((boolean)loadedSpecObjectType.isSetLastChange());
        Assert.assertTrue((boolean)loadedSpecObjectType.isSetLongName());
        Assert.assertTrue((boolean)loadedSpecObjectType.isSetSpecAttributes());
        Assert.assertEquals((Object)originalSpecObjectType.getDesc(), (Object)loadedSpecObjectType.getDesc());
        Assert.assertEquals((Object)originalSpecObjectType.getIdentifier(), (Object)loadedSpecObjectType.getIdentifier());
        Assert.assertEquals((Object)originalSpecObjectType.getLastChange(), (Object)loadedSpecObjectType.getLastChange());
        Assert.assertEquals((Object)originalSpecObjectType.getLongName(), (Object)loadedSpecObjectType.getLongName());
        Assert.assertEquals((long)originalSpecObjectType.getSpecAttributes().size(), (long)loadedSpecObjectType.getSpecAttributes().size());
    }

    @Test
    public void testSpecObject() {
        ReqIFContent loadedReqIFContent = loadedReqIF.getCoreContent();
        SpecObject loadedSpecObject = (SpecObject)loadedReqIFContent.getSpecObjects().get(0);
        ReqIFContent originalReqIFContent = originalReqIF.getCoreContent();
        SpecObject originalSpecObject = (SpecObject)originalReqIFContent.getSpecObjects().get(0);
        Assert.assertTrue((boolean)loadedSpecObject.isSetDesc());
        Assert.assertTrue((boolean)loadedSpecObject.isSetIdentifier());
        Assert.assertTrue((boolean)loadedSpecObject.isSetLastChange());
        Assert.assertTrue((boolean)loadedSpecObject.isSetLongName());
        Assert.assertTrue((boolean)loadedSpecObject.isSetValues());
        Assert.assertTrue((boolean)loadedSpecObject.isSetType());
        Assert.assertEquals((Object)originalSpecObject.getDesc(), (Object)loadedSpecObject.getDesc());
        Assert.assertEquals((Object)originalSpecObject.getIdentifier(), (Object)loadedSpecObject.getIdentifier());
        Assert.assertEquals((Object)originalSpecObject.getLastChange(), (Object)loadedSpecObject.getLastChange());
        Assert.assertEquals((Object)originalSpecObject.getLongName(), (Object)loadedSpecObject.getLongName());
        SpecObjectType loadedExpectedSpecObjectType = null;
        for (SpecType specType : loadedReqIFContent.getSpecTypes()) {
            if (!(specType instanceof SpecObjectType)) continue;
            loadedExpectedSpecObjectType = (SpecObjectType)specType;
            break;
        }
        Assert.assertEquals((long)6L, (long)loadedSpecObject.getValues().size());
        SpecObjectType specObjectType = loadedSpecObject.getType();
        Assert.assertNotNull((Object)specObjectType);
        Assert.assertFalse((boolean)specObjectType.eIsProxy());
        Assert.assertEquals((Object)loadedExpectedSpecObjectType, (Object)specObjectType);
    }

    @Test
    public void testAttributeValueBoolean() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(0);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueBoolean));
        AttributeValueBoolean attributeValueBoolean = (AttributeValueBoolean)attributeValue;
        Assert.assertTrue((boolean)attributeValueBoolean.isSetTheValue());
        Assert.assertTrue((boolean)attributeValueBoolean.isTheValue());
    }

    @Test
    public void testAttributeValueInteger() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(1);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueInteger));
        AttributeValueInteger attributeValueInteger = (AttributeValueInteger)attributeValue;
        Assert.assertTrue((boolean)attributeValueInteger.isSetTheValue());
        Assert.assertEquals((Object)new BigInteger("5000"), (Object)attributeValueInteger.getTheValue());
    }

    @Test
    public void testAttributeValueString() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(2);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueString));
        AttributeValueString attributeValueString = (AttributeValueString)attributeValue;
        Assert.assertTrue((boolean)attributeValueString.isSetTheValue());
        Assert.assertEquals((Object)"Plain", (Object)attributeValueString.getTheValue());
    }

    @Test
    public void testAttributeValueReal() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(3);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueReal));
        AttributeValueReal attributeValueReal = (AttributeValueReal)attributeValue;
        Assert.assertTrue((boolean)attributeValueReal.isSetTheValue());
        Assert.assertTrue((boolean)new Double(1234.5).equals(attributeValueReal.getTheValue()));
    }

    @Test
    public void testAttributeValueDate() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(4);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueDate));
        AttributeValueDate attributeValueDate = (AttributeValueDate)attributeValue;
        Assert.assertTrue((boolean)attributeValueDate.isSetTheValue());
        Assert.assertEquals((Object)EcoreUtil.createFromString((EDataType)ReqIF10Package.eINSTANCE.getDateTime(), (String)"2002-05-30T09:30:10+06:00"), (Object)attributeValueDate.getTheValue());
    }

    @Test
    public void testAttributeValueEnumeration() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(5);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueEnumeration));
        AttributeValueEnumeration attributeValueEnumerationMultiValue = (AttributeValueEnumeration)attributeValue;
        Assert.assertTrue((boolean)attributeValueEnumerationMultiValue.isSetValues());
        Assert.assertEquals((long)3L, (long)attributeValueEnumerationMultiValue.getValues().size());
        Assert.assertEquals((Object)"TC0001001 Yellow", (Object)((EnumValue)attributeValueEnumerationMultiValue.getValues().get(0)).getLongName());
        Assert.assertEquals((Object)"TC0001001 Red", (Object)((EnumValue)attributeValueEnumerationMultiValue.getValues().get(1)).getLongName());
        Assert.assertEquals((Object)"TC0001001 Green", (Object)((EnumValue)attributeValueEnumerationMultiValue.getValues().get(2)).getLongName());
    }

    @Test
    public void testAttributeDefinitionBoolean() {
        SpecType loadedSpecType = (SpecType)loadedReqIF.getCoreContent().getSpecTypes().get(0);
        Assert.assertTrue((boolean)(loadedSpecType instanceof SpecObjectType));
        SpecObjectType loadedSpecObjectType = (SpecObjectType)loadedSpecType;
        AttributeDefinition loadedAttributeDefinition = (AttributeDefinition)loadedSpecObjectType.getSpecAttributes().get(0);
        Assert.assertTrue((boolean)(loadedAttributeDefinition instanceof AttributeDefinitionBoolean));
        AttributeDefinitionBoolean loadedAttributeDefinitionBoolean = (AttributeDefinitionBoolean)loadedAttributeDefinition;
        AttributeDefinitionBoolean originalAttributeDefinitionBoolean = (AttributeDefinitionBoolean)((SpecType)originalReqIF.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(0);
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetDefaultValue());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetDesc());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetEditable());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetIdentifier());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetLastChange());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetLongName());
        Assert.assertTrue((boolean)loadedAttributeDefinitionBoolean.isSetType());
        Assert.assertNotNull((Object)loadedAttributeDefinitionBoolean.getAlternativeID());
        Assert.assertNotNull((Object)loadedAttributeDefinitionBoolean.getDefaultValue());
        Assert.assertEquals((Object)originalAttributeDefinitionBoolean.getDesc(), (Object)loadedAttributeDefinitionBoolean.getDesc());
        Assert.assertEquals((Object)originalAttributeDefinitionBoolean.isEditable(), (Object)loadedAttributeDefinitionBoolean.isEditable());
        Assert.assertEquals((Object)originalAttributeDefinitionBoolean.getIdentifier(), (Object)loadedAttributeDefinitionBoolean.getIdentifier());
        Assert.assertEquals((Object)originalAttributeDefinitionBoolean.getLastChange(), (Object)loadedAttributeDefinitionBoolean.getLastChange());
        Assert.assertEquals((Object)originalAttributeDefinitionBoolean.getLongName(), (Object)loadedAttributeDefinitionBoolean.getLongName());
    }

    @Test
    public void testAttributeDefinitionInteger() {
        SpecType loadedSpecType = (SpecType)loadedReqIF.getCoreContent().getSpecTypes().get(0);
        Assert.assertTrue((boolean)(loadedSpecType instanceof SpecObjectType));
        SpecObjectType loadedSpecObjectType = (SpecObjectType)loadedSpecType;
        AttributeDefinition loadedAttributeDefinition = (AttributeDefinition)loadedSpecObjectType.getSpecAttributes().get(1);
        Assert.assertTrue((boolean)(loadedAttributeDefinition instanceof AttributeDefinitionInteger));
        AttributeDefinitionInteger loadedAttributeDefinitionInteger = (AttributeDefinitionInteger)loadedAttributeDefinition;
        AttributeDefinitionInteger originalAttributeDefinitionInteger = (AttributeDefinitionInteger)((SpecType)originalReqIF.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(1);
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetDefaultValue());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetDesc());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetEditable());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetIdentifier());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetLastChange());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetLongName());
        Assert.assertTrue((boolean)loadedAttributeDefinitionInteger.isSetType());
        Assert.assertNotNull((Object)loadedAttributeDefinitionInteger.getAlternativeID());
        Assert.assertNotNull((Object)loadedAttributeDefinitionInteger.getDefaultValue());
        Assert.assertEquals((Object)originalAttributeDefinitionInteger.getDesc(), (Object)loadedAttributeDefinitionInteger.getDesc());
        Assert.assertEquals((Object)originalAttributeDefinitionInteger.isEditable(), (Object)loadedAttributeDefinitionInteger.isEditable());
        Assert.assertEquals((Object)originalAttributeDefinitionInteger.getIdentifier(), (Object)loadedAttributeDefinitionInteger.getIdentifier());
        Assert.assertEquals((Object)originalAttributeDefinitionInteger.getLastChange(), (Object)loadedAttributeDefinitionInteger.getLastChange());
        Assert.assertEquals((Object)originalAttributeDefinitionInteger.getLongName(), (Object)loadedAttributeDefinitionInteger.getLongName());
    }

    @Test
    public void testAttributeDefinitionString() {
        SpecType loadedSpecType = (SpecType)loadedReqIF.getCoreContent().getSpecTypes().get(0);
        Assert.assertTrue((boolean)(loadedSpecType instanceof SpecObjectType));
        SpecObjectType loadedSpecObjectType = (SpecObjectType)loadedSpecType;
        AttributeDefinition loadedAttributeDefinition = (AttributeDefinition)loadedSpecObjectType.getSpecAttributes().get(2);
        Assert.assertTrue((boolean)(loadedAttributeDefinition instanceof AttributeDefinitionString));
        AttributeDefinitionString loadedAttributeDefinitionString = (AttributeDefinitionString)loadedAttributeDefinition;
        AttributeDefinitionString originalAttributeDefinitionString = (AttributeDefinitionString)((SpecType)originalReqIF.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(2);
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetDefaultValue());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetDesc());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetEditable());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetIdentifier());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetLastChange());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetLongName());
        Assert.assertTrue((boolean)loadedAttributeDefinitionString.isSetType());
        Assert.assertNotNull((Object)loadedAttributeDefinitionString.getAlternativeID());
        Assert.assertNotNull((Object)loadedAttributeDefinitionString.getDefaultValue());
        Assert.assertEquals((Object)originalAttributeDefinitionString.getDesc(), (Object)loadedAttributeDefinitionString.getDesc());
        Assert.assertEquals((Object)originalAttributeDefinitionString.isEditable(), (Object)loadedAttributeDefinitionString.isEditable());
        Assert.assertEquals((Object)originalAttributeDefinitionString.getIdentifier(), (Object)loadedAttributeDefinitionString.getIdentifier());
        Assert.assertEquals((Object)originalAttributeDefinitionString.getLastChange(), (Object)loadedAttributeDefinitionString.getLastChange());
        Assert.assertEquals((Object)originalAttributeDefinitionString.getLongName(), (Object)loadedAttributeDefinitionString.getLongName());
    }

    @Test
    public void testAttributeDefinitionReal() {
        SpecType loadedSpecType = (SpecType)loadedReqIF.getCoreContent().getSpecTypes().get(0);
        Assert.assertTrue((boolean)(loadedSpecType instanceof SpecObjectType));
        SpecObjectType loadedSpecObjectType = (SpecObjectType)loadedSpecType;
        AttributeDefinition loadedAttributeDefinition = (AttributeDefinition)loadedSpecObjectType.getSpecAttributes().get(3);
        Assert.assertTrue((boolean)(loadedAttributeDefinition instanceof AttributeDefinitionReal));
        AttributeDefinitionReal loadedAttributeDefinitionReal = (AttributeDefinitionReal)loadedAttributeDefinition;
        AttributeDefinitionReal originalAttributeDefinitionReal = (AttributeDefinitionReal)((SpecType)originalReqIF.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(3);
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetDefaultValue());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetDesc());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetEditable());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetIdentifier());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetLastChange());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetLongName());
        Assert.assertTrue((boolean)loadedAttributeDefinitionReal.isSetType());
        Assert.assertNotNull((Object)loadedAttributeDefinitionReal.getAlternativeID());
        Assert.assertNotNull((Object)loadedAttributeDefinitionReal.getDefaultValue());
        Assert.assertEquals((Object)originalAttributeDefinitionReal.getDesc(), (Object)loadedAttributeDefinitionReal.getDesc());
        Assert.assertEquals((Object)originalAttributeDefinitionReal.isEditable(), (Object)loadedAttributeDefinitionReal.isEditable());
        Assert.assertEquals((Object)originalAttributeDefinitionReal.getIdentifier(), (Object)loadedAttributeDefinitionReal.getIdentifier());
        Assert.assertEquals((Object)originalAttributeDefinitionReal.getLastChange(), (Object)loadedAttributeDefinitionReal.getLastChange());
        Assert.assertEquals((Object)originalAttributeDefinitionReal.getLongName(), (Object)loadedAttributeDefinitionReal.getLongName());
    }

    @Test
    public void testAttributeDefinitionDate() {
        SpecType loadedSpecType = (SpecType)loadedReqIF.getCoreContent().getSpecTypes().get(0);
        Assert.assertTrue((boolean)(loadedSpecType instanceof SpecObjectType));
        SpecObjectType loadedSpecObjectType = (SpecObjectType)loadedSpecType;
        AttributeDefinition loadedAttributeDefinition = (AttributeDefinition)loadedSpecObjectType.getSpecAttributes().get(4);
        Assert.assertTrue((boolean)(loadedAttributeDefinition instanceof AttributeDefinitionDate));
        AttributeDefinitionDate loadedAttributeDefinitionDate = (AttributeDefinitionDate)loadedAttributeDefinition;
        AttributeDefinitionDate originalAttributeDefinitionDate = (AttributeDefinitionDate)((SpecType)originalReqIF.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(4);
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetDefaultValue());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetDesc());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetEditable());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetIdentifier());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetLastChange());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetLongName());
        Assert.assertTrue((boolean)loadedAttributeDefinitionDate.isSetType());
        Assert.assertNotNull((Object)loadedAttributeDefinitionDate.getAlternativeID());
        Assert.assertNotNull((Object)loadedAttributeDefinitionDate.getDefaultValue());
        Assert.assertEquals((Object)originalAttributeDefinitionDate.getDesc(), (Object)loadedAttributeDefinitionDate.getDesc());
        Assert.assertEquals((Object)originalAttributeDefinitionDate.isEditable(), (Object)loadedAttributeDefinitionDate.isEditable());
        Assert.assertEquals((Object)originalAttributeDefinitionDate.getIdentifier(), (Object)loadedAttributeDefinitionDate.getIdentifier());
        Assert.assertEquals((Object)originalAttributeDefinitionDate.getLastChange(), (Object)loadedAttributeDefinitionDate.getLastChange());
        Assert.assertEquals((Object)originalAttributeDefinitionDate.getLongName(), (Object)loadedAttributeDefinitionDate.getLongName());
    }

    @Test
    public void testAttributeDefinitionEnumeration() {
        SpecType loadedSpecType = (SpecType)loadedReqIF.getCoreContent().getSpecTypes().get(0);
        Assert.assertTrue((boolean)(loadedSpecType instanceof SpecObjectType));
        SpecObjectType loadedSpecObjectType = (SpecObjectType)loadedSpecType;
        AttributeDefinition loadedAttributeDefinition = (AttributeDefinition)loadedSpecObjectType.getSpecAttributes().get(5);
        Assert.assertTrue((boolean)(loadedAttributeDefinition instanceof AttributeDefinitionEnumeration));
        AttributeDefinitionEnumeration loadedAttributeDefinitionEnumeration = (AttributeDefinitionEnumeration)loadedAttributeDefinition;
        AttributeDefinitionEnumeration originalAttributeDefinitionEnumeration = (AttributeDefinitionEnumeration)((SpecType)originalReqIF.getCoreContent().getSpecTypes().get(0)).getSpecAttributes().get(5);
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetDefaultValue());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetDesc());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetEditable());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetIdentifier());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetLastChange());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetLongName());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetMultiValued());
        Assert.assertTrue((boolean)loadedAttributeDefinitionEnumeration.isSetType());
        Assert.assertNotNull((Object)loadedAttributeDefinitionEnumeration.getAlternativeID());
        Assert.assertNotNull((Object)loadedAttributeDefinitionEnumeration.getDefaultValue());
        Assert.assertEquals((Object)originalAttributeDefinitionEnumeration.getDesc(), (Object)loadedAttributeDefinitionEnumeration.getDesc());
        Assert.assertEquals((Object)originalAttributeDefinitionEnumeration.isEditable(), (Object)loadedAttributeDefinitionEnumeration.isEditable());
        Assert.assertEquals((Object)originalAttributeDefinitionEnumeration.getIdentifier(), (Object)loadedAttributeDefinitionEnumeration.getIdentifier());
        Assert.assertEquals((Object)originalAttributeDefinitionEnumeration.getLastChange(), (Object)loadedAttributeDefinitionEnumeration.getLastChange());
        Assert.assertEquals((Object)originalAttributeDefinitionEnumeration.getLongName(), (Object)loadedAttributeDefinitionEnumeration.getLongName());
        Assert.assertEquals((Object)originalAttributeDefinitionEnumeration.isMultiValued(), (Object)loadedAttributeDefinitionEnumeration.isMultiValued());
    }

    @Test
    public void testDatatypeBoolean() {
        DatatypeDefinition loadedDatatypeDefinition = (DatatypeDefinition)loadedReqIF.getCoreContent().getDatatypes().get(0);
        Assert.assertTrue((boolean)(loadedDatatypeDefinition instanceof DatatypeDefinitionBoolean));
        DatatypeDefinitionBoolean loadedDatatypeDefinitionBoolean = (DatatypeDefinitionBoolean)loadedDatatypeDefinition;
        DatatypeDefinitionBoolean originalDatatypeDefinitionBoolean = (DatatypeDefinitionBoolean)originalReqIF.getCoreContent().getDatatypes().get(0);
        Assert.assertTrue((boolean)loadedDatatypeDefinitionBoolean.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionBoolean.isSetDesc());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionBoolean.isSetIdentifier());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionBoolean.isSetLastChange());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionBoolean.isSetLongName());
        Assert.assertNotNull((Object)loadedDatatypeDefinitionBoolean.getAlternativeID());
        Assert.assertEquals((Object)originalDatatypeDefinitionBoolean.getDesc(), (Object)loadedDatatypeDefinitionBoolean.getDesc());
        Assert.assertEquals((Object)originalDatatypeDefinitionBoolean.getIdentifier(), (Object)loadedDatatypeDefinitionBoolean.getIdentifier());
        Assert.assertEquals((Object)originalDatatypeDefinitionBoolean.getLastChange(), (Object)loadedDatatypeDefinitionBoolean.getLastChange());
        Assert.assertEquals((Object)originalDatatypeDefinitionBoolean.getLongName(), (Object)loadedDatatypeDefinitionBoolean.getLongName());
    }

    @Test
    public void testDatatypeInteger() {
        DatatypeDefinition loadedDatatypeDefinition = (DatatypeDefinition)loadedReqIF.getCoreContent().getDatatypes().get(1);
        Assert.assertTrue((boolean)(loadedDatatypeDefinition instanceof DatatypeDefinitionInteger));
        DatatypeDefinitionInteger loadedDatatypeDefinitionInteger = (DatatypeDefinitionInteger)loadedDatatypeDefinition;
        DatatypeDefinitionInteger originalDatatypeDefinitionInteger = (DatatypeDefinitionInteger)originalReqIF.getCoreContent().getDatatypes().get(1);
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetDesc());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetIdentifier());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetLastChange());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetLongName());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetMax());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionInteger.isSetMin());
        Assert.assertNotNull((Object)loadedDatatypeDefinitionInteger.getAlternativeID());
        Assert.assertEquals((Object)originalDatatypeDefinitionInteger.getDesc(), (Object)loadedDatatypeDefinitionInteger.getDesc());
        Assert.assertEquals((Object)originalDatatypeDefinitionInteger.getIdentifier(), (Object)loadedDatatypeDefinitionInteger.getIdentifier());
        Assert.assertEquals((Object)originalDatatypeDefinitionInteger.getLastChange(), (Object)loadedDatatypeDefinitionInteger.getLastChange());
        Assert.assertEquals((Object)originalDatatypeDefinitionInteger.getLongName(), (Object)loadedDatatypeDefinitionInteger.getLongName());
        Assert.assertEquals((Object)originalDatatypeDefinitionInteger.getMax(), (Object)loadedDatatypeDefinitionInteger.getMax());
        Assert.assertEquals((Object)originalDatatypeDefinitionInteger.getMin(), (Object)loadedDatatypeDefinitionInteger.getMin());
    }

    @Test
    public void testDatatypeString() {
        DatatypeDefinition loadedDatatypeDefinition = (DatatypeDefinition)loadedReqIF.getCoreContent().getDatatypes().get(2);
        Assert.assertTrue((boolean)(loadedDatatypeDefinition instanceof DatatypeDefinitionString));
        DatatypeDefinitionString loadedDatatypeDefinitionString = (DatatypeDefinitionString)loadedDatatypeDefinition;
        DatatypeDefinitionString originalDatatypeDefinitionString = (DatatypeDefinitionString)originalReqIF.getCoreContent().getDatatypes().get(2);
        Assert.assertTrue((boolean)loadedDatatypeDefinitionString.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionString.isSetDesc());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionString.isSetIdentifier());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionString.isSetLastChange());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionString.isSetLongName());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionString.isSetMaxLength());
        Assert.assertNotNull((Object)loadedDatatypeDefinitionString.getAlternativeID());
        Assert.assertEquals((Object)originalDatatypeDefinitionString.getDesc(), (Object)loadedDatatypeDefinitionString.getDesc());
        Assert.assertEquals((Object)originalDatatypeDefinitionString.getIdentifier(), (Object)loadedDatatypeDefinitionString.getIdentifier());
        Assert.assertEquals((Object)originalDatatypeDefinitionString.getLastChange(), (Object)loadedDatatypeDefinitionString.getLastChange());
        Assert.assertEquals((Object)originalDatatypeDefinitionString.getLongName(), (Object)loadedDatatypeDefinitionString.getLongName());
        Assert.assertEquals((Object)originalDatatypeDefinitionString.getMaxLength(), (Object)loadedDatatypeDefinitionString.getMaxLength());
    }

    @Test
    public void testDatatypeReal() {
        DatatypeDefinition loadedDatatypeDefinition = (DatatypeDefinition)loadedReqIF.getCoreContent().getDatatypes().get(3);
        Assert.assertTrue((boolean)(loadedDatatypeDefinition instanceof DatatypeDefinitionReal));
        DatatypeDefinitionReal loadedDatatypeDefinitionReal = (DatatypeDefinitionReal)loadedDatatypeDefinition;
        DatatypeDefinitionReal originalDatatypeDefinitionReal = (DatatypeDefinitionReal)originalReqIF.getCoreContent().getDatatypes().get(3);
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetDesc());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetIdentifier());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetLastChange());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetLongName());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetAccuracy());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetMax());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionReal.isSetMin());
        Assert.assertNotNull((Object)loadedDatatypeDefinitionReal.getAlternativeID());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getDesc(), (Object)loadedDatatypeDefinitionReal.getDesc());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getIdentifier(), (Object)loadedDatatypeDefinitionReal.getIdentifier());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getLastChange(), (Object)loadedDatatypeDefinitionReal.getLastChange());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getLongName(), (Object)loadedDatatypeDefinitionReal.getLongName());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getAccuracy(), (Object)loadedDatatypeDefinitionReal.getAccuracy());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getMax(), (Object)loadedDatatypeDefinitionReal.getMax());
        Assert.assertEquals((Object)originalDatatypeDefinitionReal.getMin(), (Object)loadedDatatypeDefinitionReal.getMin());
    }

    @Test
    public void testDatatypeDate() {
        DatatypeDefinition loadedDatatypeDefinition = (DatatypeDefinition)loadedReqIF.getCoreContent().getDatatypes().get(4);
        Assert.assertTrue((boolean)(loadedDatatypeDefinition instanceof DatatypeDefinitionDate));
        DatatypeDefinitionDate loadedDatatypeDefinitionDate = (DatatypeDefinitionDate)loadedDatatypeDefinition;
        DatatypeDefinitionDate originalDatatypeDefinitionDate = (DatatypeDefinitionDate)originalReqIF.getCoreContent().getDatatypes().get(4);
        Assert.assertTrue((boolean)loadedDatatypeDefinitionDate.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionDate.isSetDesc());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionDate.isSetIdentifier());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionDate.isSetLastChange());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionDate.isSetLongName());
        Assert.assertNotNull((Object)loadedDatatypeDefinitionDate.getAlternativeID());
        Assert.assertEquals((Object)originalDatatypeDefinitionDate.getDesc(), (Object)loadedDatatypeDefinitionDate.getDesc());
        Assert.assertEquals((Object)originalDatatypeDefinitionDate.getIdentifier(), (Object)loadedDatatypeDefinitionDate.getIdentifier());
        Assert.assertEquals((Object)originalDatatypeDefinitionDate.getLastChange(), (Object)loadedDatatypeDefinitionDate.getLastChange());
        Assert.assertEquals((Object)originalDatatypeDefinitionDate.getLongName(), (Object)loadedDatatypeDefinitionDate.getLongName());
    }

    @Test
    public void testDatatypeEnumeration() {
        DatatypeDefinition loadedDatatypeDefinition = (DatatypeDefinition)loadedReqIF.getCoreContent().getDatatypes().get(5);
        Assert.assertTrue((boolean)(loadedDatatypeDefinition instanceof DatatypeDefinitionEnumeration));
        DatatypeDefinitionEnumeration loadedDatatypeDefinitionEnumeration = (DatatypeDefinitionEnumeration)loadedDatatypeDefinition;
        DatatypeDefinitionEnumeration originalDatatypeDefinitionEnumeration = (DatatypeDefinitionEnumeration)originalReqIF.getCoreContent().getDatatypes().get(5);
        Assert.assertTrue((boolean)loadedDatatypeDefinitionEnumeration.isSetAlternativeID());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionEnumeration.isSetDesc());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionEnumeration.isSetIdentifier());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionEnumeration.isSetLastChange());
        Assert.assertTrue((boolean)loadedDatatypeDefinitionEnumeration.isSetLongName());
        Assert.assertNotNull((Object)loadedDatatypeDefinitionEnumeration.getAlternativeID());
        Assert.assertEquals((Object)originalDatatypeDefinitionEnumeration.getDesc(), (Object)loadedDatatypeDefinitionEnumeration.getDesc());
        Assert.assertEquals((Object)originalDatatypeDefinitionEnumeration.getIdentifier(), (Object)loadedDatatypeDefinitionEnumeration.getIdentifier());
        Assert.assertEquals((Object)originalDatatypeDefinitionEnumeration.getLastChange(), (Object)loadedDatatypeDefinitionEnumeration.getLastChange());
        Assert.assertEquals((Object)originalDatatypeDefinitionEnumeration.getLongName(), (Object)loadedDatatypeDefinitionEnumeration.getLongName());
    }
}

