/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.r_osgi;

import ch.ethz.iks.r_osgi.RemoteOSGiService;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.ContainerInstantiatorUtils;
import org.eclipse.ecf.core.provider.ContainerIntentException;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.core.provider.IRemoteServiceContainerInstantiator;
import org.eclipse.ecf.internal.provider.r_osgi.Activator;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiRemoteServiceContainer;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiWSRemoteServiceContainer;
import org.eclipse.ecf.internal.provider.r_osgi.R_OSGiWSSRemoteServiceContainer;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiID;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSSNamespace;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;

public final class R_OSGiContainerInstantiator
implements IContainerInstantiator,
IRemoteServiceContainerInstantiator {
    public static final String[] r_OSGiIntents = new String[]{"osgi.basic", "osgi.async", "osgi.private", "passByValue", "exactlyOnce", "ordered"};
    public static final String ID_PROP = "id";
    private static final String WS_PROTOCOL = "http";
    private static final String WSS_PROTOCOL = "https";
    private static final int WS_DEFAULT_PORT = 80;
    private static final int WSS_DEFAULT_PORT = 443;
    final boolean useHostname = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.r_osgi.useHostName", "true"));
    private static final String ROSGI_CONFIG = "ecf.r_osgi.peer";
    private static final String ROSGI_WEBSOCKETS_CONFIG = "ecf.r_osgi.peer.ws";
    private static final String ROSGI_WEBSOCKETSS_CONFIG = "ecf.r_osgi.peer.wss";
    public static final String NAME = "ecf.r_osgi.peer";
    public static final String NAME_HTTP = "ecf.r_osgi.peer.ws";
    public static final String NAME_HTTPS = "ecf.r_osgi.peer.wss";

    public static R_OSGiID createR_OSGiID(Namespace namespace, String uriStr) {
        return (R_OSGiID)IDFactory.getDefault().createID(namespace, uriStr);
    }

    /*
     * Unable to fully structure code
     */
    private R_OSGiID createROSGiID(ContainerTypeDescription description, Map properties) throws ContainerCreateException {
        idStr = null;
        if (properties != null) {
            idStr = (String)properties.get("id");
        }
        hostname = null;
        if (idStr != null) {
            try {
                uri = new URI(idStr);
                hostname = uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new ContainerCreateException("Invalid syntax for R_OSGI id=" + idStr, (Throwable)e);
            }
        }
        privateIntent = ContainerInstantiatorUtils.containsPrivateIntent((Map)properties);
        hostAddress = null;
        if (hostname == null || "".equals(hostname) || "localhost".equals(hostname)) {
            hostname = "localhost";
            try {
                hostAddress = InetAddress.getLocalHost();
                if (!this.useHostname) ** GOTO lbl30
                hostname = hostAddress.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                if (!privateIntent) ** GOTO lbl30
                throw new ContainerIntentException("osgi.private", "Cannot get localhost address for private ROSGI container", (Throwable)e);
            }
        } else if ("127.0.0.1".equals(hostname) && privateIntent) {
            try {
                hostAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new ContainerIntentException("osgi.private", "Cannot get localhost address for private ROSGI container", (Throwable)e);
            }
        }
lbl30:
        // 6 sources

        if (privateIntent) {
            if (hostAddress == null) {
                try {
                    hostAddress = InetAddress.getByName(hostname);
                }
                catch (UnknownHostException e) {
                    throw new ContainerIntentException("osgi.private", "Cannot get inetaddress for ROSGI container with hostname '" + hostname + "'", (Throwable)e);
                }
            }
            ContainerInstantiatorUtils.checkPrivate((InetAddress)hostAddress);
        }
        descriptionName = description.getName();
        wss = descriptionName.equals("ecf.r_osgi.peer.wss");
        v0 = ws = descriptionName.equals("ecf.r_osgi.peer.ws") != false || wss != false;
        ns = wss != false ? R_OSGiWSSNamespace.getDefault() : (ws != false ? R_OSGiWSNamespace.getDefault() : R_OSGiNamespace.getDefault());
        nsScheme = ns.getScheme();
        wsProtocol = wss != false ? "https" : (ws != false ? "http" : null);
        remoteOSGiService = Activator.getDefault().getRemoteOSGiService();
        listeningPort = remoteOSGiService.getListeningPort(wsProtocol != null ? wsProtocol : nsScheme);
        idPort = -1;
        if ("https".equals(wsProtocol) && listeningPort != 443) {
            idPort = listeningPort;
        } else if ("http".equals(wsProtocol) && listeningPort != 80) {
            idPort = listeningPort;
        }
        portStr = idPort > 0 ? ":" + idPort : "";
        return R_OSGiContainerInstantiator.createR_OSGiID(ns, new String(String.valueOf(nsScheme) + "://" + hostname + portStr));
    }

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        try {
            boolean ws;
            String descriptionName = description.getName();
            boolean wss = descriptionName.equals("ecf.r_osgi.peer.wss");
            boolean bl = ws = descriptionName.equals("ecf.r_osgi.peer.ws") || wss;
            Namespace ns = wss ? R_OSGiWSSNamespace.getDefault() : (ws ? R_OSGiWSNamespace.getDefault() : R_OSGiNamespace.getDefault());
            R_OSGiID containerID = null;
            if (parameters == null) {
                containerID = this.createROSGiID(description, null);
            } else if (parameters.length >= 1) {
                if (parameters[0] instanceof Map) {
                    containerID = this.createROSGiID(description, (Map)parameters[0]);
                } else if (parameters[0] instanceof ID) {
                    containerID = (ID)parameters[0];
                } else if (parameters[0] instanceof String) {
                    containerID = R_OSGiContainerInstantiator.createR_OSGiID(ns, (String)parameters[0]);
                }
            }
            if (containerID == null) {
                throw new ContainerCreateException("Unsupported arguments " + Arrays.asList(parameters));
            }
            RemoteOSGiService remoteOSGiService = Activator.getDefault().getRemoteOSGiService();
            if (wss) {
                return new R_OSGiWSSRemoteServiceContainer(remoteOSGiService, (ID)containerID);
            }
            if (ws) {
                return new R_OSGiWSRemoteServiceContainer(remoteOSGiService, (ID)containerID);
            }
            return new R_OSGiRemoteServiceContainer(remoteOSGiService, (ID)containerID);
        }
        catch (ContainerCreateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerCreateException("Could not create ROSGI Container instance", (Throwable)e);
        }
    }

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        return new String[]{IRemoteServiceContainerAdapter.class.getName(), IContainer.class.getName()};
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        return new Class[][]{new Class[0], {ID.class}};
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        ArrayList<String> intents = new ArrayList<String>(Arrays.asList(r_OSGiIntents));
        if (description.getName().equals("ecf.r_osgi.peer.wss")) {
            intents.add("osgi.confidential");
        }
        return intents.toArray(new String[intents.size()]);
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        return new String[]{description.getName()};
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < exporterSupportedConfigs.length) {
            if (exporterSupportedConfigs[i].equals("ecf.r_osgi.peer")) {
                results.add("ecf.r_osgi.peer");
            }
            if (exporterSupportedConfigs[i].equals("ecf.r_osgi.peer.ws")) {
                results.add("ecf.r_osgi.peer.ws");
            }
            if (exporterSupportedConfigs[i].equals("ecf.r_osgi.peer.wss")) {
                results.add("ecf.r_osgi.peer.wss");
            }
            ++i;
        }
        return results.size() == 0 ? null : results.toArray(new String[results.size()]);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return null;
    }
}

