/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.client;

import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceCallPolicy;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.RemoteServiceID;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameterSerializer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistry;
import org.eclipse.ecf.remoteservice.client.StringParameterSerializer;
import org.eclipse.ecf.remoteservice.rest.client.XMLRemoteResponseDeserializer;
import org.eclipse.ecf.remoteservice.rest.identity.RestID;
import org.eclipse.ecf.remoteservice.util.RemoteFilterImpl;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractRestClientContainer
extends AbstractClientContainer {
    public static final String SLASH = "/";

    public AbstractRestClientContainer(RestID containerID) {
        super((ID)containerID);
        this.setParameterSerializer((IRemoteCallParameterSerializer)new StringParameterSerializer());
        this.setResponseDeserializer(new XMLRemoteResponseDeserializer());
    }

    public boolean setRemoteServiceCallPolicy(IRemoteServiceCallPolicy policy) {
        return false;
    }

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName("ecf.rest.namespace");
    }

    protected abstract IRemoteService createRemoteService(RemoteServiceClientRegistration var1);

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, ID[] idFilter, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return super.getRemoteServiceReferences(this.transformTarget(target, filter), idFilter, clazz, filter);
    }

    public IRemoteServiceReference[] getRemoteServiceReferences(ID target, String clazz, String filter) throws InvalidSyntaxException, ContainerConnectException {
        return super.getRemoteServiceReferences(this.transformTarget(target, filter), clazz, filter);
    }

    protected ID transformTarget(ID originalTarget, String filter) throws InvalidSyntaxException {
        if (originalTarget != null && filter != null && originalTarget instanceof RestID) {
            ((RestID)originalTarget).setRsId(new RemoteFilterImpl(filter).getRsId());
        }
        return originalTarget;
    }

    protected String prepareBaseUri(IRemoteCall call, IRemoteCallable callable) {
        String baseUri = ((RestID)this.getRemoteCallTargetID()).toURI().toString();
        while (baseUri.endsWith(SLASH)) {
            baseUri = baseUri.substring(0, baseUri.length() - 1);
        }
        baseUri = this.substituteParameters(baseUri, call.getParameters());
        return baseUri;
    }

    /*
     * Unable to fully structure code
     */
    protected String prepareResourcePath(IRemoteCall call, IRemoteCallable callable) {
        path = callable.getResourcePath();
        if (path != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            path = path.substring(1);
lbl5:
            // 2 sources

            ** while (path.startsWith((String)"/"))
        }
lbl6:
        // 1 sources

        path = this.substituteParameters(path, call.getParameters());
        return path;
    }

    protected String substituteParameters(String path, Object[] parameters) {
        return MessageFormat.format(path, parameters);
    }

    public String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        String baseUri = this.prepareBaseUri(call, callable);
        if (baseUri == null) {
            return baseUri;
        }
        String resourcePath = this.prepareResourcePath(call, callable);
        if (resourcePath == null) {
            return null;
        }
        return baseUri + SLASH + resourcePath;
    }

    protected RemoteServiceClientRegistration createRestServiceRegistration(String[] clazzes, IRemoteCallable[][] callables, Dictionary properties) {
        return new RestRemoteServiceClientRegistration(this.getRemoteServiceNamespace(), clazzes, callables, properties, this.registry);
    }

    protected RemoteServiceClientRegistration createRestServiceRegistration(IRemoteCallable[] callables, Dictionary properties) {
        return new RestRemoteServiceClientRegistration(this.getRemoteServiceNamespace(), callables, properties, this.registry);
    }

    protected class RestRemoteServiceClientRegistration
    extends RemoteServiceClientRegistration {
        public RestRemoteServiceClientRegistration(Namespace namespace, IRemoteCallable[] restCalls, Dictionary properties, RemoteServiceClientRegistry registry) {
            super(namespace, restCalls, properties, registry);
            ID cID = AbstractRestClientContainer.this.getConnectedID();
            if (cID != null) {
                this.containerId = cID;
            }
            long rsId = ((RestID)this.containerId).getRsId();
            this.serviceID = new RemoteServiceID(namespace, this.containerId, rsId);
            if (rsId > 0L) {
                if (this.properties == null) {
                    this.properties = new Hashtable();
                }
                this.properties.put("ecf.rsvc.id", new Long(rsId));
            }
        }

        public RestRemoteServiceClientRegistration(Namespace namespace, String[] classNames, IRemoteCallable[][] restCalls, Dictionary properties, RemoteServiceClientRegistry registry) {
            super(namespace, classNames, restCalls, properties, registry);
            ID cID = AbstractRestClientContainer.this.getConnectedID();
            if (cID != null) {
                this.containerId = cID;
            }
            long rsId = ((RestID)this.containerId).getRsId();
            this.serviceID = new RemoteServiceID(namespace, this.containerId, rsId);
            if (rsId > 0L) {
                if (this.properties == null) {
                    this.properties = new Hashtable();
                }
                this.properties.put("ecf.rsvc.id", new Long(rsId));
            }
        }
    }
}

