/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private Thread writerThread;
    private Writer writer;
    private XMPPConnection connection;
    private final BlockingQueue<Packet> queue = new ArrayBlockingQueue<Packet>(500, true);
    volatile boolean done;

    protected PacketWriter(XMPPConnection connection) {
        this.connection = connection;
        this.init();
    }

    protected void init() {
        this.writer = this.connection.writer;
        this.done = false;
        this.writerThread = new Thread(){

            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.connectionCounterValue + ")");
        this.writerThread.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            this.connection.firePacketInterceptors(packet);
            try {
                this.queue.put(packet);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return;
            }
            BlockingQueue<Packet> blockingQueue = this.queue;
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            this.connection.firePacketSendingListeners(packet);
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.done = true;
        BlockingQueue<Packet> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
        }
    }

    void cleanup() {
        this.connection.interceptors.clear();
        this.connection.sendListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet nextPacket() {
        Packet packet = null;
        while (!this.done && (packet = (Packet)this.queue.poll()) == null) {
            try {
                BlockingQueue<Packet> blockingQueue = this.queue;
                synchronized (blockingQueue) {
                    this.queue.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return packet;
    }

    /*
     * Unable to fully structure code
     */
    private void writePackets(Thread thisThread) {
        block19: {
            try {
                this.openStream();
                if (true) ** GOTO lbl9
                do {
                    if ((packet = this.nextPacket()) != null) {
                        this.writer.write(packet.toXML());
                        if (this.queue.isEmpty()) {
                            this.writer.flush();
                        }
                    }
lbl9:
                    // 6 sources

                    if (this.done) break;
                } while (this.writerThread == thisThread);
                try {
                    while (!this.queue.isEmpty()) {
                        packet = (Packet)this.queue.remove();
                        this.writer.write(packet.toXML());
                    }
                    this.writer.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.queue.clear();
                try {
                    try {
                        this.writer.write("</stream:stream>");
                        this.writer.flush();
                    }
                    catch (Exception e) {
                        try {
                            this.writer.close();
                        }
                        catch (Exception var4_6) {}
                    }
                }
                finally {
                    try {
                        this.writer.close();
                    }
                    catch (Exception var4_8) {}
                }
            }
            catch (IOException ioe) {
                if (this.done || this.connection.isSocketClosed()) break block19;
                this.done = true;
                if (this.connection.packetReader == null) break block19;
                this.connection.notifyConnectionError(ioe);
            }
        }
    }

    void openStream() throws IOException {
        StringBuilder stream = new StringBuilder();
        stream.append("<stream:stream");
        stream.append(" to=\"").append(this.connection.getServiceName()).append("\"");
        stream.append(" xmlns=\"jabber:client\"");
        stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stream.append(" version=\"1.0\">");
        this.writer.write(stream.toString());
        this.writer.flush();
    }
}

