/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.smack.util.Base64;
import org.jivesoftware.smack.util.DateFormatType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final DateFormat XEP_0082_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateFormat dateFormatter = DateFormatType.XEP_0082_DATE_PROFILE.createFormatter();
    private static final Pattern datePattern = Pattern.compile("^\\d+-\\d+-\\d+$");
    private static final DateFormat timeFormatter = DateFormatType.XEP_0082_TIME_MILLIS_ZONE_PROFILE.createFormatter();
    private static final Pattern timePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormat timeNoZoneFormatter = DateFormatType.XEP_0082_TIME_MILLIS_PROFILE.createFormatter();
    private static final Pattern timeNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+.\\d+$");
    private static final DateFormat timeNoMillisFormatter = DateFormatType.XEP_0082_TIME_ZONE_PROFILE.createFormatter();
    private static final Pattern timeNoMillisPattern = Pattern.compile("^(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))$");
    private static final DateFormat timeNoMillisNoZoneFormatter = DateFormatType.XEP_0082_TIME_PROFILE.createFormatter();
    private static final Pattern timeNoMillisNoZonePattern = Pattern.compile("^(\\d+:){2}\\d+$");
    private static final DateFormat dateTimeFormatter = DateFormatType.XEP_0082_DATETIME_MILLIS_PROFILE.createFormatter();
    private static final Pattern dateTimePattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat dateTimeNoMillisFormatter = DateFormatType.XEP_0082_DATETIME_PROFILE.createFormatter();
    private static final Pattern dateTimeNoMillisPattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final DateFormat xep0091Formatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date6DigitFormatter = new SimpleDateFormat("yyyyMd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit1MonthFormatter = new SimpleDateFormat("yyyyMdd'T'HH:mm:ss");
    private static final DateFormat xep0091Date7Digit2MonthFormatter = new SimpleDateFormat("yyyyMMd'T'HH:mm:ss");
    private static final Pattern xep0091Pattern = Pattern.compile("^\\d+T\\d+:\\d+:\\d+$");
    private static final List<PatternCouplings> couplings = new ArrayList<PatternCouplings>();
    private static final char[] QUOTE_ENCODE;
    private static final char[] APOS_ENCODE;
    private static final char[] AMP_ENCODE;
    private static final char[] LT_ENCODE;
    private static final char[] GT_ENCODE;
    private static MessageDigest digest;
    private static Random randGen;
    private static char[] numbersAndLetters;

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        XEP_0082_UTC_FORMAT.setTimeZone(utc);
        dateFormatter.setTimeZone(utc);
        timeFormatter.setTimeZone(utc);
        timeNoZoneFormatter.setTimeZone(utc);
        timeNoMillisFormatter.setTimeZone(utc);
        timeNoMillisNoZoneFormatter.setTimeZone(utc);
        dateTimeFormatter.setTimeZone(utc);
        dateTimeNoMillisFormatter.setTimeZone(utc);
        xep0091Formatter.setTimeZone(utc);
        xep0091Date6DigitFormatter.setTimeZone(utc);
        xep0091Date7Digit1MonthFormatter.setTimeZone(utc);
        xep0091Date7Digit1MonthFormatter.setLenient(false);
        xep0091Date7Digit2MonthFormatter.setTimeZone(utc);
        xep0091Date7Digit2MonthFormatter.setLenient(false);
        couplings.add(new PatternCouplings(datePattern, dateFormatter));
        couplings.add(new PatternCouplings(dateTimePattern, dateTimeFormatter, true));
        couplings.add(new PatternCouplings(dateTimeNoMillisPattern, dateTimeNoMillisFormatter, true));
        couplings.add(new PatternCouplings(timePattern, timeFormatter, true));
        couplings.add(new PatternCouplings(timeNoZonePattern, timeNoZoneFormatter));
        couplings.add(new PatternCouplings(timeNoMillisPattern, timeNoMillisFormatter, true));
        couplings.add(new PatternCouplings(timeNoMillisNoZonePattern, timeNoMillisNoZoneFormatter));
        QUOTE_ENCODE = "&quot;".toCharArray();
        APOS_ENCODE = "&apos;".toCharArray();
        AMP_ENCODE = "&amp;".toCharArray();
        LT_ENCODE = "&lt;".toCharArray();
        GT_ENCODE = "&gt;".toCharArray();
        digest = null;
        randGen = new Random();
        numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }

    public static Date parseXEP0082Date(String dateString) throws ParseException {
        return StringUtils.parseDate(dateString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date parseDate(String dateString) throws ParseException {
        block15: {
            Matcher matcher = xep0091Pattern.matcher(dateString);
            if (matcher.matches()) {
                int length = dateString.split("T")[0].length();
                if (length < 8) {
                    Date date = StringUtils.handleDateWithMissingLeadingZeros(dateString, length);
                    if (date != null) {
                        return date;
                    }
                    break block15;
                } else {
                    DateFormat dateFormat = xep0091Formatter;
                    synchronized (dateFormat) {
                        return xep0091Formatter.parse(dateString);
                    }
                }
            }
            for (PatternCouplings coupling : couplings) {
                matcher = coupling.pattern.matcher(dateString);
                if (!matcher.matches()) continue;
                if (coupling.needToConvertTimeZone) {
                    dateString = coupling.convertTime(dateString);
                }
                DateFormat dateFormat = coupling.formatter;
                synchronized (dateFormat) {
                    return coupling.formatter.parse(dateString);
                }
            }
        }
        DateFormat dateFormat = dateTimeNoMillisFormatter;
        synchronized (dateFormat) {
            return dateTimeNoMillisFormatter.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date handleDateWithMissingLeadingZeros(String stampString, int dateLength) throws ParseException {
        if (dateLength == 6) {
            DateFormat dateFormat = xep0091Date6DigitFormatter;
            synchronized (dateFormat) {
                return xep0091Date6DigitFormatter.parse(stampString);
            }
        }
        Calendar now = Calendar.getInstance();
        Calendar oneDigitMonth = StringUtils.parseXEP91Date(stampString, xep0091Date7Digit1MonthFormatter);
        Calendar twoDigitMonth = StringUtils.parseXEP91Date(stampString, xep0091Date7Digit2MonthFormatter);
        List<Calendar> dates = StringUtils.filterDatesBefore(now, oneDigitMonth, twoDigitMonth);
        if (!dates.isEmpty()) {
            return StringUtils.determineNearestDate(now, dates).getTime();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Calendar parseXEP91Date(String stampString, DateFormat dateFormat) {
        try {
            DateFormat dateFormat2 = dateFormat;
            synchronized (dateFormat2) {
                dateFormat.parse(stampString);
                return dateFormat.getCalendar();
            }
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static List<Calendar> filterDatesBefore(Calendar now, Calendar ... dates) {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        Calendar[] calendarArray = dates;
        int n = dates.length;
        int n2 = 0;
        while (n2 < n) {
            Calendar calendar = calendarArray[n2];
            if (calendar != null && calendar.before(now)) {
                result.add(calendar);
            }
            ++n2;
        }
        return result;
    }

    private static Calendar determineNearestDate(final Calendar now, List<Calendar> dates) {
        Collections.sort(dates, new Comparator<Calendar>(){

            @Override
            public int compare(Calendar o1, Calendar o2) {
                Long diff1 = new Long(now.getTimeInMillis() - o1.getTimeInMillis());
                Long diff2 = new Long(now.getTimeInMillis() - o2.getTimeInMillis());
                return diff1.compareTo(diff2);
            }
        });
        return dates.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXEP0082Date(Date date) {
        DateFormat dateFormat = dateTimeFormatter;
        synchronized (dateFormat) {
            return dateTimeFormatter.format(date);
        }
    }

    public static String formatDate(Date toFormat, DateFormatType type) {
        return null;
    }

    public static String parseName(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int atIndex = XMPPAddress.lastIndexOf("@");
        if (atIndex <= 0) {
            return "";
        }
        return XMPPAddress.substring(0, atIndex);
    }

    public static String parseServer(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int atIndex = XMPPAddress.lastIndexOf("@");
        if (atIndex + 1 > XMPPAddress.length()) {
            return "";
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex > 0 && slashIndex > atIndex) {
            return XMPPAddress.substring(atIndex + 1, slashIndex);
        }
        return XMPPAddress.substring(atIndex + 1);
    }

    public static String parseResource(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex + 1 > XMPPAddress.length() || slashIndex < 0) {
            return "";
        }
        return XMPPAddress.substring(slashIndex + 1);
    }

    public static String parseBareAddress(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex < 0) {
            return XMPPAddress;
        }
        if (slashIndex == 0) {
            return "";
        }
        return XMPPAddress.substring(0, slashIndex);
    }

    public static boolean isFullJID(String jid) {
        return StringUtils.parseName(jid).length() > 0 && StringUtils.parseServer(jid).length() > 0 && StringUtils.parseResource(jid).length() > 0;
    }

    public static String escapeNode(String node) {
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(node.length() + 8);
        int i = 0;
        int n = node.length();
        while (i < n) {
            char c = node.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    break;
                }
                case '&': {
                    buf.append("\\26");
                    break;
                }
                case '\'': {
                    buf.append("\\27");
                    break;
                }
                case '/': {
                    buf.append("\\2f");
                    break;
                }
                case ':': {
                    buf.append("\\3a");
                    break;
                }
                case '<': {
                    buf.append("\\3c");
                    break;
                }
                case '>': {
                    buf.append("\\3e");
                    break;
                }
                case '@': {
                    buf.append("\\40");
                    break;
                }
                case '\\': {
                    buf.append("\\5c");
                    break;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        break;
                    }
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static String unescapeNode(String node) {
        if (node == null) {
            return null;
        }
        nodeChars = node.toCharArray();
        buf = new StringBuilder(nodeChars.length);
        i = 0;
        n = nodeChars.length;
        while (i < n) {
            block17: {
                block19: {
                    block18: {
                        block16: {
                            c = node.charAt(i);
                            if (c != '\\' || i + 2 >= n) ** GOTO lbl-1000
                            c2 = nodeChars[i + 1];
                            c3 = nodeChars[i + 2];
                            if (c2 != '2') break block16;
                            switch (c3) {
                                case '0': {
                                    buf.append(' ');
                                    i += 2;
                                    break block17;
                                }
                                case '2': {
                                    buf.append('\"');
                                    i += 2;
                                    break block17;
                                }
                                case '6': {
                                    buf.append('&');
                                    i += 2;
                                    break block17;
                                }
                                case '7': {
                                    buf.append('\'');
                                    i += 2;
                                    break block17;
                                }
                                case 'f': {
                                    buf.append('/');
                                    i += 2;
                                    break block17;
                                }
                            }
                            ** GOTO lbl-1000
                        }
                        if (c2 != '3') break block18;
                        switch (c3) {
                            case 'a': {
                                buf.append(':');
                                i += 2;
                                break block17;
                            }
                            case 'c': {
                                buf.append('<');
                                i += 2;
                                break block17;
                            }
                            case 'e': {
                                buf.append('>');
                                i += 2;
                                break block17;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    if (c2 != '4') break block19;
                    if (c3 != '0') ** GOTO lbl-1000
                    buf.append("@");
                    i += 2;
                    break block17;
                }
                if (c2 == '5' && c3 == 'c') {
                    buf.append("\\");
                    i += 2;
                } else lbl-1000:
                // 5 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String escapeForXML(String string) {
        if (string == null) {
            return null;
        }
        int i = 0;
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        while (i < len) {
            char ch = input[i];
            if (ch <= '>') {
                if (ch == '<') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(LT_ENCODE);
                } else if (ch == '>') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(GT_ENCODE);
                } else if (ch == '&') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    if (!(len > i + 5 && input[i + 1] == '#' && Character.isDigit(input[i + 2]) && Character.isDigit(input[i + 3]) && Character.isDigit(input[i + 4]) && input[i + 5] == ';')) {
                        last = i + 1;
                        out.append(AMP_ENCODE);
                    }
                } else if (ch == '\"') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(QUOTE_ENCODE);
                } else if (ch == '\'') {
                    if (i > last) {
                        out.append(input, last, i - last);
                    }
                    last = i + 1;
                    out.append(APOS_ENCODE);
                }
            }
            ++i;
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static synchronized String hash(String data) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException nsae) {
                System.err.println("Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
            }
        }
        try {
            digest.update(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
        return StringUtils.encodeHex(digest.digest());
    }

    public static String encodeHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte aByte = byArray[n2];
            if ((aByte & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toString(aByte & 0xFF, 16));
            ++n2;
        }
        return hex.toString();
    }

    public static String encodeBase64(String data) {
        byte[] bytes = null;
        try {
            bytes = data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return StringUtils.encodeBase64(bytes);
    }

    public static String encodeBase64(byte[] data) {
        return StringUtils.encodeBase64(data, false);
    }

    public static String encodeBase64(byte[] data, boolean lineBreaks) {
        return StringUtils.encodeBase64(data, 0, data.length, lineBreaks);
    }

    public static String encodeBase64(byte[] data, int offset, int len, boolean lineBreaks) {
        return Base64.encodeBytes(data, offset, len, lineBreaks ? 0 : 8);
    }

    public static byte[] decodeBase64(String data) {
        byte[] bytes;
        try {
            bytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            bytes = data.getBytes();
        }
        bytes = Base64.decode(bytes, 0, bytes.length, 0);
        return bytes;
    }

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        int i = 0;
        while (i < randBuffer.length) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
            ++i;
        }
        return new String(randBuffer);
    }

    private StringUtils() {
    }

    private static class PatternCouplings {
        Pattern pattern;
        DateFormat formatter;
        boolean needToConvertTimeZone = false;

        public PatternCouplings(Pattern datePattern, DateFormat dateFormat) {
            this.pattern = datePattern;
            this.formatter = dateFormat;
        }

        public PatternCouplings(Pattern datePattern, DateFormat dateFormat, boolean shouldConvertToRFC822) {
            this.pattern = datePattern;
            this.formatter = dateFormat;
            this.needToConvertTimeZone = shouldConvertToRFC822;
        }

        public String convertTime(String dateString) {
            if (dateString.charAt(dateString.length() - 1) == 'Z') {
                return dateString.replace("Z", "+0000");
            }
            return dateString.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
        }
    }
}

