/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.ui.wizards;

import java.io.IOException;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.provider.xmpp.ui.Messages;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPConnectWizard;
import org.eclipse.ecf.internal.provider.xmpp.ui.wizards.XMPPSConnectWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;

public final class XMPPSConnectWizard
extends XMPPConnectWizard {
    public XMPPSConnectWizard() {
    }

    public XMPPSConnectWizard(String uri) {
        super(uri);
    }

    public void addPages() {
        this.page = new XMPPSConnectWizardPage(this.usernameAtHost);
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench workbench, IContainer container) {
        super.init(workbench, container);
        this.setWindowTitle(Messages.XMPPSConnectWizard_WIZARD_TITLE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        try {
            this.container = ContainerFactory.getDefault().createContainer("ecf.xmpps.smack");
        }
        catch (ContainerCreateException containerCreateException) {
            // empty catch block
        }
        this.setWindowTitle(Messages.XMPPSConnectWizard_WIZARD_TITLE);
    }

    protected IConnectContext createConnectContext() {
        final String password = this.page.getPassword();
        final String keystorePassword = ((XMPPSConnectWizardPage)this.page).getKeystorePassword();
        return new IConnectContext(){

            public CallbackHandler getCallbackHandler() {
                return new DualCallbackHandler(password, keystorePassword);
            }
        };
    }

    class DualCallbackHandler
    implements CallbackHandler,
    javax.security.auth.callback.CallbackHandler {
        CallbackHandler delegate;
        String keystorePassword;

        public DualCallbackHandler(String password, String keystorePassword) {
            this.delegate = ConnectContextFactory.createPasswordConnectContext((String)password).getCallbackHandler();
            this.keystorePassword = keystorePassword;
        }

        public void handle(javax.security.auth.callback.Callback[] acallback) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < acallback.length) {
                if (acallback[i] instanceof org.eclipse.ecf.core.security.PasswordCallback) {
                    ((PasswordCallback)acallback[i]).setPassword(this.keystorePassword.toCharArray());
                }
                ++i;
            }
        }

        public void handle(Callback[] callbacks) throws IOException, org.eclipse.ecf.core.security.UnsupportedCallbackException {
            this.delegate.handle(callbacks);
        }
    }
}

