/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.AbstractContainer;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerTransaction;
import org.eclipse.ecf.core.sharedobject.ISharedObjectManager;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.events.ContainerSharedObjectMessageReceivingEvent;
import org.eclipse.ecf.core.sharedobject.events.ContainerSharedObjectMessageSendingEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectDeactivatedEvent;
import org.eclipse.ecf.core.sharedobject.security.ISharedObjectPolicy;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.ISharedObjectMessageSerializer;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.OSGIObjectInputStream;
import org.eclipse.ecf.core.util.OSGIObjectOutputStream;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.ProviderPlugin;
import org.eclipse.ecf.provider.comm.AsynchEvent;
import org.eclipse.ecf.provider.comm.ConnectionEvent;
import org.eclipse.ecf.provider.comm.DisconnectEvent;
import org.eclipse.ecf.provider.comm.IAsynchConnection;
import org.eclipse.ecf.provider.comm.IConnection;
import org.eclipse.ecf.provider.comm.ISynchAsynchEventHandler;
import org.eclipse.ecf.provider.comm.SynchEvent;
import org.eclipse.ecf.provider.generic.ContainerMessage;
import org.eclipse.ecf.provider.generic.SOConfig;
import org.eclipse.ecf.provider.generic.SOContainerGMM;
import org.eclipse.ecf.provider.generic.SOContext;
import org.eclipse.ecf.provider.generic.SOManager;
import org.eclipse.ecf.provider.generic.SOWrapper;
import org.eclipse.ecf.provider.generic.gmm.Member;

public abstract class SOContainer
extends AbstractContainer
implements ISharedObjectContainer {
    public static final String DEFAULT_OBJECT_ARG_KEY = String.valueOf(SOContainer.class.getName()) + ".sharedobjectargs";
    public static final String DEFAULT_OBJECT_ARGTYPES_KEY = String.valueOf(SOContainer.class.getName()) + ".sharedobjectargtypes";
    private long sequenceNumber = 0L;
    protected ISharedObjectContainerConfig config = null;
    protected SOContainerGMM groupManager = null;
    protected boolean isClosing = false;
    protected ThreadGroup loadingThreadGroup = null;
    protected SOManager sharedObjectManager = null;
    protected ISharedObjectPolicy policy = null;
    protected ThreadGroup sharedObjectThreadGroup = null;
    protected ISharedObjectMessageSerializer sharedObjectMessageSerializer = new ISharedObjectMessageSerializer(){

        public Object deserializeMessage(byte[] data) throws IOException, ClassNotFoundException {
            return SOContainer.this.defaultDeserializeSharedObjectMessage(data);
        }

        public byte[] serializeMessage(ID sharedObjectId, Object message) throws IOException {
            return SOContainer.this.defaultSerializeSharedObjectMessage(sharedObjectId, message);
        }
    };
    protected ISynchAsynchEventHandler receiver = new ISynchAsynchEventHandler(){

        public Object handleSynchEvent(SynchEvent event) throws IOException {
            return SOContainer.this.processSynch(event);
        }

        public ID getEventHandlerID() {
            return SOContainer.this.getID();
        }

        public void handleConnectEvent(ConnectionEvent event) {
        }

        public void handleDisconnectEvent(DisconnectEvent event) {
            SOContainer.this.processDisconnect(event);
        }

        public void handleAsynchEvent(AsynchEvent event) throws IOException {
            SOContainer.this.processAsynch(event);
        }
    };
    private static final String SO_SERIALIZATION_OSGI = "osgi.basic";
    private static final String SO_SERIALIZATION_DEFAULT = System.getProperty("org.eclipse.ecf.provider.soserialization", "osgi.basic");

    public void setSharedObjectMessageSerializer(ISharedObjectMessageSerializer serializer) {
        if (serializer == null) {
            return;
        }
        this.sharedObjectMessageSerializer = serializer;
    }

    protected ISharedObjectMessageSerializer getSharedObjectMessageSerializer() {
        return this.sharedObjectMessageSerializer;
    }

    public SOContainer(ISharedObjectContainerConfig config) {
        Assert.isNotNull((Object)config, (String)"container config cannot be null");
        this.config = config;
        this.groupManager = new SOContainerGMM(this, new Member(config.getID()));
        this.sharedObjectManager = new SOManager(this);
        this.loadingThreadGroup = new ThreadGroup(this.getID() + ":loading");
        this.sharedObjectThreadGroup = new ThreadGroup(this.getID() + ":SOs");
    }

    public ID getID() {
        return this.config.getID();
    }

    public abstract void connect(ID var1, IConnectContext var2) throws ContainerConnectException;

    public abstract ID getConnectedID();

    public abstract void disconnect();

    public Namespace getConnectNamespace() {
        return IDFactory.getDefault().getNamespaceByName(ProviderPlugin.getDefault().getNamespaceIdentifier());
    }

    public void dispose() {
        this.isClosing = true;
        if (this.groupManager != null) {
            this.groupManager.removeAllMembers();
        }
        if (this.sharedObjectManager != null) {
            this.sharedObjectManager.dispose();
            this.sharedObjectManager = null;
        }
        if (this.loadingThreadGroup != null) {
            this.loadingThreadGroup.interrupt();
            this.loadingThreadGroup = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance((Object)this)) {
            return this;
        }
        IAdapterManager adapterManager = ProviderPlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public ISharedObjectManager getSharedObjectManager() {
        return this.sharedObjectManager;
    }

    public ID[] getGroupMemberIDs() {
        return this.groupManager.getMemberIDs();
    }

    public ISharedObjectContainerConfig getConfig() {
        return this.config;
    }

    public abstract boolean isGroupManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteAddPolicy(ISharedObjectPolicy policy) {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            this.policy = policy;
        }
    }

    protected boolean addNewRemoteMember(ID memberID, Object data) {
        return this.groupManager.addMember(new Member(memberID, data));
    }

    protected ISharedObjectContainerTransaction addSharedObject0(ID id, ISharedObject s, Map props) throws Exception {
        return this.addSharedObjectWrapper(this.createSharedObjectWrapper(id, s, props));
    }

    protected void addSharedObjectAndWait(ID id, ISharedObject s, Map properties) throws Exception {
        if (id == null || s == null) {
            throw new SharedObjectAddException("shared object or id cannot be null");
        }
        ISharedObjectContainerTransaction t = this.addSharedObject0(id, s, properties);
        if (t != null) {
            t.waitToCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISharedObjectContainerTransaction addSharedObjectWrapper(SOWrapper wrapper) throws Exception {
        if (wrapper == null) {
            return null;
        }
        ID id = wrapper.getObjID();
        ISharedObjectContainerTransaction transaction = null;
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            SOWrapper obj = this.groupManager.getFromAny(id);
            if (obj != null) {
                throw new SharedObjectAddException("shared object id=" + id.getName() + " already in container");
            }
            wrapper.init();
            transaction = (ISharedObjectContainerTransaction)wrapper.sharedObject.getAdapter(ISharedObjectContainerTransaction.class);
            this.groupManager.addSharedObjectToActive(wrapper);
        }
        return transaction;
    }

    protected boolean addToLoading(LoadingSharedObject lso) {
        return this.groupManager.addLoadingSharedObject(lso);
    }

    protected Object checkRemoteCreate(ID fromID, ID toID, ReplicaSharedObjectDescription desc) throws Exception {
        if (this.policy != null) {
            return this.policy.checkAddSharedObject(fromID, toID, this.getID(), desc);
        }
        return desc;
    }

    protected void debug(String msg) {
        Trace.trace((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/container", (String)(String.valueOf(msg) + ":" + this.config.getID()));
    }

    protected void traceStack(String msg, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.provider", (String)"org.eclipse.ecf.provider/debug/exceptions/catching", SOContainer.class, (String)(this.config.getID() + ":" + msg), (Throwable)e);
    }

    protected boolean destroySharedObject(ID sharedObjectID) {
        return this.groupManager.removeSharedObject(sharedObjectID);
    }

    protected final void forward(ID fromID, ID toID, ContainerMessage data) throws IOException {
        if (toID == null) {
            this.forwardExcluding(fromID, fromID, data);
        } else {
            this.forwardToRemote(fromID, toID, data);
        }
    }

    protected abstract void forwardExcluding(ID var1, ID var2, ContainerMessage var3) throws IOException;

    protected abstract void forwardToRemote(ID var1, ID var2, ContainerMessage var3) throws IOException;

    protected Object[] getArgsFromProperties(SharedObjectDescription sd) {
        if (sd == null) {
            return null;
        }
        Map aMap = sd.getProperties();
        if (aMap == null) {
            return null;
        }
        Object obj = aMap.get(DEFAULT_OBJECT_ARG_KEY);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Object[]) {
            Object[] ret = (Object[])obj;
            aMap.remove(DEFAULT_OBJECT_ARG_KEY);
            return ret;
        }
        return null;
    }

    protected String[] getArgTypesFromProperties(SharedObjectDescription sd) {
        if (sd == null) {
            return null;
        }
        Map aMap = sd.getProperties();
        if (aMap == null) {
            return null;
        }
        Object obj = aMap.get(DEFAULT_OBJECT_ARGTYPES_KEY);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[]) {
            String[] ret = (String[])obj;
            aMap.remove(DEFAULT_OBJECT_ARGTYPES_KEY);
            return ret;
        }
        return null;
    }

    public static byte[] serialize(Serializable obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.close();
        return bos.toByteArray();
    }

    protected ClassLoader getClassLoaderForContainer() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected ClassLoader getClassLoaderForSharedObject(SharedObjectDescription sd) {
        return this.getClassLoaderForContainer();
    }

    protected Object getGroupMembershipLock() {
        return this.groupManager;
    }

    protected int getMaxGroupMembers() {
        return this.groupManager.getMaxMembers();
    }

    protected Thread getNewSharedObjectThread(ID sharedObjectID, Runnable runnable) {
        return new Thread(this.sharedObjectThreadGroup, runnable, String.valueOf(sharedObjectID.getName()) + ":run");
    }

    protected long getNextSequenceNumber() {
        if (this.sequenceNumber == Long.MAX_VALUE) {
            this.sequenceNumber = 0L;
            return this.sequenceNumber;
        }
        return this.sequenceNumber++;
    }

    public static ContainerMessage deserializeContainerMessage(byte[] bytes) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = ProviderPlugin.getDefault().createObjectInputStream(bis);
        Object obj = null;
        try {
            obj = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", "class not found on deserialize", (Throwable)e));
            SOContainer.printToSystemError("deserializeContainerMessage class not found", e);
            return null;
        }
        catch (InvalidClassException e) {
            ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", "invalid class on deserialize", (Throwable)e));
            SOContainer.printToSystemError("deserializeContainerMessage invalid class", e);
            return null;
        }
        if (obj instanceof ContainerMessage) {
            return (ContainerMessage)obj;
        }
        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", "invalid container message", null));
        SOContainer.printToSystemError("deserializeContainerMessage invalid container message ", new InvalidObjectException("object " + obj + " not appropriate type"));
        return null;
    }

    protected static void printToSystemError(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace(System.err);
    }

    protected ID[] getOtherMemberIDs() {
        return this.groupManager.getOtherMemberIDs();
    }

    protected ISynchAsynchEventHandler getReceiver() {
        return this.receiver;
    }

    public ISynchAsynchEventHandler getMessageReceiver() {
        return this.getReceiver();
    }

    protected ISharedObject getSharedObject(ID id) {
        SOWrapper wrap = this.getSharedObjectWrapper(id);
        return wrap == null ? null : wrap.getSharedObject();
    }

    protected ID[] getSharedObjectIDs() {
        return this.groupManager.getSharedObjectIDs();
    }

    protected SOWrapper getSharedObjectWrapper(ID id) {
        return this.groupManager.getFromActive(id);
    }

    protected void handleAsynchIOException(IOException except, AsynchEvent e) {
        this.disconnect(e.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateMessage(ContainerMessage mess) throws IOException {
        ContainerMessage.CreateMessage create = (ContainerMessage.CreateMessage)mess.getData();
        if (create == null) {
            throw new IOException("container create message cannot be null");
        }
        ReplicaSharedObjectDescription desc = (ReplicaSharedObjectDescription)create.getData();
        if (desc == null) {
            throw new IOException("shared object description cannot be null");
        }
        ID fromID = mess.getFromContainerID();
        ID toID = mess.getToContainerID();
        Object checkCreateResult = null;
        ID sharedObjectID = desc.getID();
        if (sharedObjectID == null) {
            throw new IOException("shared object id cannot be null");
        }
        if (this.verifySharedObjectMessageTarget(toID)) {
            try {
                checkCreateResult = this.checkRemoteCreate(fromID, toID, desc);
            }
            catch (Exception e) {
                SharedObjectAddException addException = new SharedObjectAddException("shared object=" + sharedObjectID + " could not be added to container=" + this.getID(), (Throwable)e);
                this.traceStack("Exception in checkRemoteCreate:" + desc, addException);
                try {
                    this.sendCreateResponse(fromID, sharedObjectID, addException, desc.getIdentifier());
                }
                catch (IOException except) {
                    this.traceStack("Exception from sendCreateResponse in handleCreateResponse", except);
                }
                return;
            }
            if (checkCreateResult != null) {
                LoadingSharedObject lso = new LoadingSharedObject(fromID, desc);
                Object object = this.getGroupMembershipLock();
                synchronized (object) {
                    if (!this.addToLoading(lso)) {
                        try {
                            this.sendCreateResponse(fromID, sharedObjectID, new SharedObjectAddException("shared object=" + sharedObjectID + " already exists in container=" + this.getID()), desc.getIdentifier());
                        }
                        catch (IOException e) {
                            this.traceStack("Exception in handleCreateMessage.sendCreateResponse", e);
                        }
                    }
                    this.forward(fromID, toID, mess);
                    return;
                }
            }
        } else {
            Object object = this.getGroupMembershipLock();
            synchronized (object) {
                this.forward(fromID, toID, mess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreateResponseMessage(ContainerMessage mess) throws IOException {
        ID fromID = mess.getFromContainerID();
        ID toID = mess.getToContainerID();
        ContainerMessage.CreateResponseMessage resp = (ContainerMessage.CreateResponseMessage)mess.getData();
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            if (this.verifySharedObjectMessageTarget(toID)) {
                ID sharedObjectID = resp.getSharedObjectID();
                SOWrapper sow = this.getSharedObjectWrapper(sharedObjectID);
                if (sow != null) {
                    sow.deliverCreateResponse(fromID, resp);
                }
            } else {
                this.forward(fromID, toID, mess);
            }
        }
    }

    protected abstract void handleLeaveGroupMessage(ContainerMessage var1);

    protected boolean verifySharedObjectMessageTarget(ID containerID) {
        return containerID == null || containerID.equals((Object)this.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSharedObjectDisposeMessage(ContainerMessage mess) throws IOException {
        ID fromID = mess.getFromContainerID();
        ID toID = mess.getToContainerID();
        ContainerMessage.SharedObjectDisposeMessage resp = (ContainerMessage.SharedObjectDisposeMessage)mess.getData();
        ID sharedObjectID = resp.getSharedObjectID();
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            if (this.verifySharedObjectMessageTarget(toID)) {
                if (this.groupManager.isLoading(sharedObjectID)) {
                    this.groupManager.removeSharedObjectFromLoading(sharedObjectID);
                } else {
                    this.groupManager.removeSharedObject(sharedObjectID);
                }
            }
            this.forward(fromID, toID, mess);
        }
    }

    protected boolean verifyToIDForSharedObjectMessage(ID toID) {
        return toID == null || toID.equals((Object)this.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSharedObjectMessage(ContainerMessage mess) throws IOException {
        ID fromID = mess.getFromContainerID();
        ID toID = mess.getToContainerID();
        ContainerMessage.SharedObjectMessage resp = (ContainerMessage.SharedObjectMessage)mess.getData();
        ID sharedObjectID = resp.getFromSharedObjectID();
        SOWrapper sow = null;
        Serializable obj = null;
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            if (this.verifySharedObjectMessageTarget(toID)) {
                sow = this.getSharedObjectWrapper(sharedObjectID);
                if (sow != null) {
                    try {
                        obj = (Serializable)this.deserializeSharedObjectMessage((byte[])resp.getData());
                        sow.deliverSharedObjectMessage(fromID, obj);
                    }
                    catch (ClassNotFoundException e) {
                        String message = "shared object message ClassNotFoundException.  sharedObjectID=" + sharedObjectID + " fromContainerID=" + fromID;
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", message, (Throwable)e));
                        SOContainer.printToSystemError(message, e);
                    }
                    catch (IOException e) {
                        String message = "shared object message IOException.  sharedObjectID=" + sharedObjectID + " fromContainerID=" + fromID;
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", message, (Throwable)e));
                        SOContainer.printToSystemError(message, e);
                    }
                    catch (NoClassDefFoundError e) {
                        String message = "shared object message NoClassDefFoundError.  sharedObjectID=" + sharedObjectID + " fromContainerID=" + fromID;
                        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", message, (Throwable)e));
                        SOContainer.printToSystemError(message, e);
                    }
                } else {
                    this.handleUndeliveredSharedObjectMessage(resp);
                }
            }
            this.forward(fromID, toID, mess);
        }
        if (sow != null) {
            this.fireContainerEvent((IContainerEvent)new ContainerSharedObjectMessageReceivingEvent(this.getID(), fromID, sharedObjectID, (Object)obj));
        }
    }

    protected void handleUndeliveredSharedObjectMessage(ContainerMessage.SharedObjectMessage resp) {
    }

    protected void handleUnidentifiedMessage(ContainerMessage mess) throws IOException {
        ProviderPlugin.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider", 4, "unidentified message " + mess, null));
        this.debug("received unidentified message: " + mess);
    }

    protected abstract void handleViewChangeMessage(ContainerMessage var1) throws IOException;

    protected boolean isClosing() {
        return this.isClosing;
    }

    protected void disconnect(IConnection conn) {
        if (conn != null && conn.isConnected()) {
            conn.disconnect();
        }
    }

    protected ISharedObject load(SharedObjectDescription sd) throws Exception {
        return this.sharedObjectManager.loadSharedObject(sd);
    }

    protected SOConfig createSharedObjectConfig(ID id, ISharedObject obj, Map props) throws ECFException {
        return new SOConfig(id, this.getID(), this, props);
    }

    protected SOConfig createRemoteSharedObjectConfig(ID fromID, ReplicaSharedObjectDescription sd, ISharedObject obj) {
        ID homeID = sd.getHomeID();
        if (homeID == null) {
            homeID = fromID;
        }
        return new SOConfig(sd.getID(), homeID, this, sd.getProperties());
    }

    protected SOContext createSharedObjectContext(SOConfig soconfig, IQueueEnqueue queue) {
        return new SOContext(soconfig.getSharedObjectID(), soconfig.getHomeContainerID(), this, soconfig.getProperties(), queue);
    }

    protected SOContext createRemoteSharedObjectContext(SOConfig soconfig, IQueueEnqueue queue) {
        return new SOContext(soconfig.getSharedObjectID(), soconfig.getHomeContainerID(), this, soconfig.getProperties(), queue);
    }

    protected SOWrapper createSharedObjectWrapper(ID id, ISharedObject s, Map props) throws ECFException {
        SOConfig newConfig = this.createSharedObjectConfig(id, s, props);
        return new SOWrapper(newConfig, s, this);
    }

    protected SOWrapper createRemoteSharedObjectWrapper(ID fromID, ReplicaSharedObjectDescription sd, ISharedObject s) {
        SOConfig newConfig = this.createRemoteSharedObjectConfig(fromID, sd, s);
        return new SOWrapper(newConfig, s, this);
    }

    protected void handleLeave(ID leftID, IConnection conn) {
        if (leftID == null) {
            return;
        }
        if (this.groupManager.removeMember(leftID)) {
            try {
                this.forwardExcluding(this.getID(), leftID, ContainerMessage.createViewChangeMessage(this.getID(), null, this.getNextSequenceNumber(), new ID[]{leftID}, false, null));
            }
            catch (IOException e) {
                this.traceStack("Exception in memberLeave.forwardExcluding", e);
            }
        }
        if (conn != null) {
            this.disconnect(conn);
        }
    }

    protected void moveFromLoadingToActive(SOWrapper wrap) {
        this.groupManager.moveSharedObjectFromLoadingToActive(wrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySharedObjectActivated(ID sharedObjectID) {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            this.groupManager.notifyOthersActivated(sharedObjectID);
            this.fireContainerEvent((IContainerEvent)new SharedObjectActivatedEvent(this.getID(), sharedObjectID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySharedObjectDeactivated(ID sharedObjectID) {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            this.groupManager.notifyOthersDeactivated(sharedObjectID);
            this.fireContainerEvent((IContainerEvent)new SharedObjectDeactivatedEvent(this.getID(), sharedObjectID));
        }
    }

    protected ContainerMessage validateContainerMessage(Object mess) {
        if (mess == null) {
            return null;
        }
        if (mess instanceof ContainerMessage) {
            ContainerMessage contmess = (ContainerMessage)mess;
            ID fromID = contmess.getFromContainerID();
            if (fromID == null) {
                return null;
            }
            return contmess;
        }
        return null;
    }

    protected void processAsynch(AsynchEvent event) throws IOException {
        try {
            Object obj = event.getData();
            if (obj == null) {
                this.debug("Ignoring null data in event " + event);
                return;
            }
            if (!(obj instanceof byte[])) {
                this.debug("Ignoring event without valid data " + event);
                return;
            }
            ContainerMessage mess = this.validateContainerMessage(SOContainer.deserializeContainerMessage((byte[])obj));
            if (mess == null) {
                this.debug("event not validated: " + event);
                return;
            }
            Serializable submess = mess.getData();
            if (submess == null) {
                this.debug("submess is null: " + event);
                return;
            }
            if (submess instanceof ContainerMessage.CreateMessage) {
                this.handleCreateMessage(mess);
            } else if (submess instanceof ContainerMessage.CreateResponseMessage) {
                this.handleCreateResponseMessage(mess);
            } else if (submess instanceof ContainerMessage.SharedObjectDisposeMessage) {
                this.handleSharedObjectDisposeMessage(mess);
            } else if (submess instanceof ContainerMessage.SharedObjectMessage) {
                this.handleSharedObjectMessage(mess);
            } else if (submess instanceof ContainerMessage.ViewChangeMessage) {
                this.handleViewChangeMessage(mess);
            } else {
                this.handleUnidentifiedMessage(mess);
            }
        }
        catch (IOException except) {
            this.handleAsynchIOException(except, event);
        }
    }

    protected abstract ID getIDForConnection(IAsynchConnection var1);

    protected abstract void processDisconnect(DisconnectEvent var1);

    protected Serializable processSynch(SynchEvent e) throws IOException {
        ContainerMessage mess = SOContainer.deserializeContainerMessage((byte[])e.getData());
        Serializable data = mess.getData();
        if (data != null && data instanceof ContainerMessage.LeaveGroupMessage) {
            this.handleLeaveGroupMessage(mess);
        }
        return null;
    }

    protected abstract void queueContainerMessage(ContainerMessage var1) throws IOException;

    protected void removeFromLoading(ID id) {
        this.groupManager.removeSharedObjectFromLoading(id);
    }

    protected boolean removeRemoteMember(ID remoteMember) {
        return this.groupManager.removeMember(remoteMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISharedObject removeSharedObject(ID id) {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            SOWrapper wrap;
            block4: {
                wrap = this.groupManager.getFromActive(id);
                if (wrap != null) break block4;
                return null;
            }
            this.groupManager.removeSharedObject(id);
            return wrap.getSharedObject();
        }
    }

    protected void sendCreate(ID sharedObjectID, ID toContainerID, SharedObjectDescription sd) throws IOException {
        this.sendCreateSharedObjectMessage(toContainerID, sd);
    }

    protected void sendCreateResponse(ID homeID, ID sharedObjectID, Throwable t, long identifier) throws IOException {
        this.sendCreateResponseSharedObjectMessage(homeID, sharedObjectID, t, identifier);
    }

    protected void sendCreateResponseSharedObjectMessage(ID toContainerID, ID fromSharedObject, Throwable t, long ident) throws IOException {
        this.sendMessage(ContainerMessage.createSharedObjectCreateResponseMessage(this.getID(), toContainerID, this.getNextSequenceNumber(), fromSharedObject, t, ident));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ID[] sendCreateSharedObjectMessage(ID toContainerID, SharedObjectDescription sd) throws IOException {
        ID[] returnIDs = null;
        if (toContainerID == null) {
            Object object = this.getGroupMembershipLock();
            synchronized (object) {
                this.sendMessage(ContainerMessage.createSharedObjectCreateMessage(this.getID(), toContainerID, this.getNextSequenceNumber(), (Serializable)sd));
                returnIDs = this.getOtherMemberIDs();
            }
        } else if (this.getID().equals((Object)toContainerID)) {
            returnIDs = new ID[]{};
        } else {
            this.sendMessage(ContainerMessage.createSharedObjectCreateMessage(this.getID(), toContainerID, this.getNextSequenceNumber(), (Serializable)sd));
            returnIDs = new ID[]{toContainerID};
        }
        return returnIDs;
    }

    protected Map createContainerPropertiesForSharedObject(ID sharedObjectID) {
        return new HashMap();
    }

    protected void sendDispose(ID toContainerID, ID sharedObjectID) throws IOException {
        this.sendDisposeSharedObjectMessage(toContainerID, sharedObjectID);
    }

    protected void sendDisposeSharedObjectMessage(ID toContainerID, ID fromSharedObject) throws IOException {
        this.sendMessage(ContainerMessage.createSharedObjectDisposeMessage(this.getID(), toContainerID, this.getNextSequenceNumber(), fromSharedObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(ContainerMessage data) throws IOException {
        Object object = this.getGroupMembershipLock();
        synchronized (object) {
            ID ourID = this.getID();
            if (!ourID.equals((Object)data.getToContainerID())) {
                this.queueContainerMessage(data);
            }
        }
    }

    protected byte[] serializeSharedObjectMessage(ID sharedObjectID, Object message) throws IOException {
        return this.getSharedObjectMessageSerializer().serializeMessage(sharedObjectID, message);
    }

    protected byte[] defaultSerializeSharedObjectMessage(ID sharedObjectID, Object message) throws IOException {
        if (!(message instanceof Serializable)) {
            throw new NotSerializableException("shared object=" + sharedObjectID + " message=" + message + " not serializable");
        }
        ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        Object oos = SO_SERIALIZATION_DEFAULT.equals(SO_SERIALIZATION_OSGI) ? new OSGIObjectOutputStream((OutputStream)bouts) : new ObjectOutputStream(bouts);
        ((ObjectOutputStream)oos).writeObject(message);
        ((ObjectOutputStream)oos).close();
        return bouts.toByteArray();
    }

    protected Object defaultDeserializeSharedObjectMessage(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bins = new ByteArrayInputStream(bytes);
        Object oins = SO_SERIALIZATION_DEFAULT.equals(SO_SERIALIZATION_OSGI) ? new OSGIObjectInputStream(ProviderPlugin.getDefault().getContext().getBundle(), (InputStream)bins) : new ObjectInputStream(bins);
        Object result = ((ObjectInputStream)oins).readObject();
        ((ObjectInputStream)oins).close();
        return result;
    }

    protected Object deserializeSharedObjectMessage(byte[] bytes) throws IOException, ClassNotFoundException {
        return this.getSharedObjectMessageSerializer().deserializeMessage(bytes);
    }

    protected void sendMessage(ID toContainerID, ID sharedObjectID, Object message) throws IOException {
        if (message == null) {
            return;
        }
        this.fireContainerEvent((IContainerEvent)new ContainerSharedObjectMessageSendingEvent(this.getID(), toContainerID, sharedObjectID, message));
        byte[] sendData = this.serializeSharedObjectMessage(sharedObjectID, message);
        this.sendSharedObjectMessage(toContainerID, sharedObjectID, (Serializable)sendData);
    }

    protected void sendSharedObjectMessage(ID toContainerID, ID fromSharedObject, Serializable data) throws IOException {
        this.sendMessage(ContainerMessage.createSharedObjectMessage(this.getID(), toContainerID, this.getNextSequenceNumber(), fromSharedObject, data));
    }

    protected void setMaxGroupMembers(int max) {
        this.groupManager.setMaxMembers(max);
    }

    protected void fireDelegateContainerEvent(IContainerEvent containerEvent) {
        super.fireContainerEvent(containerEvent);
    }

    class LoadingSharedObject
    implements ISharedObject {
        final ReplicaSharedObjectDescription description;
        private Thread runner = null;
        ID fromID = null;

        LoadingSharedObject(ID fromID, ReplicaSharedObjectDescription sd) {
            this.fromID = fromID;
            this.description = sd;
        }

        public void dispose(ID containerID) {
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        ID getHomeID() {
            ID homeID = this.description.getHomeID();
            if (homeID == null) {
                return this.getID();
            }
            return homeID;
        }

        ID getID() {
            return this.description.getID();
        }

        public void handleEvent(Event event) {
        }

        public void handleEvents(Event[] events) {
        }

        public void init(ISharedObjectConfig initData) throws SharedObjectInitException {
        }

        void start() {
            if (this.runner == null) {
                this.runner = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new Thread(((LoadingSharedObject)LoadingSharedObject.this).SOContainer.this.loadingThreadGroup, new Runnable(){

                            public void run() {
                                try {
                                    if (Thread.currentThread().isInterrupted() || SOContainer.this.isClosing()) {
                                        throw new InterruptedException("loading interrupted for " + LoadingSharedObject.this.getID().getName());
                                    }
                                    ISharedObject obj = SOContainer.this.load((SharedObjectDescription)(this).LoadingSharedObject.this.description);
                                    SOWrapper wrap = SOContainer.this.createRemoteSharedObjectWrapper((this).LoadingSharedObject.this.fromID, (this).LoadingSharedObject.this.description, obj);
                                    wrap.init();
                                    if (Thread.currentThread().isInterrupted() || SOContainer.this.isClosing()) {
                                        throw new InterruptedException("loading interrupted for " + LoadingSharedObject.this.getID().getName());
                                    }
                                    SOContainer.this.moveFromLoadingToActive(wrap);
                                }
                                catch (Exception e) {
                                    SOContainer.this.traceStack("Exception loading:" + (this).LoadingSharedObject.this.description, e);
                                    SOContainer.this.removeFromLoading(LoadingSharedObject.this.getID());
                                    try {
                                        SOContainer.this.sendCreateResponse(LoadingSharedObject.this.getHomeID(), LoadingSharedObject.this.getID(), e, (this).LoadingSharedObject.this.description.getIdentifier());
                                    }
                                    catch (Exception e1) {
                                        SOContainer.this.traceStack("Exception sending create response from LoadingSharedObject.run:" + (this).LoadingSharedObject.this.description, e1);
                                    }
                                }
                                catch (NoClassDefFoundError e) {
                                    SOContainer.this.traceStack("Exception loading:" + (this).LoadingSharedObject.this.description, e);
                                    SOContainer.this.removeFromLoading(LoadingSharedObject.this.getID());
                                    try {
                                        SOContainer.this.sendCreateResponse(LoadingSharedObject.this.getHomeID(), LoadingSharedObject.this.getID(), e, (this).LoadingSharedObject.this.description.getIdentifier());
                                    }
                                    catch (Exception e1) {
                                        SOContainer.this.traceStack("Exception sending create response from LoadingSharedObject.run:" + (this).LoadingSharedObject.this.description, e1);
                                    }
                                }
                            }
                        }, String.valueOf(LoadingSharedObject.this.getID().getName()) + ":loading");
                    }
                });
                this.runner.setDaemon(true);
                this.runner.start();
            }
        }
    }
}

