/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConnector;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectEvent;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.QueueException;
import org.eclipse.ecf.core.util.Event;

public class SOConnector
implements ISharedObjectConnector {
    ID sender;
    Hashtable receiverQueues = new Hashtable();

    public SOConnector(ID sender, ID[] recv, IQueueEnqueue[] queues) {
        int i = 0;
        while (i < recv.length) {
            this.receiverQueues.put(recv[i], queues[i]);
            ++i;
        }
    }

    protected void fireEvent(ISharedObjectEvent event) throws QueueException {
        Enumeration e = this.receiverQueues.elements();
        while (e.hasMoreElements()) {
            IQueueEnqueue queue = (IQueueEnqueue)e.nextElement();
            queue.enqueue((Event)event);
        }
    }

    protected void fireEvents(ISharedObjectEvent[] event) throws QueueException {
        Enumeration e = this.receiverQueues.elements();
        while (e.hasMoreElements()) {
            IQueueEnqueue queue = (IQueueEnqueue)e.nextElement();
            if (queue == null) continue;
            queue.enqueue((Event[])event);
        }
    }

    public ID getSenderID() {
        return this.sender;
    }

    public ID[] getReceiverIDs() {
        return this.receiverQueues.keySet().toArray(new ID[this.receiverQueues.size()]);
    }

    public void enqueue(ISharedObjectEvent event) throws QueueException {
        this.fireEvent(event);
    }

    public void enqueue(ISharedObjectEvent[] events) throws QueueException {
        this.fireEvents(events);
    }

    public void dispose() {
        if (this.receiverQueues != null) {
            this.receiverQueues.clear();
            this.receiverQueues = null;
        }
        this.sender = null;
    }
}

