/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.util.List;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;

public class IDUtil {
    public static IIDFactory getIDFactory() {
        return IDFactory.getDefault();
    }

    public static Namespace getNamespaceByName(String namespaceName) {
        if (namespaceName == null) {
            return null;
        }
        return IDUtil.getIDFactory().getNamespaceByName(namespaceName);
    }

    public static Namespace findNamespaceByIdName(String idName) {
        if (idName == null) {
            return null;
        }
        int colonIndex = idName.indexOf(":");
        if (colonIndex <= 0) {
            return null;
        }
        String scheme = idName.substring(0, colonIndex);
        Namespace ns = IDUtil.getNamespaceByName(scheme);
        return ns == null ? IDUtil.findNamespaceByScheme(scheme) : ns;
    }

    public static Namespace findNamespaceByScheme(String scheme) {
        if (scheme == null) {
            return null;
        }
        if (scheme.equals("ecftcp")) {
            return IDUtil.getIDFactory().getNamespaceByName(StringID.class.getName());
        }
        List namespaces = IDUtil.getIDFactory().getNamespaces();
        for (Namespace ns : namespaces) {
            if (!scheme.equals(ns.getScheme())) continue;
            return ns;
        }
        return null;
    }

    public static ID createID(String namespaceName, String idName) throws IDCreateException {
        Namespace ns;
        Namespace namespace = ns = namespaceName != null ? IDUtil.getNamespaceByName(namespaceName) : IDUtil.findNamespaceByIdName(idName);
        if (ns == null) {
            throw new IDCreateException("Cannot find Namespace for namespaceName=" + namespaceName + " and idName=" + idName);
        }
        return IDUtil.createID(ns, idName);
    }

    public static ID createID(Namespace namespace, String idName) throws IDCreateException {
        return IDUtil.getIDFactory().createID(namespace, idName);
    }

    public static ID createID(Namespace namespace, Object[] args) throws IDCreateException {
        return IDUtil.getIDFactory().createID(namespace, args);
    }
}

