/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.bittorrent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.eclipse.ecf.protocol.bittorrent.internal.encode.BEncodedDictionary;
import org.eclipse.ecf.protocol.bittorrent.internal.encode.Decode;

public class TorrentFile {
    static MessageDigest shaDigest;
    private final String[] filenames;
    private final String[] pieces;
    private final long[] lengths;
    private final byte[] torrentData;
    private final ByteBuffer buffer;
    private final BEncodedDictionary dictionary;
    private final String tracker;
    private final String infoHash;
    private final String hexHash;
    private File file;
    private String name;
    private long total;
    private final int pieceLength;
    private final int numPieces;

    static {
        try {
            shaDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TorrentFile(File file) throws IllegalArgumentException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("The file cannot be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("The provided file is a directory");
        }
        this.name = file.getName();
        if (this.name.endsWith(".torrent")) {
            this.name = this.name.substring(0, this.name.length() - 8);
        }
        this.dictionary = Decode.bDecode(new FileInputStream(file));
        this.torrentData = this.dictionary.toString().getBytes("ISO-8859-1");
        this.tracker = (String)this.dictionary.get("announce");
        BEncodedDictionary info = (BEncodedDictionary)this.dictionary.get("info");
        List list = (List)info.get("files");
        if (list != null) {
            this.filenames = new String[list.size()];
            this.lengths = new long[this.filenames.length];
            this.total = 0L;
            int i = 0;
            while (i < this.filenames.length) {
                StringBuffer buffer;
                BEncodedDictionary aDictionary = (BEncodedDictionary)list.get(i);
                this.lengths[i] = (Long)aDictionary.get("length");
                this.total += this.lengths[i];
                List aList = (List)aDictionary.get("path");
                StringBuffer stringBuffer = buffer = new StringBuffer();
                synchronized (stringBuffer) {
                    int j = 0;
                    while (j < aList.size()) {
                        buffer.append(aList.get(j)).append(File.separator);
                        ++j;
                    }
                }
                this.filenames[i] = buffer.toString();
                ++i;
            }
        } else {
            this.lengths = new long[]{(Long)info.get("length")};
            this.total = this.lengths[0];
            this.filenames = new String[]{(String)info.get("name")};
        }
        this.pieceLength = ((Long)info.get("piece length")).intValue();
        this.buffer = ByteBuffer.allocate(this.pieceLength);
        String shaPieces = (String)info.get("pieces");
        this.pieces = new String[shaPieces.length() / 20];
        int i = 0;
        while (i < this.pieces.length) {
            this.pieces[i] = shaPieces.substring(i * 20, i * 20 + 20);
            ++i;
        }
        this.numPieces = this.pieces.length;
        this.infoHash = new String(shaDigest.digest(info.toString().getBytes("ISO-8859-1")), "ISO-8859-1");
        byte[] bytes = this.infoHash.getBytes("ISO-8859-1");
        StringBuffer hash = new StringBuffer(40);
        int i2 = 0;
        while (i2 < bytes.length) {
            if (-1 < bytes[i2] && bytes[i2] < 16) {
                hash.append('0');
            }
            hash.append(Integer.toHexString(0xFF & bytes[i2]));
            ++i2;
        }
        this.hexHash = hash.toString();
    }

    private boolean hashCheckFile() throws FileNotFoundException, IOException {
        int remainder = (int)(this.file.length() % (long)this.pieceLength);
        int count = 0;
        FileChannel channel = new FileInputStream(this.file).getChannel();
        while (channel.read(this.buffer) == this.pieceLength) {
            this.buffer.rewind();
            if (!this.pieces[count].equals(new String(shaDigest.digest(this.buffer.array()), "ISO-8859-1"))) {
                return false;
            }
            ++count;
        }
        this.buffer.rewind();
        shaDigest.update(this.buffer.array(), 0, remainder);
        return this.pieces[this.pieces.length - 1].equals(new String(shaDigest.digest(), "ISO-8859-1"));
    }

    private boolean hashCheckFolder() throws FileNotFoundException, IOException {
        int read = 0;
        int count = 0;
        int i = 0;
        while (i < this.filenames.length) {
            File download = new File(this.file.getAbsolutePath(), this.filenames[i]);
            FileChannel channel = new FileInputStream(download).getChannel();
            while ((read += channel.read(this.buffer)) == this.pieceLength) {
                this.buffer.rewind();
                if (!this.pieces[count].equals(new String(shaDigest.digest(this.buffer.array()), "ISO-8859-1"))) {
                    return false;
                }
                ++count;
                read = 0;
            }
            ++i;
        }
        this.buffer.rewind();
        shaDigest.update(this.buffer.array(), 0, read);
        return this.pieces[this.pieces.length - 1].equals(new String(shaDigest.digest(), "ISO-8859-1"));
    }

    public boolean validate() throws IllegalStateException, IOException {
        if (this.file == null) {
            throw new IllegalStateException("The target file for this torrent has not yet been set");
        }
        return this.file.isDirectory() ? this.hashCheckFolder() : this.hashCheckFile();
    }

    public void setTargetFile(File file) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("The file cannot be null");
        }
        if (this.filenames.length == 1 && file.isDirectory()) {
            throw new IllegalArgumentException("This torrent is downloading a file, the actual file should be set here and not a directory");
        }
        this.file = file;
    }

    public String getInfoHash() {
        return this.infoHash;
    }

    public String getHexHash() {
        return this.hexHash;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public int getPieceLength() {
        return this.pieceLength;
    }

    public String getTracker() {
        return this.tracker;
    }

    public String[] getPieces() {
        return this.pieces;
    }

    public int getNumPieces() {
        return this.numPieces;
    }

    public String[] getFilenames() {
        return this.filenames;
    }

    public String getName() {
        return this.name;
    }

    public File getTargetFile() {
        return this.file;
    }

    public boolean isMultiFile() {
        return this.lengths.length != 1;
    }

    public long getTotalLength() {
        return this.total;
    }

    public void save(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(this.torrentData);
        fos.flush();
        fos.close();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TorrentFile) {
            return this.infoHash.equals(((TorrentFile)other).infoHash);
        }
        return false;
    }

    public int hashCode() {
        return this.infoHash.hashCode();
    }
}

