/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.provider.BaseContainerInstantiator;
import org.eclipse.ecf.core.provider.ContainerInstantiatorUtils;
import org.eclipse.ecf.core.provider.ContainerIntentException;
import org.eclipse.ecf.core.provider.IRemoteServiceContainerInstantiator;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.util.EndpointDescriptionPropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteServiceContainerInstantiator
extends BaseContainerInstantiator
implements IRemoteServiceContainerInstantiator {
    protected static final String[] defaultSupportedAdapterTypes = new String[]{IContainer.class.getName(), IRemoteServiceContainerAdapter.class.getName()};
    protected static final Class[][] defaultSupportedParameterTypes = new Class[][]{{Map.class}};
    protected static final String[] defaultSupportedIntents = new String[]{"osgi.basic", "passByValue", "exactlyOnce", "ordered"};
    protected List<String> exporterConfigs = new ArrayList<String>();
    protected Map<String, List<String>> exporterConfigToImporterConfigs = new HashMap<String, List<String>>();

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        return defaultSupportedAdapterTypes;
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        return defaultSupportedParameterTypes;
    }

    protected RemoteServiceContainerInstantiator(String exportingProvider, String importingProvider) {
        this();
        this.exporterConfigs.add(exportingProvider);
        this.exporterConfigToImporterConfigs.put(exportingProvider, Arrays.asList(importingProvider));
    }

    protected RemoteServiceContainerInstantiator(List<String> exporterConfigs, Map<String, List<String>> exporterConfigToImporterConfig) {
        this();
        this.exporterConfigs.addAll(exporterConfigs);
        this.exporterConfigToImporterConfigs.putAll(exporterConfigToImporterConfig);
    }

    protected RemoteServiceContainerInstantiator() {
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        ArrayList<String> results = new ArrayList<String>();
        String descriptionName = description.getName();
        if (this.exporterConfigs.contains(descriptionName)) {
            results.add(descriptionName);
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = exporterSupportedConfigs;
        int n = exporterSupportedConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            String exporterConfig = stringArray[n2];
            List<String> importerConfigs = this.exporterConfigToImporterConfigs.get(exporterConfig);
            if (importerConfigs != null) {
                for (String importerConfig : importerConfigs) {
                    if (!description.getName().equals(importerConfig)) continue;
                    results.add(importerConfig);
                }
            }
            ++n2;
        }
        return results.toArray(new String[results.size()]);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return null;
    }

    public abstract IContainer createInstance(ContainerTypeDescription var1, Map<String, ?> var2) throws ContainerCreateException;

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        return this.createInstance(description, this.getMap(parameters));
    }

    protected IContainer throwCreateException(String message, Throwable cause) throws ContainerCreateException {
        ContainerCreateException cce = new ContainerCreateException(message, cause);
        cce.setStackTrace(cause.getStackTrace());
        throw cce;
    }

    protected boolean supportsOSGIConfidentialIntent(ContainerTypeDescription description) {
        return false;
    }

    protected boolean supportsOSGIPrivateIntent(ContainerTypeDescription description) {
        return false;
    }

    protected boolean supportsOSGIAsyncIntent(ContainerTypeDescription description) {
        return false;
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        String[] s = defaultSupportedIntents;
        if (this.supportsOSGIAsyncIntent(description)) {
            s = RemoteServiceContainerInstantiator.addSupportedIntent("osgi.async", s);
        }
        if (this.supportsOSGIPrivateIntent(description)) {
            s = RemoteServiceContainerInstantiator.addSupportedIntent("osgi.private", s);
        }
        if (this.supportsOSGIConfidentialIntent(description)) {
            s = RemoteServiceContainerInstantiator.addSupportedIntent("osgi.confidential", s);
        }
        return s;
    }

    protected static String[] addSupportedIntent(String intent, String[] currentSupportedIntents) {
        if (intent == null) {
            return currentSupportedIntents;
        }
        ArrayList<String> results = currentSupportedIntents == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(currentSupportedIntents));
        results.add(intent);
        return results.toArray(new String[results.size()]);
    }

    protected static String[] removeSupportedIntent(String intent, String[] currentSupportedIntents) {
        if (intent == null) {
            return currentSupportedIntents;
        }
        ArrayList results = currentSupportedIntents == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(currentSupportedIntents));
        results.remove(intent);
        return results.toArray(new String[results.size()]);
    }

    protected void checkPrivate(ContainerTypeDescription description, String hostname) throws ContainerIntentException {
        ContainerInstantiatorUtils.checkPrivate((String)hostname);
    }

    protected List<String> getServiceIntents(Map<String, ?> properties) {
        return EndpointDescriptionPropertiesUtil.getStringPlusProperty(properties, "service.intents");
    }

    protected boolean checkIntentSupported(ContainerTypeDescription description, String intent) {
        String[] supportedIntents = this.getSupportedIntents(description);
        if (supportedIntents != null) {
            return Arrays.asList(supportedIntents).contains(intent);
        }
        return false;
    }

    protected boolean checkAsyncIntent(ContainerTypeDescription description, Map<String, ?> properties) throws ContainerIntentException {
        List<String> serviceIntents = this.getServiceIntents(properties);
        if (serviceIntents.contains("osgi.async")) {
            if (!this.checkIntentSupported(description, "osgi.async")) {
                throw new ContainerIntentException("osgi.async", "Intent not supported by distribution provider=" + description.getName());
            }
            return true;
        }
        return false;
    }

    protected boolean checkPrivateIntent(ContainerTypeDescription description, String hostname, Map<String, ?> properties) throws ContainerIntentException {
        List<String> serviceIntents = this.getServiceIntents(properties);
        if (serviceIntents.contains("osgi.private")) {
            if (!this.checkIntentSupported(description, "osgi.private")) {
                throw new ContainerIntentException("osgi.private", "Not supported by distribution provider=" + description.getName());
            }
            this.checkPrivate(description, hostname);
        }
        return false;
    }

    protected boolean checkConfidentialIntent(ContainerTypeDescription description, String uri, Map<String, ?> properties) throws ContainerIntentException {
        List<String> serviceIntents = this.getServiceIntents(properties);
        if (serviceIntents.contains("osgi.confidential")) {
            if (!this.checkIntentSupported(description, "osgi.confidential")) {
                throw new ContainerIntentException("osgi.confidential", "Intent not supported by distribution provider=" + description.getName());
            }
            this.checkConfidential(description, uri);
        }
        return false;
    }

    protected void checkConfidential(ContainerTypeDescription description, String uri) throws ContainerIntentException {
        if (uri != null && uri.startsWith("https")) {
            return;
        }
        throw new ContainerIntentException("osgi.confidential", "provider=" + description.getName() + " failed confientiality check for uri=" + uri);
    }

    protected void checkOSGIIntents(ContainerTypeDescription description, URI uri, Map<String, ?> properties) throws ContainerIntentException {
        this.checkAsyncIntent(description, properties);
        this.checkPrivateIntent(description, uri.getHost(), properties);
        this.checkConfidentialIntent(description, uri.toString(), properties);
    }
}

