/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.internal.ui.Activator;

public class PasswordCacheHelper {
    public static final URL FAKE_URL;
    public static final String AUTH_SCHEME = "";
    public static final String INFO_PASSWORD = "org.eclipse.ecf.ui.password";
    private String targetAuthority;

    static {
        URL temp = null;
        try {
            temp = new URL("http://org.eclipse.ecf.ui");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        FAKE_URL = temp;
    }

    public PasswordCacheHelper(String targetID) {
        this.targetAuthority = targetID;
        Assert.isNotNull((Object)this.targetAuthority);
    }

    public boolean savePassword(String password) {
        HashMap<String, String> map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)this.targetAuthority, (String)AUTH_SCHEME);
        if (map == null) {
            map = new HashMap<String, String>(10);
        }
        if (password != null) {
            map.put(INFO_PASSWORD, password);
        }
        try {
            Platform.addAuthorizationInfo((URL)FAKE_URL, (String)this.targetAuthority, (String)AUTH_SCHEME, map);
        }
        catch (CoreException e) {
            Activator.log("savePassword", e);
            return false;
        }
        return true;
    }

    public String retrievePassword() {
        Map map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)this.targetAuthority, (String)AUTH_SCHEME);
        if (map != null) {
            return (String)map.get(INFO_PASSWORD);
        }
        return null;
    }
}

