/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.bot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ecf.presence.bot.IIMMessageHandler;
import org.eclipse.ecf.presence.bot.IIMMessageHandlerEntry;
import org.eclipse.ecf.presence.im.IChatMessage;

public class IMMessageHandlerEntry
implements IIMMessageHandlerEntry {
    private String expression;
    private IIMMessageHandler handler;

    public IMMessageHandlerEntry(String expression, IIMMessageHandler handler) {
        this.expression = expression;
        this.handler = handler;
    }

    public String getExpression() {
        return this.expression;
    }

    public IIMMessageHandler getHandler() {
        return this.handler;
    }

    public void handleIMMessage(IChatMessage message) {
        if (this.expression == null || this.canExecute(message.getBody())) {
            this.handler.handleIMMessage(message);
        }
    }

    private boolean canExecute(String message) {
        Pattern pattern = Pattern.compile(this.getExpression(), 42);
        Matcher matcher = pattern.matcher(message);
        return matcher.matches();
    }
}

