/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.im;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.presence.IMMessage;
import org.eclipse.ecf.presence.im.IChatMessage;

public class ChatMessage
extends IMMessage
implements IChatMessage {
    private static final long serialVersionUID = 483032454041915204L;
    protected ID threadID;
    protected IChatMessage.Type type;
    protected String subject;
    protected String body;
    protected Map properties;

    public ChatMessage(ID fromID, ID threadID, IChatMessage.Type type, String subject, String body, Map properties) {
        super(fromID);
        this.threadID = threadID;
        this.type = type;
        this.subject = subject;
        this.body = body == null ? "" : body;
        this.properties = properties == null ? new HashMap() : properties;
    }

    public ChatMessage(ID fromID, ID threadID, String subject, String body, Map properties) {
        this(fromID, threadID, IChatMessage.Type.CHAT, subject, body, properties);
    }

    public ChatMessage(ID fromID, IChatMessage.Type type, String subject, String body, Map properties) {
        this(fromID, null, type, subject, body, properties);
    }

    public ChatMessage(ID fromID, String subject, String body, Map properties) {
        this(fromID, (ID)null, subject, body, properties);
    }

    public ChatMessage(ID fromID, String body, Map properties) {
        this(fromID, null, body, properties);
    }

    public ChatMessage(ID fromID, String body) {
        this(fromID, body, null);
    }

    public String getBody() {
        return this.body;
    }

    public String getSubject() {
        return this.subject;
    }

    public ID getThreadID() {
        return this.threadID;
    }

    public IChatMessage.Type getType() {
        return this.type;
    }

    public Map getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ChatMessage[");
        buf.append("fromID=").append(this.getFromID());
        buf.append(";threadID=").append(this.getThreadID());
        buf.append(";type=").append(this.getType());
        buf.append(";subject=").append(this.getSubject());
        buf.append(";body=").append(this.getBody());
        buf.append(";props=").append(this.getProperties());
        buf.append("]");
        return buf.toString();
    }
}

