/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ecf.core.variants;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.ResourceVariantTreeSubscriber;
import org.eclipse.team.internal.ecf.core.RemoteShare;
import org.eclipse.team.internal.ecf.core.RemoteSyncInfo;
import org.eclipse.team.internal.ecf.core.variants.RemoteResourceVariantComparator;
import org.eclipse.team.internal.ecf.core.variants.RemoteResourceVariantTree;

public class RemoteResourceVariantTreeSubscriber
extends ResourceVariantTreeSubscriber {
    private RemoteResourceVariantTree remoteTree;
    private IResource[] resources;
    private RemoteResourceVariantComparator comparator = new RemoteResourceVariantComparator();

    public RemoteResourceVariantTreeSubscriber(RemoteShare share, ID ownId, ID remoteId) {
        this.remoteTree = new RemoteResourceVariantTree(share, ownId, remoteId);
    }

    public void setResources(IResource[] resources) {
        this.resources = resources;
        this.remoteTree.setResources(resources);
    }

    protected IResourceVariantTree getBaseTree() {
        return null;
    }

    protected IResourceVariantTree getRemoteTree() {
        return this.remoteTree;
    }

    public String getName() {
        return "getName();";
    }

    public IResourceVariantComparator getResourceComparator() {
        return this.comparator;
    }

    public SyncInfo getSyncInfo(IResource local, IProgressMonitor monitor) throws TeamException {
        IResourceVariant remote = this.remoteTree.fetchVariant(local, 0, monitor);
        return this.getSyncInfo(local, null, remote);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        RemoteSyncInfo info = new RemoteSyncInfo(local, remote, this.comparator);
        info.init();
        return info;
    }

    public boolean isSupervised(IResource resource) {
        return true;
    }

    public IResource[] roots() {
        return this.resources == null ? new IResource[]{} : this.resources;
    }
}

