/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.filetransfer.ui.actions;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.IExceptionHandler;
import org.eclipse.ecf.filetransfer.FileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDoneEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.filetransfer.ui.Activator;
import org.eclipse.ecf.internal.filetransfer.ui.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractFileSendAction
extends Action {
    protected IFileID targetReceiver;
    protected IFileTransferInfo fileTransferInfo;
    protected IFileTransferListener fileTransferListener;
    protected Map options;
    protected IExceptionHandler exceptionHandler = null;

    public void setTargetReceiver(IFileID targetReceiver) {
        this.targetReceiver = targetReceiver;
    }

    public IFileID getTargetReceiver() {
        return this.targetReceiver;
    }

    public void setFileTransferInfo(IFileTransferInfo info) {
        this.fileTransferInfo = info;
    }

    public IFileTransferInfo getFileTransferInfo() {
        return this.fileTransferInfo;
    }

    public void setFileToSend(File fileToSend) {
        this.fileTransferInfo = this.createFileTransferInfoFromFile(fileToSend);
    }

    private IFileTransferInfo createFileTransferInfoFromFile(File fileToSend) {
        return new FileTransferInfo(fileToSend);
    }

    public File getFileToSend() {
        if (this.fileTransferInfo == null) {
            return null;
        }
        return this.fileTransferInfo.getFile();
    }

    public void setFileTransferListener(IFileTransferListener listener) {
        this.fileTransferListener = listener;
    }

    public IFileTransferListener getFileTransferListener() {
        return this.fileTransferListener;
    }

    public void setFileTransferOptions(Map options) {
        this.options = options;
    }

    public Map getFileTransferOptions() {
        return this.options;
    }

    public void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public IExceptionHandler getExceptionhandler() {
        return this.exceptionHandler;
    }

    public void run() {
        try {
            this.sendFileToTarget();
        }
        catch (Exception e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handleException((Throwable)e);
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.filetransfer.ui", 4, NLS.bind((String)Messages.getString("AbstractFileSendAction.EXCEPTION_SENDING_TO_TARGET"), (Object)this.getTargetReceiver()), (Throwable)e));
        }
    }

    protected abstract ISendFileTransferContainerAdapter getOutgoingFileTransferAdapter();

    protected void sendFileToTarget() throws Exception {
        IFileID target = this.getTargetReceiver();
        Assert.isNotNull((Object)target, (String)Messages.getString("AbstractFileSendAction.RECEIVER_NOT_NULL"));
        ISendFileTransferContainerAdapter adapter = this.getOutgoingFileTransferAdapter();
        Assert.isNotNull((Object)adapter, (String)Messages.getString("AbstractFileSendAction.ADAPTER_NOT_NULL"));
        IFileTransferListener listener = this.getFileTransferListener();
        if (listener == null) {
            listener = this.createDefaultFileTransferListener();
        }
        Assert.isNotNull((Object)listener, (String)Messages.getString("AbstractFileSendAction.LISTENER_NOT_NULL"));
        IFileTransferInfo info = this.getFileTransferInfo();
        Assert.isNotNull((Object)info, (String)Messages.getString("AbstractFileSendAction.FILE_NOT_NULL"));
        adapter.sendOutgoingRequest(target, info, listener, this.options);
    }

    protected IFileTransferListener createDefaultFileTransferListener() {
        return new IFileTransferListener(){

            public void handleTransferEvent(IFileTransferEvent event) {
                if (event instanceof IOutgoingFileTransferSendDoneEvent) {
                    IOutgoingFileTransferSendDoneEvent oftsde = (IOutgoingFileTransferSendDoneEvent)event;
                    Exception errorException = oftsde.getSource().getException();
                    Display.getDefault().asyncExec(new Runnable(this, errorException){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Exception val$errorException;
                        {
                            this.this$1 = var1_1;
                            this.val$errorException = exception;
                        }

                        public void run() {
                            if (this.val$errorException == null) {
                                MessageDialog.openInformation(null, (String)Messages.getString("AbstractFileSendAction.TITLE_FILE_TRANSFER_SUCESSFUL"), (String)NLS.bind((String)Messages.getString("AbstractFileSendAction.MESSAGE_FILE_TRANSFER_SUCCESSFUL"), (Object)1.access$0(this.this$1).getFileTransferInfo().getFile().getName()));
                            } else {
                                MessageDialog.openError(null, (String)Messages.getString("AbstractFileSendAction.TITLE_FILE_TRANSFER_FAILED"), (String)NLS.bind((String)Messages.getString("AbstractFileSendAction.MESSAGE_FILE_TRANSFER_FAILED"), (Object)this.val$errorException.getLocalizedMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ AbstractFileSendAction access$0(1 var0) {
                return var0.AbstractFileSendAction.this;
            }
        };
    }
}

