/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpServiceComponent {
    private static final String SLASH = "/";
    private Collection<HttpService> httpServices = new ArrayList<HttpService>();
    private BundleContext context;
    private static HttpServiceComponent instance;

    public static HttpServiceComponent getDefault() {
        return instance;
    }

    public Collection<HttpService> getHttpServices() {
        return this.httpServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindHttpService(HttpService httpService) {
        if (httpService != null) {
            Collection<HttpService> collection = this.httpServices;
            synchronized (collection) {
                this.httpServices.add(httpService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindHttpService(HttpService httpService) {
        if (httpService != null) {
            Collection<HttpService> collection = this.httpServices;
            synchronized (collection) {
                this.httpServices.remove(httpService);
            }
        }
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected void activate(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        instance = this;
    }

    protected void deactivate() throws Exception {
        this.httpServices.clear();
        this.context = null;
        instance = null;
    }

    public void registerServlet(Class service, Servlet servlet, Dictionary dictionary, HttpContext httpContext) throws ServletException, NamespaceException {
        this.registerServlet(SLASH + service.getName(), servlet, dictionary, httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServlet(String path, Servlet servlet, Dictionary dictionary, HttpContext httpContext) throws ServletException, NamespaceException {
        Collection<HttpService> collection = this.httpServices;
        synchronized (collection) {
            for (HttpService httpService : this.httpServices) {
                httpService.registerServlet(path, servlet, dictionary, httpContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServlet(String path) {
        Collection<HttpService> collection = this.httpServices;
        synchronized (collection) {
            for (HttpService httpService : this.httpServices) {
                httpService.unregister(path);
            }
        }
    }

    public void unregisterServlet(Class service) {
        this.unregisterServlet(SLASH + service.getName());
    }

    public <T> T getService(Class<T> service) {
        if (this.context == null) {
            return null;
        }
        ServiceReference ref = this.context.getServiceReference(service);
        if (ref == null) {
            return null;
        }
        return (T)this.context.getService(ref);
    }
}

