/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmackConfiguration {
    private static final String SMACK_VERSION = "3.3.0";
    private static int packetReplyTimeout = 5000;
    private static int keepAliveInterval = 30000;
    private static Vector<String> defaultMechs = new Vector();
    private static boolean localSocks5ProxyEnabled = true;
    private static int localSocks5ProxyPort = 7777;
    private static int packetCollectorSize = 5000;
    private static boolean autoEnableEntityCaps = false;

    static {
        try {
            ClassLoader[] classLoaders;
            ClassLoader[] classLoaderArray = classLoaders = SmackConfiguration.getClassLoaders();
            int n = classLoaders.length;
            int n2 = 0;
            while (n2 < n) {
                ClassLoader classLoader = classLoaderArray[n2];
                Enumeration<URL> configEnum = classLoader.getResources("META-INF/smack-config.xml");
                while (configEnum.hasMoreElements()) {
                    URL url = configEnum.nextElement();
                    InputStream systemStream = null;
                    try {
                        try {
                            systemStream = url.openStream();
                            MXParser parser = new MXParser();
                            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                            parser.setInput(systemStream, "UTF-8");
                            int eventType = parser.getEventType();
                            do {
                                if (eventType != 2) continue;
                                if (parser.getName().equals("className")) {
                                    SmackConfiguration.parseClassToLoad((XmlPullParser)parser);
                                    continue;
                                }
                                if (parser.getName().equals("packetReplyTimeout")) {
                                    packetReplyTimeout = SmackConfiguration.parseIntProperty((XmlPullParser)parser, packetReplyTimeout);
                                    continue;
                                }
                                if (parser.getName().equals("keepAliveInterval")) {
                                    keepAliveInterval = SmackConfiguration.parseIntProperty((XmlPullParser)parser, keepAliveInterval);
                                    continue;
                                }
                                if (parser.getName().equals("mechName")) {
                                    defaultMechs.add(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("localSocks5ProxyEnabled")) {
                                    localSocks5ProxyEnabled = Boolean.parseBoolean(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("localSocks5ProxyPort")) {
                                    localSocks5ProxyPort = SmackConfiguration.parseIntProperty((XmlPullParser)parser, localSocks5ProxyPort);
                                    continue;
                                }
                                if (parser.getName().equals("packetCollectorSize")) {
                                    packetCollectorSize = SmackConfiguration.parseIntProperty((XmlPullParser)parser, packetCollectorSize);
                                    continue;
                                }
                                if (!parser.getName().equals("autoEnableEntityCaps")) continue;
                                autoEnableEntityCaps = Boolean.parseBoolean(parser.nextText());
                            } while ((eventType = parser.next()) != 1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                systemStream.close();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            systemStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        systemStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SmackConfiguration() {
    }

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getPacketReplyTimeout() {
        if (packetReplyTimeout <= 0) {
            packetReplyTimeout = 5000;
        }
        return packetReplyTimeout;
    }

    public static void setPacketReplyTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        packetReplyTimeout = timeout;
    }

    public static int getKeepAliveInterval() {
        return keepAliveInterval;
    }

    public static void setKeepAliveInterval(int interval) {
        keepAliveInterval = interval;
    }

    public static int getPacketCollectorSize() {
        return packetCollectorSize;
    }

    public static void setPacketCollectorSize(int collectorSize) {
        packetCollectorSize = collectorSize;
    }

    public static void addSaslMech(String mech) {
        if (!defaultMechs.contains(mech)) {
            defaultMechs.add(mech);
        }
    }

    public static void addSaslMechs(Collection<String> mechs) {
        for (String mech : mechs) {
            SmackConfiguration.addSaslMech(mech);
        }
    }

    public static void removeSaslMech(String mech) {
        if (defaultMechs.contains(mech)) {
            defaultMechs.remove(mech);
        }
    }

    public static void removeSaslMechs(Collection<String> mechs) {
        for (String mech : mechs) {
            SmackConfiguration.removeSaslMech(mech);
        }
    }

    public static List<String> getSaslMechs() {
        return defaultMechs;
    }

    public static boolean isLocalSocks5ProxyEnabled() {
        return localSocks5ProxyEnabled;
    }

    public static void setLocalSocks5ProxyEnabled(boolean localSocks5ProxyEnabled) {
        SmackConfiguration.localSocks5ProxyEnabled = localSocks5ProxyEnabled;
    }

    public static int getLocalSocks5ProxyPort() {
        return localSocks5ProxyPort;
    }

    public static void setLocalSocks5ProxyPort(int localSocks5ProxyPort) {
        SmackConfiguration.localSocks5ProxyPort = localSocks5ProxyPort;
    }

    public static boolean autoEnableEntityCaps() {
        return autoEnableEntityCaps;
    }

    public static void setAutoEnableEntityCaps(boolean b) {
        autoEnableEntityCaps = b;
    }

    private static void parseClassToLoad(XmlPullParser parser) throws Exception {
        String className = parser.nextText();
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Error! A startup class specified in smack-config.xml could not be loaded: " + className);
        }
    }

    private static int parseIntProperty(XmlPullParser parser, int defaultValue) throws Exception {
        try {
            return Integer.parseInt(parser.nextText());
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return defaultValue;
        }
    }

    private static ClassLoader[] getClassLoaders() {
        ClassLoader[] classLoaders = new ClassLoader[]{SmackConfiguration.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader[] classLoaderArray = classLoaders;
        int n = classLoaders.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classLoader = classLoaderArray[n2];
            if (classLoader != null) {
                loaders.add(classLoader);
            }
            ++n2;
        }
        return loaders.toArray(new ClassLoader[loaders.size()]);
    }
}

