/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.IConnectInitiatorPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.internal.server.generic.Activator;
import org.eclipse.ecf.provider.generic.ClientSOContainer;
import org.eclipse.ecf.server.generic.app.AbstractGenericClientApplication;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class SSLGenericClientApplication
extends AbstractGenericClientApplication
implements IApplication {
    protected static final String GENERIC_SSL_CLIENT = "ecf.generic.ssl.client";
    protected final Object appLock = new Object();
    protected boolean done = false;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = this.getArguments(context);
        this.processArguments(args);
        this.initialize();
        this.connect();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.dispose();
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
    }

    @Override
    protected ISharedObjectContainer createContainer() throws ContainerCreateException {
        IContainerFactory f = Activator.getDefault().getContainerManager().getContainerFactory();
        ClientSOContainer client = (ClientSOContainer)(this.clientId == null ? f.createContainer(GENERIC_SSL_CLIENT) : f.createContainer(GENERIC_SSL_CLIENT, this.clientId));
        if (this.password != null) {
            client.setConnectInitiatorPolicy(new IConnectInitiatorPolicy(){

                public void refresh() {
                }

                public Object createConnectData(IContainer container, ID targetID, IConnectContext context) {
                    return SSLGenericClientApplication.this.password;
                }

                public int getConnectTimeout() {
                    return 30000;
                }
            });
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected String[] getArguments(IApplicationContext context) {
        return (String[])context.getArguments().get("application.args");
    }
}

