/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.AbstractRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallStartEvent;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;

public abstract class AbstractClientService
extends AbstractRemoteService {
    private long nextID = 0L;
    protected RemoteServiceClientRegistration registration;
    protected AbstractClientContainer container;

    public AbstractClientService(AbstractClientContainer container, RemoteServiceClientRegistration registration) {
        this.container = container;
        Assert.isNotNull((Object)container);
        this.registration = registration;
        Assert.isNotNull((Object)this.registration);
    }

    public Object callSync(IRemoteCall call) throws ECFException {
        IRemoteCallable callable = this.getRegistration().lookupCallable(call);
        if (callable == null) {
            throw new ECFException("Callable not found for call=" + call);
        }
        return this.invokeRemoteCall(call, callable);
    }

    public IFuture callAsync(IRemoteCall call) {
        return this.callAsync(call, this.getRegistration().lookupCallable(call));
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        this.callAsync(call, this.getRegistration().lookupCallable(call), listener);
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        IRemoteCallable callable = this.getRegistration().lookupCallable(call);
        if (callable == null) {
            throw new ECFException("Remote callable not found");
        }
        this.callAsync(call, callable);
    }

    protected Object invokeSync(IRemoteCall remoteCall) throws ECFException {
        IRemoteCallable callable = this.getRegistration().lookupCallable(remoteCall);
        if (callable == null) {
            throw new ECFException("Callable not found for call=" + remoteCall);
        }
        return this.invokeRemoteCall(remoteCall, callable);
    }

    protected Object[] getCallParametersForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return args;
    }

    protected String getCallMethodNameForProxyInvoke(Method method, Object[] args) {
        return RemoteServiceClientRegistration.getFQMethod(method.getDeclaringClass().getName(), method.getName());
    }

    protected long getNextRequestID() {
        return this.nextID++;
    }

    protected void callAsync(IRemoteCall call, IRemoteCallable restClientCallable, IRemoteCallListener listener) {
        ThreadsExecutor executor = new ThreadsExecutor();
        executor.execute((IProgressRunnable)new AsyncResult(call, restClientCallable, listener), null);
    }

    protected IFuture callAsync(final IRemoteCall call, final IRemoteCallable callable) {
        ThreadsExecutor executor = new ThreadsExecutor();
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                if (callable == null) {
                    throw new ECFException("Callable not found");
                }
                return AbstractClientService.this.invokeRemoteCall(call, callable);
            }
        }, null);
    }

    protected void handleInvokeException(String message, Throwable e) throws ECFException {
        throw new ECFException(message, e);
    }

    protected AbstractClientContainer getClientContainer() {
        return this.container;
    }

    protected RemoteServiceClientRegistration getRegistration() {
        return this.registration;
    }

    protected String prepareEndpointAddress(IRemoteCall call, IRemoteCallable callable) {
        return this.getClientContainer().prepareEndpointAddress(call, callable);
    }

    protected IRemoteCallParameter[] prepareParameters(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        return this.getClientContainer().prepareParameters(uri, call, callable);
    }

    protected Object processResponse(String uri, IRemoteCall call, IRemoteCallable callable, Map responseHeaders, byte[] responseBody) throws NotSerializableException {
        return this.getClientContainer().processResponse(uri, call, callable, responseHeaders, responseBody);
    }

    protected IRemoteServiceID getRemoteServiceID() {
        return this.registration.getID();
    }

    protected IRemoteServiceReference getRemoteServiceReference() {
        return this.registration.getReference();
    }

    protected String[] getInterfaceClassNames() {
        return this.registration.getClazzes();
    }

    protected UriRequest createUriRequest(String endpoint, IRemoteCall call, IRemoteCallable callable) {
        return this.getClientContainer().createUriRequest(endpoint, call, callable);
    }

    protected abstract Object invokeRemoteCall(IRemoteCall var1, IRemoteCallable var2) throws ECFException;

    protected class AsyncResult
    implements IProgressRunnable {
        IRemoteCall call;
        IRemoteCallable callable;
        IRemoteCallListener listener;
        Object result;
        Throwable exception;

        public AsyncResult(IRemoteCall call, IRemoteCallable callable, IRemoteCallListener listener) {
            this.call = call;
            this.callable = callable;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(IProgressMonitor monitor) throws Exception {
            Object r = null;
            Throwable e = null;
            final long reqID = AbstractClientService.this.getNextRequestID();
            if (this.listener != null) {
                this.listener.handleEvent(new IRemoteCallStartEvent(){

                    public IRemoteCall getCall() {
                        return AsyncResult.this.call;
                    }

                    public IRemoteServiceReference getReference() {
                        return AbstractClientService.this.getRegistration().getReference();
                    }

                    public long getRequestId() {
                        return reqID;
                    }
                });
            }
            try {
                if (this.callable == null) {
                    throw new ECFException("Restcall not found for method=" + this.call.getMethod());
                }
                r = AbstractClientService.this.invokeRemoteCall(this.call, this.callable);
            }
            catch (Throwable t) {
                e = t;
            }
            AsyncResult asyncResult = this;
            synchronized (asyncResult) {
                this.result = r;
                this.exception = e;
                this.notify();
            }
            if (this.listener != null) {
                this.listener.handleEvent(new IRemoteCallCompleteEvent(){

                    public Throwable getException() {
                        return AsyncResult.this.exception;
                    }

                    public Object getResponse() {
                        return AsyncResult.this.result;
                    }

                    public boolean hadException() {
                        return AsyncResult.this.exception != null;
                    }

                    public long getRequestId() {
                        return reqID;
                    }
                });
            }
            return null;
        }
    }

    public static class UriRequest {
        private final String uri;
        private final IRemoteCall call;
        private final IRemoteCallable callable;

        public UriRequest(String uri, IRemoteCall call, IRemoteCallable callable) {
            this.uri = uri;
            this.call = call;
            this.callable = callable;
        }

        public String getUri() {
            return this.uri;
        }

        public IRemoteCall getRemoteCall() {
            return this.call;
        }

        public IRemoteCallable getRemoteCallable() {
            return this.callable;
        }
    }
}

