/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.user;

import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.core.ECFPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
implements IUser {
    private static final long serialVersionUID = 3978709484518586169L;
    protected ID id;
    protected String name;
    protected String nickname;
    protected Map properties;

    public User(ID userID) {
        this(userID, userID.getName());
    }

    public User(ID userID, String name) {
        this(userID, name, null);
    }

    public User(ID userID, String name, Map properties) {
        this(userID, name, null, properties);
    }

    public User(ID userID, String name, String nickname, Map properties) {
        this.id = userID;
        this.name = name;
        this.nickname = nickname;
        this.properties = properties;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    public ID getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this)) {
            return adapter.cast(this);
        }
        IAdapterManager adapterManager = ECFPlugin.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return (T)adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("User[");
        sb.append("id=" + this.getID()).append(";name=" + this.getName());
        sb.append(";nickname=").append(this.getNickname());
        sb.append(";props=" + this.getProperties()).append("]");
        return sb.toString();
    }
}

