/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.internal.ui.wizards.WorkbenchWizardElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;

public abstract class WizardNode
implements IWizardNode,
IPluginContribution {
    protected IWizard wizard;
    protected IWorkbench workbench;
    protected WorkbenchWizardElement wizardElement;
    protected WizardPage parentWizardPage;

    public WizardNode(IWorkbench workbench, WizardPage wizardPage, WorkbenchWizardElement wizardElement) {
        this.workbench = workbench;
        this.parentWizardPage = wizardPage;
        this.wizardElement = wizardElement;
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected WorkbenchWizardElement getWizardElement() {
        return this.wizardElement;
    }

    public void dispose() {
    }

    public Point getExtent() {
        return new Point(-1, -1);
    }

    public String getLocalId() {
        IPluginContribution contribution = (IPluginContribution)this.wizardElement.getAdapter(IPluginContribution.class);
        if (contribution != null) {
            return contribution.getLocalId();
        }
        return this.wizardElement.getId();
    }

    public String getPluginId() {
        IPluginContribution contribution = (IPluginContribution)this.wizardElement.getAdapter(IPluginContribution.class);
        if (contribution != null) {
            return contribution.getLocalId();
        }
        return null;
    }

    public abstract IWizard createWizard() throws CoreException;

    public IWizard getWizard() {
        if (this.wizard != null) {
            return this.wizard;
        }
        final IWizard[] newWizard = new IWizard[1];
        final IStatus[] statuses = new IStatus[1];
        BusyIndicator.showWhile((Display)this.parentWizardPage.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void handleException(Throwable e) {
                        IPluginContribution contribution = (IPluginContribution)(this).WizardNode.this.wizardElement.getAdapter(IPluginContribution.class);
                        statuses[0] = new Status(4, contribution != null ? contribution.getPluginId() : "org.eclipse.ecf.ui", 0, e.getMessage() == null ? "" : e.getMessage(), e);
                    }

                    public void run() {
                        try {
                            newWizard[0] = WizardNode.this.createWizard();
                        }
                        catch (CoreException e) {
                            statuses[0] = e.getStatus();
                        }
                    }
                });
            }
        });
        if (statuses[0] != null) {
            this.parentWizardPage.setErrorMessage("The selected wizard could not be started.");
            ErrorDialog.openError((Shell)this.parentWizardPage.getShell(), (String)"Problem Opening Wizard", (String)"The selected wizard could not be started.", (IStatus)statuses[0]);
            return null;
        }
        this.wizard = newWizard[0];
        return this.wizard;
    }

    public boolean isContentCreated() {
        return this.wizard != null;
    }
}

