/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.console;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ECFCommandProvider
implements CommandProvider {
    public static final String NEW_LINE = System.getProperty("line.separator", "\n");
    private BundleContext context;
    private ServiceTracker containerManagerTracker;
    static /* synthetic */ Class class$0;

    public ECFCommandProvider(BundleContext context) {
        this.context = context;
    }

    private IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }

    private IContainerFactory getContainerFactory() {
        return this.getContainerManager().getContainerFactory();
    }

    public void dispose() {
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        this.context = null;
    }

    private IContainer createContainer(CommandInterpreter interpreter, String containerTypeDescriptionName, String[] args) {
        IContainerFactory containerFactory = this.getContainerFactory();
        try {
            if (containerTypeDescriptionName == null) {
                return containerFactory.createContainer();
            }
            if (args == null) {
                return containerFactory.createContainer(containerTypeDescriptionName);
            }
            return containerFactory.createContainer(containerTypeDescriptionName, (Object[])args);
        }
        catch (Exception e) {
            this.printException(interpreter, "Could not create container with type=" + containerTypeDescriptionName, e);
            return null;
        }
    }

    private void printException(CommandInterpreter interpreter, String message, Throwable t) {
        interpreter.println((Object)"--Exception--");
        if (message != null) {
            interpreter.println((Object)message);
        }
        if (t != null) {
            interpreter.printStackTrace(t);
        }
        interpreter.println((Object)"--End Exception--");
    }

    private String[] getArgs(CommandInterpreter interpreter) {
        ArrayList<String> result = new ArrayList<String>();
        String arg = null;
        while ((arg = interpreter.nextArgument()) != null) {
            result.add(arg);
        }
        return result.toArray(new String[0]);
    }

    private String[] getRemainingArgs(String[] args, int startPosition) {
        int targetLength = args.length - startPosition;
        String[] result = new String[targetLength];
        System.arraycopy(args, startPosition, result, 0, targetLength);
        return result;
    }

    public void _createcontainer(CommandInterpreter interpreter) {
        String[] targetArgs;
        String[] args = this.getArgs(interpreter);
        String factoryName = args.length == 0 ? null : args[0];
        IContainer c = this.createContainer(interpreter, factoryName, targetArgs = args.length == 0 ? null : this.getRemainingArgs(args, 1));
        if (c != null) {
            interpreter.print((Object)"container created. ");
            this.printID(interpreter, c.getID());
        }
    }

    private void printContainer(CommandInterpreter interpreter, IContainer container, boolean verbose) {
        interpreter.println((Object)"--Container--");
        this.printID(interpreter, container.getID());
        if (verbose) {
            interpreter.print((Object)"\tclass=");
            interpreter.println((Object)container.getClass().getName());
            ID connectedID = container.getConnectedID();
            if (connectedID != null) {
                interpreter.print((Object)"\tConnected to: ");
                this.printID(interpreter, connectedID);
            } else {
                interpreter.println((Object)"\tNot connected.");
            }
            Namespace ns = container.getConnectNamespace();
            if (ns != null) {
                interpreter.print((Object)"\tConnect namespace: ");
                interpreter.println((Object)ns.getName());
            } else {
                interpreter.println((Object)"\tNo connect namespace.");
            }
            ContainerTypeDescription desc = this.getContainerManager().getContainerTypeDescription(container.getID());
            if (desc != null) {
                this.printDescription(interpreter, desc);
            }
        }
        interpreter.println((Object)"--End Container--");
    }

    private void printDescription(CommandInterpreter interpreter, ContainerTypeDescription desc) {
        interpreter.print((Object)"\tFactory name=");
        interpreter.println((Object)desc.getName());
        interpreter.print((Object)"\tFactory description=");
        interpreter.println((Object)desc.getDescription());
        String[] arr = desc.getSupportedIntents();
        if (arr != null) {
            interpreter.print((Object)"\tSupported intents=");
            interpreter.println(Arrays.asList(arr));
        }
        if ((arr = desc.getSupportedConfigs()) != null) {
            interpreter.print((Object)"\tSupported configs=");
            interpreter.println(Arrays.asList(arr));
        }
        if ((arr = desc.getSupportedAdapterTypes()) != null) {
            interpreter.print((Object)"\tSupported adapters=");
            interpreter.println(Arrays.asList(arr));
        }
        interpreter.println((Object)("\tHidden=" + desc.isHidden()));
        interpreter.println((Object)("\tServer=" + desc.isServer()));
    }

    public void _listcontainers(CommandInterpreter interpreter) {
        String[] args = this.getArgs(interpreter);
        boolean verbose = args.length < 1 ? false : new Boolean(args[0]);
        IContainer[] containers = this.getContainerManager().getAllContainers();
        if (containers == null || containers.length == 0) {
            interpreter.println((Object)"No containers found.");
        }
        int i = 0;
        while (i < containers.length) {
            this.printContainer(interpreter, containers[i], verbose);
            ++i;
        }
    }

    public void _listfactories(CommandInterpreter interpreter) {
        List descs = this.getContainerManager().getContainerFactory().getDescriptions();
        if (descs == null || descs.size() == 0) {
            interpreter.println((Object)"No factories.");
        }
        Iterator i = descs.iterator();
        while (i.hasNext()) {
            ContainerTypeDescription desc = (ContainerTypeDescription)i.next();
            this.printDescription(interpreter, desc);
        }
    }

    private void printID(CommandInterpreter interpreter, ID id) {
        interpreter.print((Object)"\tID:");
        if (id == null) {
            interpreter.println((Object)"null");
            return;
        }
        interpreter.print((Object)("ns=" + id.getNamespace().getName()));
        interpreter.print((Object)";name=");
        interpreter.print((Object)id.getName());
        interpreter.println();
    }

    public void _destroycontainer(CommandInterpreter interpreter) {
        String[] args = this.getArgs(interpreter);
        if (args == null || args.length != 2) {
            interpreter.println((Object)"Incorrect number of arguments for container destroy");
            return;
        }
        ID id = this.createID(interpreter, args[0], args[1]);
        if (id == null) {
            return;
        }
        IContainer container = this.getContainerManager().removeContainer(id);
        if (container == null) {
            interpreter.println((Object)"Container not found to remove");
            return;
        }
        container.dispose();
        interpreter.println((Object)"Container destroyed.");
    }

    private ID createID(CommandInterpreter interpreter, String namespace, String val) {
        try {
            return IDFactory.getDefault().createID(namespace, val);
        }
        catch (Exception e) {
            interpreter.printStackTrace((Throwable)e);
            return null;
        }
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append(NEW_LINE);
        help.append("---");
        help.append("Eclipse Communication Framework (ECF) Commands");
        help.append("---");
        help.append(NEW_LINE);
        help.append("\tlistfactories -- List all container factories.");
        help.append(NEW_LINE);
        help.append("\tlistcontainers [verbose] -- List all existing containers.");
        help.append(NEW_LINE);
        help.append("\tcreatecontainer [<containerFactoryName> [<arg0> <arg1>...]] -- Create new container.");
        help.append(NEW_LINE);
        help.append("\tdestroycontainer <namespace> <id> -- Remove and dispose container specified by namespace/id combination.");
        help.append(NEW_LINE);
        return help.toString();
    }
}

