/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionAdvertiser;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionAdvertiser;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.remoteserviceadmin";
    private static BundleContext context;
    private static Activator instance;
    private ServiceRegistration remoteServiceAdminRegistration;
    private EndpointDescriptionLocator endpointDescriptionLocator;
    private EndpointDescriptionAdvertiser endpointDescriptionAdvertiser;
    private ServiceRegistration endpointDescriptionAdvertiserRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private Object logServiceTrackerLock = new Object();
    private Object saxParserFactoryTrackerLock = new Object();
    private ServiceTracker saxParserFactoryTracker;
    private static final String RSA_PROXY_BUNDLE_SYMBOLIC_ID = "org.eclipse.ecf.osgi.services.remoteserviceadmin.proxy";
    private BundleContext proxyServiceFactoryBundleContext;
    private Map<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin> remoteServiceAdmins = new HashMap<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin>(1);

    public static BundleContext getContext() {
        return context;
    }

    public static Activator getDefault() {
        return instance;
    }

    public IContainerManager getContainerManager() {
        return (IContainerManager)ContainerFactory.getDefault();
    }

    private void initializeProxyServiceFactoryBundle() throws Exception {
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (RSA_PROXY_BUNDLE_SYMBOLIC_ID.equals(b.getSymbolicName())) {
                b.start();
                this.proxyServiceFactoryBundleContext = b.getBundleContext();
            }
            ++n2;
        }
        if (this.proxyServiceFactoryBundleContext == null) {
            throw new IllegalStateException("RSA Proxy bundle (symbolic id=='org.eclipse.ecf.osgi.services.remoteserviceadmin.proxy') cannot be found, so RSA cannot be started");
        }
    }

    private void stopProxyServiceFactoryBundle() {
        if (this.proxyServiceFactoryBundleContext != null) {
            try {
                this.proxyServiceFactoryBundleContext.getBundle().stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.proxyServiceFactoryBundleContext = null;
        }
    }

    public BundleContext getProxyServiceFactoryBundleContext() {
        return this.proxyServiceFactoryBundleContext;
    }

    private String[][] getSupportedConfigsAndIntents() {
        IContainerManager containerManager = this.getContainerManager();
        Assert.isNotNull((Object)containerManager, (String)"Container manager must be present to start ECF Remote Service Admin");
        ContainerTypeDescription[] remoteServiceDescriptions = containerManager.getContainerFactory().getDescriptionsForContainerAdapter(IRemoteServiceContainerAdapter.class);
        ArrayList<String> supportedConfigs = new ArrayList<String>();
        ArrayList<String> supportedIntents = new ArrayList<String>();
        int i = 0;
        while (i < remoteServiceDescriptions.length) {
            String[] descSupportedConfigs = remoteServiceDescriptions[i].getSupportedConfigs();
            if (descSupportedConfigs != null) {
                int j = 0;
                while (j < descSupportedConfigs.length) {
                    supportedConfigs.add(descSupportedConfigs[j]);
                    ++j;
                }
                String[] descSupportedIntents = remoteServiceDescriptions[i].getSupportedIntents();
                int j2 = 0;
                while (j2 < descSupportedIntents.length) {
                    supportedIntents.add(descSupportedIntents[j2]);
                    ++j2;
                }
            }
            ++i;
        }
        String[][] result = new String[][]{supportedConfigs.toArray(new String[supportedConfigs.size()]), supportedIntents.toArray(new String[supportedIntents.size()])};
        return result;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        instance = this;
        this.initializeProxyServiceFactoryBundle();
        Properties rsaProps = new Properties();
        rsaProps.put("org.eclipse.ecf.rsa", new Boolean(true));
        String[][] supportedConfigsAndIntents = this.getSupportedConfigsAndIntents();
        rsaProps.put("remote.configs.supported", supportedConfigsAndIntents[0]);
        rsaProps.put("remote.intents.supported", supportedConfigsAndIntents[1]);
        this.remoteServiceAdminRegistration = context.registerService(RemoteServiceAdmin.class.getName(), (Object)new ServiceFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getService(Bundle bundle, ServiceRegistration registration) {
                org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin result = null;
                Map map = Activator.this.remoteServiceAdmins;
                synchronized (map) {
                    org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin rsa = (org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin)Activator.this.remoteServiceAdmins.get(bundle);
                    if (rsa == null) {
                        rsa = new org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin(bundle);
                        Activator.this.remoteServiceAdmins.put(bundle, rsa);
                    }
                    result = rsa;
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                Map map = Activator.this.remoteServiceAdmins;
                synchronized (map) {
                    org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin rsa = (org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin)Activator.this.remoteServiceAdmins.remove(bundle);
                    if (rsa != null) {
                        rsa.close();
                    }
                }
            }
        }, (Dictionary)rsaProps);
        this.endpointDescriptionLocator = new EndpointDescriptionLocator(context);
        Properties properties = new Properties();
        properties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        this.endpointDescriptionAdvertiser = new EndpointDescriptionAdvertiser(this.endpointDescriptionLocator);
        this.endpointDescriptionAdvertiserRegistration = context.registerService(IEndpointDescriptionAdvertiser.class.getName(), (Object)this.endpointDescriptionAdvertiser, (Dictionary)properties);
        this.endpointDescriptionLocator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRSAs() {
        Map<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin> map = this.remoteServiceAdmins;
        synchronized (map) {
            Iterator<Map.Entry<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin>> i = this.remoteServiceAdmins.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Bundle, org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin> entry = i.next();
                org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin rsa = entry.getValue();
                rsa.close();
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        if (this.endpointDescriptionLocator != null) {
            this.endpointDescriptionLocator.close();
            this.endpointDescriptionLocator = null;
        }
        if (this.remoteServiceAdminRegistration != null) {
            this.remoteServiceAdminRegistration.unregister();
            this.remoteServiceAdminRegistration = null;
        }
        this.clearRSAs();
        if (this.endpointDescriptionAdvertiserRegistration != null) {
            this.endpointDescriptionAdvertiserRegistration.unregister();
            this.endpointDescriptionAdvertiserRegistration = null;
        }
        if (this.endpointDescriptionAdvertiser != null) {
            this.endpointDescriptionAdvertiser.close();
            this.endpointDescriptionAdvertiser = null;
        }
        Object object = this.saxParserFactoryTrackerLock;
        synchronized (object) {
            if (this.saxParserFactoryTracker != null) {
                this.saxParserFactoryTracker.close();
                this.saxParserFactoryTracker = null;
            }
        }
        object = this.logServiceTrackerLock;
        synchronized (object) {
            if (this.logServiceTracker != null) {
                this.logServiceTracker.close();
                this.logServiceTracker = null;
                this.logService = null;
            }
        }
        this.stopProxyServiceFactoryBundle();
        context = null;
        instance = null;
    }

    public boolean isOldEquinox() {
        if (context == null) {
            return false;
        }
        Bundle systemBundle = context.getBundle(0L);
        String systemBSN = systemBundle.getSymbolicName();
        if ("org.eclipse.osgi".equals(systemBSN)) {
            Version fixedVersion = new Version("3.7.0");
            Version systemVersion = systemBundle.getVersion();
            if (systemVersion.compareTo(fixedVersion) < 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFrameworkUUID() {
        if (context == null) {
            return null;
        }
        String string = "org.osgi.framework.uuid";
        synchronized ("org.osgi.framework.uuid") {
            String result = context.getProperty("org.osgi.framework.uuid");
            if (result == null) {
                UUID newUUID = UUID.randomUUID();
                result = newUUID.toString();
                System.setProperty("org.osgi.framework.uuid", newUUID.toString());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAXParserFactory getSAXParserFactory() {
        if (instance == null) {
            return null;
        }
        Object object = this.saxParserFactoryTrackerLock;
        synchronized (object) {
            if (this.saxParserFactoryTracker == null) {
                this.saxParserFactoryTracker = new ServiceTracker(context, SAXParserFactory.class.getName(), null);
                this.saxParserFactoryTracker.open();
            }
            return (SAXParserFactory)this.saxParserFactoryTracker.getService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogService getLogService() {
        if (context == null) {
            return null;
        }
        Object object = this.logServiceTrackerLock;
        synchronized (object) {
            if (this.logServiceTracker == null) {
                this.logServiceTracker = new ServiceTracker(context, LogService.class.getName(), null);
                this.logServiceTracker.open();
            }
            this.logService = (LogService)this.logServiceTracker.getService();
            if (this.logService == null) {
                this.logService = new SystemLogService(PLUGIN_ID);
            }
            return this.logService;
        }
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }
}

