/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DiscoveredEndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.DiscoveredEndpointDescriptionFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionReader;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IDiscoveredEndpointDescriptionFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionReader;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ServiceInfoFactory;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescriptionLocator {
    private BundleContext context;
    private IExecutor executor;
    private ServiceInfoFactory serviceInfoFactory;
    private ServiceRegistration defaultServiceInfoFactoryRegistration;
    private Object serviceInfoFactoryTrackerLock = new Object();
    private ServiceTracker serviceInfoFactoryTracker;
    private DiscoveredEndpointDescriptionFactory defaultEndpointDescriptionFactory;
    private ServiceRegistration defaultEndpointDescriptionFactoryRegistration;
    private Object endpointDescriptionFactoryTrackerLock = new Object();
    private ServiceTracker endpointDescriptionFactoryTracker;
    private ServiceRegistration defaultEndpointDescriptionReaderRegistration;
    private EventManager eventManager;
    private ListenerQueue eventQueue;
    private LocatorServiceListener localLocatorServiceListener;
    private ServiceTracker locatorServiceTracker;
    private Map<IDiscoveryLocator, LocatorServiceListener> locatorListeners;
    private ServiceTracker endpointListenerTracker;
    private ServiceTracker advertiserTracker;
    private Object advertiserTrackerLock = new Object();
    private BundleTracker bundleTracker;
    private EndpointDescriptionBundleTrackerCustomizer bundleTrackerCustomizer;
    private Object endpointListenerServiceTrackerLock = new Object();
    private List<IServiceID> serviceIDs = new ArrayList<IServiceID>();

    public EndpointDescriptionLocator(BundleContext context) {
        this.context = context;
        this.executor = new ThreadsExecutor();
    }

    public void start() {
        Properties properties = new Properties();
        properties.put("service.ranking", new Integer(Integer.MIN_VALUE));
        this.serviceInfoFactory = new ServiceInfoFactory();
        this.defaultServiceInfoFactoryRegistration = this.context.registerService(IServiceInfoFactory.class.getName(), (Object)this.serviceInfoFactory, (Dictionary)properties);
        this.defaultEndpointDescriptionFactory = new DiscoveredEndpointDescriptionFactory();
        this.defaultEndpointDescriptionFactoryRegistration = this.context.registerService(IDiscoveredEndpointDescriptionFactory.class.getName(), (Object)this.defaultEndpointDescriptionFactory, (Dictionary)properties);
        this.defaultEndpointDescriptionReaderRegistration = this.context.registerService(IEndpointDescriptionReader.class.getName(), (Object)new EndpointDescriptionReader(), (Dictionary)properties);
        ThreadGroup eventGroup = new ThreadGroup("RSA EndpointDescriptionLocator ThreadGroup");
        eventGroup.setDaemon(true);
        this.eventManager = new EventManager("RSA EndpointDescriptionLocator Dispatcher", eventGroup);
        this.eventQueue = new ListenerQueue(this.eventManager);
        CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
        listeners.put((Object)this, (Object)this);
        this.eventQueue.queueListeners(listeners.entrySet(), new EventDispatcher(){

            public void dispatchEvent(Object eventListener, Object listenerObject, int eventAction, Object eventObject) {
                String logMethodName = "dispatchEvent";
                EndpointListenerEvent event = (EndpointListenerEvent)eventObject;
                EndpointListener endpointListener = event.getEndpointListener();
                EndpointDescription endpointDescription = event.getEndointDescription();
                String matchingFilter = event.getMatchingFilter();
                try {
                    if (event.isDiscovered()) {
                        endpointListener.endpointAdded(endpointDescription, matchingFilter);
                    } else {
                        endpointListener.endpointRemoved(endpointDescription, matchingFilter);
                    }
                }
                catch (Exception e) {
                    String message = "Exception in EndpointListener listener=" + endpointListener + " description=" + endpointDescription + " matchingFilter=" + matchingFilter;
                    EndpointDescriptionLocator.this.logError("dispatchEvent", message, e);
                }
                catch (LinkageError e) {
                    String message = "LinkageError in EndpointListener listener=" + endpointListener + " description=" + endpointDescription + " matchingFilter=" + matchingFilter;
                    EndpointDescriptionLocator.this.logError("dispatchEvent", message, e);
                }
                catch (AssertionError e) {
                    String message = "AssertionError in EndpointListener listener=" + endpointListener + " description=" + endpointDescription + " matchingFilter=" + matchingFilter;
                    EndpointDescriptionLocator.this.logError("dispatchEvent", message, (Throwable)((Object)e));
                }
            }
        });
        this.endpointListenerTracker = new ServiceTracker(this.context, EndpointListener.class.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                if (EndpointDescriptionLocator.this.context == null) {
                    return null;
                }
                EndpointListener listener = (EndpointListener)EndpointDescriptionLocator.this.context.getService(reference);
                if (listener == null) {
                    return null;
                }
                Collection<EndpointDescription> allDiscoveredEndpointDescriptions = EndpointDescriptionLocator.this.getAllDiscoveredEndpointDescriptions();
                for (EndpointDescription ed : allDiscoveredEndpointDescriptions) {
                    EndpointListenerHolder[] endpointListenerHolders = EndpointDescriptionLocator.this.getMatchingEndpointListenerHolders(new ServiceReference[]{reference}, ed);
                    if (endpointListenerHolders == null) continue;
                    int i = 0;
                    while (i < endpointListenerHolders.length) {
                        EndpointDescriptionLocator.this.queueEndpointDescription(endpointListenerHolders[i].getListener(), endpointListenerHolders[i].getDescription(), endpointListenerHolders[i].getMatchingFilter(), true);
                        ++i;
                    }
                }
                return listener;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
            }
        });
        this.endpointListenerTracker.open();
        this.locatorListeners = new HashMap<IDiscoveryLocator, LocatorServiceListener>();
        this.localLocatorServiceListener = new LocatorServiceListener(null);
        this.locatorServiceTracker = new ServiceTracker(this.context, IDiscoveryLocator.class.getName(), (ServiceTrackerCustomizer)new LocatorTrackerCustomizer());
        this.locatorServiceTracker.open();
        this.bundleTrackerCustomizer = new EndpointDescriptionBundleTrackerCustomizer();
        this.bundleTracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)this.bundleTrackerCustomizer);
        this.bundleTracker.open();
    }

    private void logError(String methodName, String message, Throwable e) {
        LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message, e);
    }

    private void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.bundleTrackerCustomizer != null) {
            this.bundleTrackerCustomizer.close();
            this.bundleTrackerCustomizer = null;
        }
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            for (IDiscoveryLocator l : this.locatorListeners.keySet()) {
                LocatorServiceListener locatorListener = this.locatorListeners.get(l);
                if (locatorListener == null) continue;
                l.removeServiceListener((IServiceListener)locatorListener);
                locatorListener.close();
            }
            this.locatorListeners.clear();
        }
        Object[] locators = this.locatorServiceTracker.getServices();
        if (locators != null) {
            int i = 0;
            while (i < locators.length) {
                this.shutdownLocator((IDiscoveryLocator)locators[i]);
                ++i;
            }
        }
        if (this.localLocatorServiceListener != null) {
            this.localLocatorServiceListener.close();
            this.localLocatorServiceListener = null;
        }
        if (this.endpointListenerTracker != null) {
            this.endpointListenerTracker.close();
            this.endpointListenerTracker = null;
        }
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        Object object = this.endpointDescriptionFactoryTrackerLock;
        synchronized (object) {
            if (this.endpointDescriptionFactoryTracker != null) {
                this.endpointDescriptionFactoryTracker.close();
                this.endpointDescriptionFactoryTracker = null;
            }
        }
        if (this.defaultEndpointDescriptionFactoryRegistration != null) {
            this.defaultEndpointDescriptionFactoryRegistration.unregister();
            this.defaultEndpointDescriptionFactoryRegistration = null;
        }
        if (this.defaultEndpointDescriptionFactory != null) {
            this.defaultEndpointDescriptionFactory.close();
            this.defaultEndpointDescriptionFactory = null;
        }
        object = this.serviceInfoFactoryTrackerLock;
        synchronized (object) {
            if (this.serviceInfoFactoryTracker != null) {
                this.serviceInfoFactoryTracker.close();
                this.serviceInfoFactoryTracker = null;
            }
        }
        if (this.defaultServiceInfoFactoryRegistration != null) {
            this.defaultServiceInfoFactoryRegistration.unregister();
            this.defaultServiceInfoFactoryRegistration = null;
        }
        if (this.serviceInfoFactory != null) {
            this.serviceInfoFactory.close();
            this.serviceInfoFactory = null;
        }
        if (this.defaultEndpointDescriptionReaderRegistration != null) {
            this.defaultEndpointDescriptionReaderRegistration.unregister();
            this.defaultEndpointDescriptionReaderRegistration = null;
        }
        if (this.locatorServiceTracker != null) {
            this.locatorServiceTracker.close();
            this.locatorServiceTracker = null;
        }
        object = this.advertiserTrackerLock;
        synchronized (object) {
            if (this.advertiserTracker != null) {
                this.advertiserTracker.close();
                this.advertiserTracker = null;
            }
        }
        this.serviceIDs.clear();
        this.executor = null;
        this.context = null;
    }

    public IDiscoveryAdvertiser[] getDiscoveryAdvertisers() {
        return AccessController.doPrivileged(new PrivilegedAction<IDiscoveryAdvertiser[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IDiscoveryAdvertiser[] run() {
                Object object = EndpointDescriptionLocator.this.advertiserTrackerLock;
                synchronized (object) {
                    if (EndpointDescriptionLocator.this.advertiserTracker == null) {
                        EndpointDescriptionLocator.this.advertiserTracker = new ServiceTracker(EndpointDescriptionLocator.this.context, IDiscoveryAdvertiser.class.getName(), null);
                        EndpointDescriptionLocator.this.advertiserTracker.open();
                    }
                }
                ServiceReference[] advertiserRefs = EndpointDescriptionLocator.this.advertiserTracker.getServiceReferences();
                if (advertiserRefs == null) {
                    return null;
                }
                ArrayList<IDiscoveryAdvertiser> results = new ArrayList<IDiscoveryAdvertiser>();
                int i = 0;
                while (i < advertiserRefs.length) {
                    results.add((IDiscoveryAdvertiser)EndpointDescriptionLocator.this.context.getService(advertiserRefs[i]));
                    ++i;
                }
                return results.toArray(new IDiscoveryAdvertiser[results.size()]);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLocator(IDiscoveryLocator locator) {
        if (this.context == null) {
            return;
        }
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            LocatorServiceListener locatorListener = new LocatorServiceListener(locator);
            this.locatorListeners.put(locator, locatorListener);
            this.processInitialLocatorServices(locator, locatorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownLocator(IDiscoveryLocator locator) {
        if (locator == null || this.context == null) {
            return;
        }
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            LocatorServiceListener locatorListener = this.locatorListeners.remove(locator);
            if (locatorListener != null) {
                locatorListener.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEndpointDescription(EndpointListener listener, EndpointDescription endpointDescription, String matchingFilters, boolean discovered) {
        if (this.eventQueue == null) {
            return;
        }
        this.trace("queueEndpointDescription", "endpointDescription=" + endpointDescription);
        ListenerQueue listenerQueue = this.eventQueue;
        synchronized (listenerQueue) {
            this.eventQueue.dispatchEventAsynchronous(0, (Object)new EndpointListenerEvent(listener, endpointDescription, matchingFilters, discovered));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<EndpointDescription> getAllDiscoveredEndpointDescriptions() {
        ArrayList<EndpointDescription> result = new ArrayList<EndpointDescription>();
        if (this.localLocatorServiceListener == null) {
            return result;
        }
        result.addAll(this.localLocatorServiceListener.getEndpointDescriptions());
        Map<IDiscoveryLocator, LocatorServiceListener> map = this.locatorListeners;
        synchronized (map) {
            for (IDiscoveryLocator l : this.locatorListeners.keySet()) {
                LocatorServiceListener locatorListener = this.locatorListeners.get(l);
                result.addAll(locatorListener.getEndpointDescriptions());
            }
        }
        return result;
    }

    void queueEndpointDescription(EndpointDescription endpointDescription, boolean discovered) {
        EndpointListenerHolder[] endpointListenerHolders = this.getMatchingEndpointListenerHolders(endpointDescription);
        if (endpointListenerHolders != null) {
            int i = 0;
            while (i < endpointListenerHolders.length) {
                this.queueEndpointDescription(endpointListenerHolders[i].getListener(), endpointListenerHolders[i].getDescription(), endpointListenerHolders[i].getMatchingFilter(), discovered);
                ++i;
            }
        } else {
            LogUtility.logWarning("queueEndpointDescription", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), "No matching EndpointListeners found for " + (discovered ? "discovered" : "undiscovered") + " endpointDescription=" + endpointDescription);
        }
    }

    private void processInitialLocatorServices(final IDiscoveryLocator locator, final LocatorServiceListener locatorListener) {
        IProgressRunnable runnable = new IProgressRunnable(){

            public Object run(IProgressMonitor arg0) throws Exception {
                IServiceInfo[] serviceInfos = null;
                try {
                    serviceInfos = locator.getServices();
                }
                catch (Exception e) {
                    EndpointDescriptionLocator.this.logError("processInitialLocatorServices", "Exception in locator.getServices()", e);
                }
                if (serviceInfos != null) {
                    int i = 0;
                    while (i < serviceInfos.length) {
                        locatorListener.handleService(serviceInfos[i], true);
                        ++i;
                    }
                }
                return null;
            }
        };
        this.executor.execute(runnable, null);
    }

    void shutdownLocators() {
        Object[] locators = this.locatorServiceTracker.getServices();
        if (locators != null) {
            int i = 0;
            while (i < locators.length) {
                this.shutdownLocator((IDiscoveryLocator)locators[i]);
                ++i;
            }
        }
    }

    public IServiceInfoFactory getServiceInfoFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<IServiceInfoFactory>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IServiceInfoFactory run() {
                Object object = EndpointDescriptionLocator.this.serviceInfoFactoryTrackerLock;
                synchronized (object) {
                    if (EndpointDescriptionLocator.this.serviceInfoFactoryTracker == null) {
                        EndpointDescriptionLocator.this.serviceInfoFactoryTracker = new ServiceTracker(EndpointDescriptionLocator.this.context, IServiceInfoFactory.class.getName(), null);
                        EndpointDescriptionLocator.this.serviceInfoFactoryTracker.open();
                    }
                }
                return (IServiceInfoFactory)EndpointDescriptionLocator.this.serviceInfoFactoryTracker.getService();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDiscoveredEndpointDescriptionFactory getDiscoveredEndpointDescriptionFactory() {
        Object object = this.endpointDescriptionFactoryTrackerLock;
        synchronized (object) {
            block5: {
                if (this.context != null) break block5;
                return null;
            }
            if (this.endpointDescriptionFactoryTracker == null) {
                this.endpointDescriptionFactoryTracker = new ServiceTracker(this.context, IDiscoveredEndpointDescriptionFactory.class.getName(), null);
                this.endpointDescriptionFactoryTracker.open();
            }
            return (IDiscoveredEndpointDescriptionFactory)this.endpointDescriptionFactoryTracker.getService();
        }
    }

    protected EndpointListenerHolder[] getMatchingEndpointListenerHolders(final EndpointDescription description) {
        return AccessController.doPrivileged(new PrivilegedAction<EndpointListenerHolder[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EndpointListenerHolder[] run() {
                Object object = EndpointDescriptionLocator.this.endpointListenerServiceTrackerLock;
                synchronized (object) {
                    return EndpointDescriptionLocator.this.getMatchingEndpointListenerHolders(EndpointDescriptionLocator.this.endpointListenerTracker.getServiceReferences(), description);
                }
            }
        });
    }

    public EndpointListenerHolder[] getMatchingEndpointListenerHolders(ServiceReference[] refs, EndpointDescription description) {
        if (refs == null) {
            return null;
        }
        ArrayList<EndpointListenerHolder> results = new ArrayList<EndpointListenerHolder>();
        int i = 0;
        while (i < refs.length) {
            String matchingFilter;
            List filters;
            EndpointListener listener = (EndpointListener)this.context.getService(refs[i]);
            if (listener != null && (filters = PropertiesUtil.getStringPlusProperty(this.getMapFromProperties(refs[i]), "endpoint.listener.scope")).size() > 0 && (matchingFilter = this.isMatch(description, filters)) != null) {
                results.add(new EndpointListenerHolder(listener, description, matchingFilter));
            }
            ++i;
        }
        return results.toArray(new EndpointListenerHolder[results.size()]);
    }

    private String isMatch(EndpointDescription description, List<String> filters) {
        for (String filter : filters) {
            try {
                if (!description.matches(filter)) continue;
                return filter;
            }
            catch (IllegalArgumentException e) {
                this.logError("isMatch", "invalid endpoint listener filter=" + filters, e);
            }
        }
        return null;
    }

    private Map getMapFromProperties(ServiceReference ref) {
        TreeMap<String, Object> results = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        String[] keys = ref.getPropertyKeys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                results.put(keys[i], ref.getProperty(keys[i]));
                ++i;
            }
        }
        return results;
    }

    class EndpointDescriptionBundleTrackerCustomizer
    implements BundleTrackerCustomizer {
        private static final String REMOTESERVICE_MANIFESTHEADER = "Remote-Service";
        private static final String XML_FILE_PATTERN = "*.xml";
        private Map<Long, Collection<EndpointDescription>> bundleDescriptionMap = Collections.synchronizedMap(new HashMap());
        private Object endpointDescriptionReaderTrackerLock = new Object();
        private ServiceTracker endpointDescriptionReaderTracker;

        EndpointDescriptionBundleTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IEndpointDescriptionReader getEndpointDescriptionReader() {
            Object object = this.endpointDescriptionReaderTrackerLock;
            synchronized (object) {
                if (this.endpointDescriptionReaderTracker == null) {
                    this.endpointDescriptionReaderTracker = new ServiceTracker(EndpointDescriptionLocator.this.context, IEndpointDescriptionReader.class.getName(), null);
                    this.endpointDescriptionReaderTracker.open();
                }
            }
            return (IEndpointDescriptionReader)this.endpointDescriptionReaderTracker.getService();
        }

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            this.handleAddingBundle(bundle);
            return bundle;
        }

        private void handleAddingBundle(Bundle bundle) {
            String[] paths;
            if (EndpointDescriptionLocator.this.context == null) {
                return;
            }
            String remoteServicesHeaderValue = (String)bundle.getHeaders().get(REMOTESERVICE_MANIFESTHEADER);
            if (remoteServicesHeaderValue != null && (paths = remoteServicesHeaderValue.split(",")) != null) {
                int i = 0;
                while (i < paths.length) {
                    this.handleEndpointDescriptionPath(bundle, paths[i]);
                    ++i;
                }
            }
        }

        private void handleEndpointDescriptionPath(Bundle bundle, String remoteServicesHeaderValue) {
            if ("".equals(remoteServicesHeaderValue)) {
                return;
            }
            Enumeration e = null;
            if (remoteServicesHeaderValue.endsWith("/")) {
                e = bundle.findEntries(remoteServicesHeaderValue, XML_FILE_PATTERN, false);
            } else {
                int lastSlashIndex = remoteServicesHeaderValue.lastIndexOf(47);
                if (lastSlashIndex == -1) {
                    e = bundle.findEntries("/", remoteServicesHeaderValue, false);
                } else {
                    String path = remoteServicesHeaderValue.substring(0, lastSlashIndex);
                    if ("".equals(path)) {
                        path = "/";
                    }
                    String filePattern = remoteServicesHeaderValue.substring(lastSlashIndex + 1);
                    e = bundle.findEntries(path, filePattern, false);
                }
            }
            ArrayList<EndpointDescription> endpointDescriptions = new ArrayList<EndpointDescription>();
            if (e != null) {
                while (e.hasMoreElements()) {
                    EndpointDescription[] eps = this.handleEndpointDescriptionFile(bundle, (URL)e.nextElement());
                    if (eps == null) continue;
                    int i = 0;
                    while (i < eps.length) {
                        endpointDescriptions.add(eps[i]);
                        ++i;
                    }
                }
            }
            if (endpointDescriptions.size() > 0) {
                this.bundleDescriptionMap.put(new Long(bundle.getBundleId()), endpointDescriptions);
                for (EndpointDescription ed : endpointDescriptions) {
                    EndpointDescriptionLocator.this.localLocatorServiceListener.handleEndpointDescription(ed, true);
                }
            }
        }

        private EndpointDescription[] handleEndpointDescriptionFile(Bundle bundle, URL fileURL) {
            InputStream ins = null;
            try {
                IEndpointDescriptionReader endpointDescriptionReader = this.getEndpointDescriptionReader();
                if (endpointDescriptionReader == null) {
                    throw new NullPointerException("No endpointDescriptionReader available for handleEndpointDescriptionFile fileURL=" + fileURL);
                }
                ins = fileURL.openStream();
                EndpointDescription[] endpointDescriptionArray = endpointDescriptionReader.readEndpointDescriptions(ins);
                return endpointDescriptionArray;
            }
            catch (Exception e) {
                this.logError("handleEndpointDescriptionFile", "Exception creating endpoint descriptions from fileURL=" + fileURL, e);
                return null;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        this.logError("handleEndpointDescriptionFile", "Exception closing endpointDescription input fileURL=" + fileURL, e);
                    }
                }
            }
        }

        private void logError(String method, String message, Throwable t) {
            LogUtility.logError(method, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), (IStatus)new Status(4, "org.eclipse.ecf.osgi.services.remoteserviceadmin", 4, message, t));
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            this.handleRemovedBundle(bundle);
        }

        private void handleRemovedBundle(Bundle bundle) {
            Collection<EndpointDescription> endpointDescriptions = this.bundleDescriptionMap.remove(new Long(bundle.getBundleId()));
            if (endpointDescriptions != null) {
                for (EndpointDescription ed : endpointDescriptions) {
                    EndpointDescriptionLocator.this.localLocatorServiceListener.handleEndpointDescription(ed, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.endpointDescriptionReaderTrackerLock;
            synchronized (object) {
                if (this.endpointDescriptionReaderTracker != null) {
                    this.endpointDescriptionReaderTracker.close();
                    this.endpointDescriptionReaderTracker = null;
                }
            }
            this.bundleDescriptionMap.clear();
        }
    }

    private class EndpointListenerEvent {
        private EndpointListener endpointListener;
        private EndpointDescription endpointDescription;
        private String matchingFilter;
        private boolean discovered;

        public EndpointListenerEvent(EndpointListener endpointListener, EndpointDescription endpointDescription, String matchingFilter, boolean discovered) {
            this.endpointListener = endpointListener;
            this.endpointDescription = endpointDescription;
            this.matchingFilter = matchingFilter;
            this.discovered = discovered;
        }

        public EndpointListener getEndpointListener() {
            return this.endpointListener;
        }

        public EndpointDescription getEndointDescription() {
            return this.endpointDescription;
        }

        public String getMatchingFilter() {
            return this.matchingFilter;
        }

        public boolean isDiscovered() {
            return this.discovered;
        }
    }

    public class EndpointListenerHolder {
        private EndpointListener listener;
        private EndpointDescription description;
        private String matchingFilter;

        public EndpointListenerHolder(EndpointListener l, EndpointDescription d, String f) {
            this.listener = l;
            this.description = d;
            this.matchingFilter = f;
        }

        public EndpointListener getListener() {
            return this.listener;
        }

        public EndpointDescription getDescription() {
            return this.description;
        }

        public String getMatchingFilter() {
            return this.matchingFilter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocatorServiceListener
    implements IServiceListener {
        private Object listenerLock = new Object();
        private IDiscoveryLocator locator;
        private List<EndpointDescription> discoveredEndpointDescriptions = new ArrayList<EndpointDescription>();

        public LocatorServiceListener(IDiscoveryLocator locator) {
            this.locator = locator;
            if (locator != null) {
                this.locator.addServiceListener((IServiceListener)this);
            }
        }

        public void serviceDiscovered(IServiceEvent anEvent) {
            this.handleService(anEvent.getServiceInfo(), true);
        }

        public void serviceUndiscovered(IServiceEvent anEvent) {
            this.handleService(anEvent.getServiceInfo(), false);
        }

        private boolean matchServiceID(IServiceID serviceId) {
            return Arrays.asList(serviceId.getServiceTypeID().getServices()).contains("ecfosgirsvc");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleService(IServiceInfo serviceInfo, boolean discovered) {
            this.logInfo("handleService", "serviceInfo=" + serviceInfo + ",discovered=" + discovered);
            IServiceID serviceID = serviceInfo.getServiceID();
            if (this.matchServiceID(serviceID)) {
                List list = EndpointDescriptionLocator.this.serviceIDs;
                synchronized (list) {
                    if (discovered) {
                        if (EndpointDescriptionLocator.this.serviceIDs.contains(serviceID)) {
                            EndpointDescriptionLocator.this.trace("handleService", "Found serviceInfo with same serviceID=" + serviceID + "...ignoring");
                            return;
                        }
                        EndpointDescriptionLocator.this.serviceIDs.add(serviceID);
                    } else {
                        EndpointDescriptionLocator.this.serviceIDs.remove(serviceID);
                    }
                }
                this.handleOSGiServiceEndpoint(serviceID, serviceInfo, discovered);
            }
        }

        private void handleOSGiServiceEndpoint(IServiceID serviceId, IServiceInfo serviceInfo, boolean discovered) {
            if (this.locator == null) {
                return;
            }
            DiscoveredEndpointDescription discoveredEndpointDescription = this.getDiscoveredEndpointDescription(serviceId, serviceInfo, discovered);
            if (discoveredEndpointDescription != null) {
                this.handleEndpointDescription(discoveredEndpointDescription.getEndpointDescription(), discovered);
            } else {
                this.logWarning("handleOSGiServiceEvent", "discoveredEndpointDescription is null for service info=" + serviceInfo + ",discovered=" + discovered);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleEndpointDescription(EndpointDescription endpointDescription, boolean discovered) {
            Object object = this.listenerLock;
            synchronized (object) {
                if (discovered) {
                    if (this.discoveredEndpointDescriptions.contains(endpointDescription)) {
                        EndpointDescriptionLocator.this.trace("handleEndpointDescription", "endpointDescription previously discovered...ignoring");
                        return;
                    }
                    this.discoveredEndpointDescriptions.add(endpointDescription);
                } else {
                    this.discoveredEndpointDescriptions.remove(endpointDescription);
                }
                EndpointDescriptionLocator.this.queueEndpointDescription(endpointDescription, discovered);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<EndpointDescription> getEndpointDescriptions() {
            Object object = this.listenerLock;
            synchronized (object) {
                ArrayList<EndpointDescription> result = new ArrayList<EndpointDescription>();
                result.addAll(this.discoveredEndpointDescriptions);
                return result;
            }
        }

        private void logInfo(String methodName, String message) {
            LogUtility.logInfo(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message);
        }

        private void logWarning(String methodName, String message) {
            LogUtility.logWarning(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message);
        }

        private void logError(String methodName, String message, Throwable t) {
            LogUtility.logError(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionlocator", this.getClass(), message, t);
        }

        private DiscoveredEndpointDescription getDiscoveredEndpointDescription(IServiceID serviceId, IServiceInfo serviceInfo, boolean discovered) {
            String methodName = "getDiscoveredEndpointDescription";
            IDiscoveredEndpointDescriptionFactory factory = EndpointDescriptionLocator.this.getDiscoveredEndpointDescriptionFactory();
            try {
                return discovered ? factory.createDiscoveredEndpointDescription(this.locator, serviceInfo) : factory.removeDiscoveredEndpointDescription(this.locator, serviceId);
            }
            catch (Exception e) {
                this.logError("getDiscoveredEndpointDescription", "Exception calling IEndpointDescriptionFactory." + (discovered ? "createDiscoveredEndpointDescription" : "getUndiscoveredEndpointDescription"), e);
                return null;
            }
            catch (NoClassDefFoundError e) {
                this.logError("getDiscoveredEndpointDescription", "NoClassDefFoundError calling IEndpointDescriptionFactory." + (discovered ? "createDiscoveredEndpointDescription" : "getUndiscoveredEndpointDescription"), e);
                return null;
            }
        }

        public synchronized void close() {
            if (this.locator != null) {
                this.locator.removeServiceListener((IServiceListener)this);
                this.locator = null;
            }
            this.discoveredEndpointDescriptions.clear();
        }
    }

    private class LocatorTrackerCustomizer
    implements ServiceTrackerCustomizer {
        private LocatorTrackerCustomizer() {
        }

        public Object addingService(ServiceReference reference) {
            IDiscoveryLocator locator = (IDiscoveryLocator)EndpointDescriptionLocator.this.context.getService(reference);
            if (locator != null) {
                EndpointDescriptionLocator.this.openLocator(locator);
            }
            return locator;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            EndpointDescriptionLocator.this.shutdownLocator((IDiscoveryLocator)service);
        }
    }
}

