/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.collab.ui.console;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.internal.presence.collab.ui.Messages;
import org.eclipse.ecf.presence.collab.ui.AbstractCollabShare;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;

public class ConsoleShare
extends AbstractCollabShare {
    private static final Map consoleSharechannels = new Hashtable();
    static TextSelection selection = null;
    static boolean initialized = false;
    static final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection sel) {
            if (part instanceof IConsoleView && sel instanceof TextSelection) {
                TextSelection s = (TextSelection)sel;
                selection = s == null || s.getLength() == 0 ? null : (TextSelection)sel;
            }
        }
    };

    public static ConsoleShare getStackShare(ID containerID) {
        return (ConsoleShare)((Object)consoleSharechannels.get(containerID));
    }

    public static ConsoleShare addStackShare(ID containerID, IChannelContainerAdapter channelAdapter) throws ECFException {
        ConsoleShare.initialize();
        return consoleSharechannels.put(containerID, new ConsoleShare(channelAdapter));
    }

    private static void initialize() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!initialized) {
                    IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = ww.getActivePage();
                    page.addSelectionListener(selectionListener);
                    initialized = true;
                }
            }
        });
    }

    public static TextSelection getSelection() {
        return selection;
    }

    public static ConsoleShare removeStackShare(ID containerID) {
        return (ConsoleShare)((Object)consoleSharechannels.remove(containerID));
    }

    public ConsoleShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
    }

    private void handleShowConsoleSelection(final String user, final String consoleSelection) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (ww == null) {
                        throw new PartInitException(Messages.ConsoleShare_EXCEPTION_WW_NOT_AVAILABLE);
                    }
                    IWorkbenchPage wp = ww.getActivePage();
                    if (wp == null) {
                        throw new PartInitException(Messages.ConsoleShare_EXCEPTION_WP_NOT_AVAILABLE);
                    }
                    wp.showView("org.eclipse.ui.console.ConsoleView");
                    IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                    IConsole[] consoles = consoleManager.getConsoles();
                    if (consoles.length == 0) {
                        MessageDialog.openInformation(null, (String)NLS.bind((String)Messages.ConsoleShare_STACK_TRACE_FROM_TITLE, (Object)user), (String)NLS.bind((String)Messages.ConsoleShare_STACK_TRACE_FROM_MESSAGE, (Object)user));
                        return;
                    }
                    int i = 0;
                    while (i < consoles.length) {
                        String consoleType = consoles[i].getType();
                        if (consoleType != null && consoleType.equals("javaStackTraceConsole")) {
                            TextConsole textConsole = (TextConsole)consoles[i];
                            textConsole.activate();
                            IDocument document = textConsole.getDocument();
                            String text = String.valueOf(document.get()) + ConsoleShare.this.getConsoleSelectionToShow(user, consoleSelection);
                            document.set(text);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    ConsoleShare.this.logError(Messages.ConsoleShare_STACKSHARE_ERROR_LOG_MESSAGE, e);
                }
            }
        });
    }

    String getConsoleSelectionToShow(String user, String stackTrace) {
        return NLS.bind((String)Messages.ConsoleShare_STACK_TRACE_CONTENT, (Object)user, (Object)stackTrace);
    }

    public void sendShareConsoleSelection(final String senderuser, final ID toID, final String consoleSelection) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ConsoleShare.this.sendMessage(toID, ConsoleShare.this.serialize(new Object[]{senderuser, consoleSelection}));
                }
                catch (ECFException e) {
                    ConsoleShare.this.logError(e.getStatus());
                }
                catch (Exception e) {
                    ConsoleShare.this.logError(Messages.Share_EXCEPTION_LOG_SEND, e);
                }
            }
        });
    }

    protected void handleMessage(ID fromContainerID, byte[] data) {
        try {
            Object[] msg = (Object[])this.deserialize(data);
            this.handleShowConsoleSelection((String)msg[0], (String)msg[1]);
        }
        catch (Exception e) {
            this.logError(Messages.Share_EXCEPTION_LOG_MESSAGE, e);
        }
    }
}

