/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageEvent;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.ui.MessageNotificationPopup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class MessagesView
extends ViewPart {
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("(hh:mm:ss a)");
    public static final String VIEW_ID = "org.eclipse.ecf.presence.ui.MessagesView";
    private static final int[] WEIGHTS = new int[]{75, 25};
    private CTabFolder tabFolder;
    private Color redColor;
    private Color blueColor;
    private Map tabs = new HashMap();
    private boolean showTimestamps = true;
    static /* synthetic */ Class class$0;

    private static final String getUserName(ID id) {
        IChatID chatID;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.presence.im.IChatID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (chatID = (IChatID)id.getAdapter((Class)clazz)) == null ? id.getName() : chatID.getUsername();
    }

    public void createPartControl(Composite parent) {
        boolean useTraditionalTabFolder = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        this.tabFolder = new CTabFolder(parent, 64);
        this.tabFolder.setTabPosition(1024);
        this.tabFolder.setSimple(useTraditionalTabFolder);
        PlatformUI.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("SHOW_TRADITIONAL_STYLE_TABS") && !MessagesView.this.tabFolder.isDisposed()) {
                    MessagesView.this.tabFolder.setSimple(((Boolean)event.getNewValue()).booleanValue());
                    MessagesView.this.tabFolder.redraw();
                }
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator it = MessagesView.this.tabs.values().iterator();
                while (it.hasNext()) {
                    ChatTab tab = (ChatTab)it.next();
                    if (tab.item != e.item) continue;
                    tab.inputText.setFocus();
                    break;
                }
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent e) {
                Iterator it = MessagesView.this.tabs.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    ChatTab tab = (ChatTab)MessagesView.this.tabs.get(key);
                    if (tab.item != e.item) continue;
                    MessagesView.this.tabs.remove(key);
                    break;
                }
            }
        });
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        Action timestampAction = new Action(Messages.MessagesView_ShowTimestamps, 2){

            public void run() {
                MessagesView.this.showTimestamps = !MessagesView.this.showTimestamps;
            }
        };
        timestampAction.setChecked(true);
        Action clearChatLogAction = new Action(Messages.MessagesView_ClearChatLog){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CTabItem item = MessagesView.this.tabFolder.getSelection();
                if (item != null) {
                    Iterator iterator = MessagesView.this.tabs.values().iterator();
                    while (iterator.hasNext()) {
                        ChatTab tab = (ChatTab)iterator.next();
                        if (tab.item != item) continue;
                        if (MessageDialog.openConfirm((Shell)MessagesView.this.tabFolder.getShell(), (String)Messages.MessagesView_ClearChatLogDialogTitle, (String)NLS.bind((String)Messages.MessagesView_ClearChatLogDialogMessage, (Object)MessagesView.getUserName(tab.remoteID)))) {
                            ChatTab chatTab = tab;
                            synchronized (chatTab) {
                                tab.chatText.setText("");
                            }
                        }
                        return;
                    }
                }
            }
        };
        manager.add((IAction)clearChatLogAction);
        manager.add((IAction)timestampAction);
        this.redColor = new Color((Device)parent.getDisplay(), 255, 0, 0);
        this.blueColor = new Color((Device)parent.getDisplay(), 0, 0, 255);
    }

    public void dispose() {
        this.redColor.dispose();
        this.blueColor.dispose();
        super.dispose();
    }

    private ChatTab getTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID userID) {
        ChatTab tab = (ChatTab)this.tabs.get(userID);
        if (tab == null) {
            tab = new ChatTab(messageSender, typingSender, localID, userID);
            this.tabs.put(userID, tab);
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTypingNotification(ITypingMessageEvent event) {
        ChatTab tab = null;
        Map map = this.tabs;
        synchronized (map) {
            tab = (ChatTab)this.tabs.get(event.getFromID());
        }
        if (tab != null) {
            tab.showIsTyping(event.getTypingMessage().isTyping());
        }
    }

    public synchronized void openTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID remoteID) {
        Assert.isNotNull((Object)messageSender);
        Assert.isNotNull((Object)localID);
        Assert.isNotNull((Object)remoteID);
        ChatTab tab = this.getTab(messageSender, typingSender, localID, remoteID);
        if (this.tabs.size() == 1) {
            this.tabFolder.setSelection(tab.item);
        }
    }

    public synchronized void selectTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID userID) {
        ChatTab tab = this.getTab(messageSender, typingSender, localID, userID);
        this.tabFolder.setSelection(tab.item);
        tab.inputText.setFocus();
    }

    public synchronized void showMessage(IChatMessage message) {
        Assert.isNotNull((Object)message);
        ID remoteID = message.getFromID();
        ChatTab tab = (ChatTab)this.tabs.get(remoteID);
        if (tab != null) {
            tab.append(remoteID, message.getBody());
        }
    }

    public void setFocus() {
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            Iterator it = this.tabs.values().iterator();
            while (it.hasNext()) {
                ChatTab tab = (ChatTab)it.next();
                if (tab.item != item) continue;
                tab.inputText.setFocus();
                break;
            }
        }
    }

    private class ChatTab {
        private CTabItem item;
        private StyledText chatText;
        private Text inputText;
        private IChatMessageSender icms;
        private ITypingMessageSender itms;
        private ID localID;
        private ID remoteID;
        private boolean sendTyping = false;
        private boolean isFirstMessage = true;
        private SelectionListener scrollSelectionListener = new SelectionListener(this){
            final /* synthetic */ ChatTab this$1;
            {
                this.this$1 = chatTab;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChatTab.access$1(this.this$1, ChatTab.access$0(this.this$1))) {
                    ChatTab.access$2(this.this$1, false);
                }
            }
        };

        private ChatTab(IChatMessageSender icms, ITypingMessageSender itms, ID localID, ID remoteID) {
            this.icms = icms;
            this.itms = itms;
            this.localID = localID;
            this.remoteID = remoteID;
            this.constructWidgets();
            this.addListeners();
        }

        private void addListeners() {
            this.inputText.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ChatTab this$1;
                {
                    this.this$1 = chatTab;
                }

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 13: 
                        case 0x1000050: {
                            if (e.stateMask != 0) break;
                            String text = ChatTab.access$3(this.this$1).getText();
                            ChatTab.access$3(this.this$1).setText("");
                            try {
                                if (!text.equals("")) {
                                    ChatTab.access$4(this.this$1).sendChatMessage(ChatTab.access$5(this.this$1), text);
                                }
                                ChatTab.access$7(this.this$1, ChatTab.access$6(this.this$1), text);
                            }
                            catch (ECFException ex) {
                                String message = ex.getMessage();
                                if ((message == null || message.equals("")) && ((message = ex.getStatus().getMessage()) == null || message.equals(""))) {
                                    message = ex.getCause().getMessage();
                                }
                                if (message == null || message.equals("")) {
                                    MessagesView.access$0(ChatTab.access$15(this.this$1), Messages.MessagesView_CouldNotSendMessage);
                                }
                                MessagesView.access$0(ChatTab.access$15(this.this$1), NLS.bind((String)Messages.MessagesView_CouldNotSendMessageCauseKnown, (Object)message));
                            }
                            e.doit = false;
                            ChatTab.access$8(this.this$1, false);
                        }
                    }
                }
            });
            this.inputText.addModifyListener(new ModifyListener(this){
                final /* synthetic */ ChatTab this$1;
                {
                    this.this$1 = chatTab;
                }

                public void modifyText(ModifyEvent e) {
                    if (!ChatTab.access$9(this.this$1) && ChatTab.access$10(this.this$1) != null) {
                        ChatTab.access$8(this.this$1, true);
                        try {
                            ChatTab.access$10(this.this$1).sendTypingMessage(ChatTab.access$5(this.this$1), true, null);
                        }
                        catch (ECFException ex) {
                            return;
                        }
                    }
                }
            });
            ScrollBar vscrollBar = this.chatText.getVerticalBar();
            if (vscrollBar != null) {
                vscrollBar.addSelectionListener(this.scrollSelectionListener);
                this.chatText.addDisposeListener(new DisposeListener(this){
                    final /* synthetic */ ChatTab this$1;
                    {
                        this.this$1 = chatTab;
                    }

                    public void widgetDisposed(DisposeEvent e) {
                        ScrollBar bar = ChatTab.access$0(this.this$1).getVerticalBar();
                        if (bar != null) {
                            bar.removeSelectionListener(ChatTab.access$11(this.this$1));
                        }
                    }
                });
            }
        }

        private boolean shouldScrollToEnd(StyledText chatText1) {
            Point locAtEnd = chatText1.getLocationAtOffset(chatText1.getText().length());
            Rectangle bounds = chatText1.getBounds();
            return locAtEnd.y <= bounds.height + 5;
        }

        private void append(ID fromID, String body) {
            boolean scrollToEnd = this.shouldScrollToEnd(this.chatText);
            if (!this.isFirstMessage) {
                this.chatText.append(Text.DELIMITER);
            }
            int length = this.chatText.getCharCount();
            String name = MessagesView.getUserName(fromID);
            if (fromID.equals((Object)this.remoteID)) {
                if (MessagesView.this.showTimestamps) {
                    this.chatText.append(String.valueOf(FORMATTER.format(new Date(System.currentTimeMillis()))) + ' ');
                    this.chatText.setStyleRange(new StyleRange(length, 13, MessagesView.this.redColor, null));
                    length = this.chatText.getCharCount();
                }
                this.chatText.append(String.valueOf(name) + ": " + body);
                this.chatText.setStyleRange(new StyleRange(length, name.length() + 1, MessagesView.this.redColor, null, 1));
                MessagesView.this.setContentDescription("");
                if (this.isFirstMessage) {
                    MessageNotificationPopup popup = new MessageNotificationPopup(MessagesView.this.getSite().getWorkbenchWindow(), MessagesView.this.tabFolder.getShell(), this.remoteID);
                    popup.setContent(name, body);
                    popup.open();
                    new UIJob(this, MessagesView.this.tabFolder.getDisplay(), "Close Popup Job", popup){
                        final /* synthetic */ ChatTab this$1;
                        private final /* synthetic */ MessageNotificationPopup val$popup;
                        {
                            this.this$1 = chatTab;
                            this.val$popup = messageNotificationPopup;
                        }

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Shell shell = this.val$popup.getShell();
                            if (shell != null && !shell.isDisposed()) {
                                this.val$popup.close();
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule(5000L);
                }
            } else {
                if (MessagesView.this.showTimestamps) {
                    this.chatText.append(String.valueOf(FORMATTER.format(new Date(System.currentTimeMillis()))) + ' ');
                    this.chatText.setStyleRange(new StyleRange(length, 13, MessagesView.this.blueColor, null));
                    length = this.chatText.getCharCount();
                }
                this.chatText.append(String.valueOf(name) + ": " + body);
                this.chatText.setStyleRange(new StyleRange(length, name.length() + 1, MessagesView.this.blueColor, null, 1));
            }
            this.isFirstMessage = false;
            if (scrollToEnd) {
                this.chatText.invokeAction(17039368);
            }
            this.boldTabTitle(!scrollToEnd);
        }

        private StyledText createStyledTextWidget(Composite parent) {
            try {
                SourceViewer result = new SourceViewer(parent, null, null, true, 2634);
                result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
                result.setDocument((IDocument)new Document());
                return result.getTextWidget();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.presence.ui", 2, Messages.MessagesView_WARNING_HYPERLINKING_NOT_AVAILABLE, (Throwable)e));
                return new StyledText(parent, 2634);
            }
            catch (NoClassDefFoundError e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.presence.ui", 2, Messages.MessagesView_WARNING_HYPERLINKING_NOT_AVAILABLE, (Throwable)e));
                return new StyledText(parent, 2634);
            }
        }

        private void boldTabTitle(boolean bold) {
            Font oldFont = this.item.getFont();
            FontData[] fd = oldFont.getFontData();
            this.item.setFont(new Font(oldFont.getDevice(), fd[0].getName(), fd[0].getHeight(), bold ? 1 : 0));
        }

        private void constructWidgets() {
            this.item = new CTabItem(MessagesView.this.tabFolder, 0);
            Composite parent = new Composite((Composite)MessagesView.this.tabFolder, 0);
            parent.setLayout((Layout)new FillLayout());
            SashForm sash = new SashForm(parent, 512);
            this.chatText = this.createStyledTextWidget((Composite)sash);
            this.inputText = new Text((Composite)sash, 2562);
            sash.setWeights(WEIGHTS);
            Menu menu = new Menu((Control)this.chatText);
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(Messages.MessagesView_Copy);
            mi.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ChatTab this$1;
                {
                    this.this$1 = chatTab;
                }

                public void widgetSelected(SelectionEvent e) {
                    String text = ChatTab.access$0(this.this$1).getSelectionText();
                    if (!text.equals("")) {
                        ChatTab.access$0(this.this$1).copy();
                    }
                }
            });
            mi = new MenuItem(menu, 8);
            mi.setText(Messages.MessagesView_SelectAll);
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ChatTab this$1;
                {
                    this.this$1 = chatTab;
                }

                public void widgetSelected(SelectionEvent e) {
                    ChatTab.access$0(this.this$1).selectAll();
                }
            });
            this.chatText.setMenu(menu);
            this.item.setControl((Control)parent);
            this.item.setText(MessagesView.getUserName(this.remoteID));
        }

        private void showIsTyping(boolean isTyping) {
            MessagesView.this.setContentDescription(isTyping ? NLS.bind((String)Messages.MessagesView_TypingNotification, (Object)MessagesView.getUserName(this.remoteID)) : "");
        }

        static /* synthetic */ boolean access$1(ChatTab chatTab, StyledText styledText) {
            return chatTab.shouldScrollToEnd(styledText);
        }

        static /* synthetic */ void access$2(ChatTab chatTab, boolean bl) {
            chatTab.boldTabTitle(bl);
        }

        static /* synthetic */ IChatMessageSender access$4(ChatTab chatTab) {
            return chatTab.icms;
        }

        static /* synthetic */ ID access$6(ChatTab chatTab) {
            return chatTab.localID;
        }

        static /* synthetic */ void access$8(ChatTab chatTab, boolean bl) {
            chatTab.sendTyping = bl;
        }

        static /* synthetic */ boolean access$9(ChatTab chatTab) {
            return chatTab.sendTyping;
        }

        static /* synthetic */ ITypingMessageSender access$10(ChatTab chatTab) {
            return chatTab.itms;
        }

        static /* synthetic */ SelectionListener access$11(ChatTab chatTab) {
            return chatTab.scrollSelectionListener;
        }

        static /* synthetic */ MessagesView access$15(ChatTab chatTab) {
            return chatTab.MessagesView.this;
        }
    }
}

