/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.scp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.internal.provider.filetransfer.scp.IScpFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.scp.Messages;
import org.eclipse.ecf.internal.provider.filetransfer.scp.ScpUtil;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.osgi.util.NLS;

public class ScpRetrieveFileTransfer
extends AbstractRetrieveFileTransfer
implements IScpFileTransfer {
    private static final String SCP_COMMAND = System.getProperty("org.eclipse.ecf.filetransfer.scp.retrieve.scpcommand", "scp -f ");
    private static final String SCP_EXEC = System.getProperty("org.eclipse.ecf.filetransfer.scp.retrieve.scpcommand", "exec");
    String username;
    Channel channel;
    OutputStream responseStream;
    private ScpUtil scpUtil;
    static /* synthetic */ Class class$0;

    protected boolean doPause() {
        return false;
    }

    protected boolean doResume() {
        return false;
    }

    public URL getTargetURL() {
        return this.getRemoteFileURL();
    }

    public Map getOptions() {
        return this.options;
    }

    protected void openStreams() throws IncomingFileTransferException {
        try {
            URL url = this.getRemoteFileURL();
            this.username = url.getUserInfo();
            this.scpUtil = new ScpUtil(this);
            Session s = this.scpUtil.getSession();
            s.connect();
            String command = String.valueOf(SCP_COMMAND) + this.scpUtil.trimTargetFile(url.getPath());
            this.channel = s.openChannel(SCP_EXEC);
            ((ChannelExec)this.channel).setCommand(command);
            this.channel.connect();
            InputStream ins = this.channel.getInputStream();
            this.responseStream = this.channel.getOutputStream();
            this.scpUtil.sendZeroToStream(this.responseStream);
            int c = ScpRetrieveFileTransfer.checkAck(ins);
            if (c != 67) {
                throw new IOException(Messages.ScpRetrieveFileTransfer_EXCEPTION_SCP_PROTOCOL);
            }
            byte[] buf = new byte[1024];
            ins.read(buf, 0, 5);
            this.setFileLength(this.readFileSize(ins, buf));
            this.readFileName(ins, buf);
            this.remoteFileContents = ins;
            this.scpUtil.sendZeroToStream(this.responseStream);
            this.fireReceiveStartEvent();
        }
        catch (Exception e) {
            this.channel = null;
            this.username = null;
            throw new IncomingFileTransferException(NLS.bind((String)Messages.ScpRetrieveFileTransfer_EXCEPTION_CONNECTING, (Object)this.getRemoteFileURL().toString()), (Throwable)e);
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1 || b == 2) {
                throw new IOException(String.valueOf(Messages.ScpRetrieveFileTransfer_EXCEPTION_SCP_PROTOCOL) + ": " + sb.toString());
            }
        }
        return b;
    }

    protected void handleReceivedData(byte[] buf, int bytes, double factor, IProgressMonitor monitor) throws IOException {
        if (bytes == -1) {
            this.done = true;
        } else {
            int fileBytes = bytes;
            if (this.bytesReceived + (long)bytes > this.fileLength) {
                fileBytes = (int)(this.fileLength - this.bytesReceived);
            }
            this.bytesReceived += (long)fileBytes;
            this.localFileContents.write(buf, 0, fileBytes);
            this.fireTransferReceiveDataEvent();
            monitor.worked((int)Math.round(factor * (double)fileBytes));
            if (fileBytes != bytes) {
                this.scpUtil.checkAck(buf[fileBytes], this.remoteFileContents);
                this.done = true;
            }
        }
    }

    private long readFileSize(InputStream ins, byte[] buf) throws IOException {
        long filesize = 0L;
        while (true) {
            if (ins.read(buf, 0, 1) < 0) {
                throw new IOException(Messages.ScpRetrieveFileTransfer_EXCEPTION_ERROR_READING_FILE);
            }
            if (buf[0] == 32) break;
            filesize = filesize * 10L + (long)(buf[0] - 48);
        }
        return filesize;
    }

    private String readFileName(InputStream ins, byte[] buf) throws IOException {
        String file = null;
        int i = 0;
        while (true) {
            ins.read(buf, i, 1);
            if (buf[i] == 10) break;
            ++i;
        }
        file = new String(buf, 0, i);
        return file;
    }

    protected void hardClose() {
        try {
            try {
                if (this.remoteFileContents != null && this.scpUtil != null) {
                    this.scpUtil.sendZeroToStream(this.responseStream);
                    this.scpUtil.dispose();
                    this.scpUtil = null;
                    this.remoteFileContents = null;
                    this.responseStream = null;
                }
            }
            catch (IOException e) {
                this.exception = e;
                super.hardClose();
                this.channel = null;
                this.username = null;
            }
        }
        finally {
            super.hardClose();
            this.channel = null;
            this.username = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.IFileTransferPausable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return null;
        }
        return super.getAdapter(adapter);
    }

    protected void setupProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public IConnectContext getConnectContext() {
        return this.connectContext;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean promptPassphrase() {
        return false;
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

